/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeEntry;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.ItemUtils;
import cofh.util.MathHelper;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.device.ItemBlockTank;
import thermalexpansion.core.TEProps;
import thermalexpansion.util.energy.IPowerProviderAdv;
import thermalexpansion.util.energy.PowerProviderAdv;

public class Utils {
    public static Random rand;
    public static LiquidTank dummyTank;
    public static PowerProviderAdv dummyProvider;

    public static int addToAdjInventory(TileEntity tile, int from, ItemStack theStack) {
        return Utils.addToAdjInventory(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, tile.field_70331_k, from, theStack);
    }

    public static int addToAdjInventory(int xCoord, int yCoord, int zCoord, World worldObj, int from, ItemStack theStack) {
        block9: {
            int i;
            TileEntity tileInventory;
            block8: {
                int i2;
                int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)xCoord, (int)yCoord, (int)zCoord, (int)from);
                tileInventory = worldObj.func_72796_p(coords[0], coords[1], coords[2]);
                if (!(tileInventory instanceof ISidedInventory)) break block8;
                ISidedInventory theInventory = (ISidedInventory)tileInventory;
                int side = BlockUtils.SIDE_OPPOSITE[from];
                int[] slots = theInventory.func_94128_d(side);
                if (slots.length < 128) {
                    for (i2 = 0; i2 < slots.length; ++i2) {
                        if (!theInventory.func_102007_a(slots[i2], theStack, side)) continue;
                        ItemStack theStackInSlot = theInventory.func_70301_a(slots[i2]);
                        if (theStackInSlot != null && theStackInSlot.func_77969_a(theStack)) {
                            theStack = CoreUtils.addToInventorySlot((IInventory)theInventory, (int)slots[i2], (ItemStack)theStack);
                        }
                        if (theStack != null) continue;
                        return 0;
                    }
                }
                for (i2 = 0; i2 < slots.length; ++i2) {
                    if (!theInventory.func_102007_a(slots[i2], theStack, side) || (theStack = CoreUtils.addToInventorySlot((IInventory)theInventory, (int)slots[i2], (ItemStack)theStack)) != null) continue;
                    return 0;
                }
                break block9;
            }
            if (!(tileInventory instanceof IInventory)) break block9;
            IInventory theInventory = (IInventory)tileInventory;
            if (theInventory.func_70302_i_() < 128) {
                for (i = 0; i < theInventory.func_70302_i_(); ++i) {
                    ItemStack theStackInSlot = theInventory.func_70301_a(i);
                    if (theStackInSlot != null && theStackInSlot.func_77969_a(theStack)) {
                        theStack = CoreUtils.addToInventorySlot((IInventory)theInventory, (int)i, (ItemStack)theStack);
                    }
                    if (theStack != null) continue;
                    return 0;
                }
            }
            for (i = 0; i < theInventory.func_70302_i_(); ++i) {
                if ((theStack = CoreUtils.addToInventorySlot((IInventory)theInventory, (int)i, (ItemStack)theStack)) != null) continue;
                return 0;
            }
        }
        return theStack.field_77994_a;
    }

    public static boolean addToAdjPipe(TileEntity aTile, int from, ItemStack theStack) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)aTile.field_70329_l, (int)aTile.field_70330_m, (int)aTile.field_70327_n, (int)from);
        TileEntity theTile = aTile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (theTile instanceof IPipeEntry && ((IPipeEntry)theTile).acceptItems()) {
            ((IPipeEntry)theTile).entityEntering(theStack, ForgeDirection.VALID_DIRECTIONS[from]);
            return true;
        }
        return false;
    }

    public static float addToAdjPowerProvider(TileEntity aTile, int from, float maxAdd) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)aTile.field_70329_l, (int)aTile.field_70330_m, (int)aTile.field_70327_n, (int)from);
        TileEntity theTile = aTile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (Utils.isPoweredTile(theTile)) {
            IPowerProvider tilePP = ((IPowerReceptor)theTile).getPowerProvider();
            float powerRequested = ((IPowerReceptor)theTile).powerRequest(ForgeDirection.VALID_DIRECTIONS[from]);
            if (powerRequested > 0.0f) {
                float adjustedEnergyRequest = MathHelper.minF((float)powerRequested, (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()));
                float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)maxAdd);
                tilePP.receiveEnergy(energyMax, ForgeDirection.VALID_DIRECTIONS[from].getOpposite());
                return energyMax;
            }
        }
        return 0.0f;
    }

    public static int addToAdjTank(TileEntity tile, int from, LiquidStack theLiquid, boolean doFill) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity theTile = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (theTile instanceof ITankContainer) {
            return ((ITankContainer)theTile).fill(ForgeDirection.VALID_DIRECTIONS[from].getOpposite(), theLiquid, doFill);
        }
        return 0;
    }

    public static boolean fillTankWithContainer(ITankContainer theTile, EntityPlayer player) {
        ItemStack theContainer = player.func_71045_bC();
        LiquidStack theLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)theContainer);
        if (theLiquid != null && (theTile.fill(ForgeDirection.UNKNOWN, theLiquid, false) == theLiquid.amount || player.field_71075_bZ.field_75098_d)) {
            if (CoreUtils.isClientWorld((World)((TileEntity)theTile).field_70331_k)) {
                return true;
            }
            theTile.fill(ForgeDirection.UNKNOWN, theLiquid, true);
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemUtils.consumeItem((ItemStack)theContainer));
            }
            return true;
        }
        return false;
    }

    public static boolean emptyTankIntoContainer(ITankContainer theTile, EntityPlayer player, LiquidStack tankLiquid) {
        ItemStack theContainer = player.func_71045_bC();
        if (LiquidContainerRegistry.isEmptyContainer((ItemStack)theContainer)) {
            ItemStack returnStack = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)tankLiquid, (ItemStack)theContainer);
            LiquidStack theLiquid = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)returnStack);
            if (theLiquid == null || returnStack == null) {
                return false;
            }
            if (!player.field_71075_bZ.field_75098_d) {
                if (theContainer.field_77994_a == 1) {
                    theContainer = theContainer.func_77946_l();
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, returnStack);
                } else if (!player.field_71071_by.func_70441_a(returnStack)) {
                    return false;
                }
                theTile.drain(ForgeDirection.UNKNOWN, theLiquid.amount, true);
                --theContainer.field_77994_a;
                if (theContainer.field_77994_a <= 0) {
                    theContainer = null;
                }
            } else {
                theTile.drain(ForgeDirection.UNKNOWN, theLiquid.amount, true);
            }
            return true;
        }
        return false;
    }

    public static boolean isAdjacentInventory(TileEntity tile, int from) {
        return Utils.isAdjacentInventory(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, tile.field_70331_k, from);
    }

    public static boolean isAdjacentInventory(int xCoord, int yCoord, int zCoord, World worldObj, int from) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)xCoord, (int)yCoord, (int)zCoord, (int)from);
        TileEntity tileInventory = worldObj.func_72796_p(coords[0], coords[1], coords[2]);
        if (tileInventory instanceof TileEntityFurnace && from > 1) {
            return false;
        }
        if (tileInventory instanceof ISidedInventory && ((ISidedInventory)tileInventory).func_94128_d(BlockUtils.SIDE_OPPOSITE[from]).length <= 0) {
            return false;
        }
        return tileInventory instanceof IInventory && ((IInventory)tileInventory).func_70302_i_() > 0;
    }

    public static boolean isAdjacentPipe(TileEntity tile, int from) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity tilePipe = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        return tilePipe instanceof IPipeEntry;
    }

    public static boolean isAdjacentPoweredTile(TileEntity tile, int from) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity adjTile = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        return Utils.isPoweredTile(adjTile);
    }

    public static boolean isAdjacentTank(TileEntity tile, int from) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity adjTile = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (adjTile instanceof ITankContainer) {
            return ((ITankContainer)adjTile).getTanks(ForgeDirection.VALID_DIRECTIONS[from].getOpposite()) != null && ((ITankContainer)adjTile).getTanks(ForgeDirection.VALID_DIRECTIONS[from].getOpposite()).length > 0;
        }
        return false;
    }

    public static boolean isHoldingWrench(EntityPlayer player) {
        return player.func_71045_bC() != null ? Boolean.valueOf(player.func_71045_bC().func_77973_b() instanceof IToolWrench) : null;
    }

    public static boolean isHoldingUsableWrench(EntityPlayer player, int x, int y, int z) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, x, y, z);
    }

    public static boolean isPoweredTile(TileEntity tile) {
        if (tile instanceof IPowerReceptor) {
            IPowerProvider provider = ((IPowerReceptor)tile).getPowerProvider();
            return provider != null;
        }
        return false;
    }

    public static boolean isPoweredTileAdv(TileEntity tile) {
        if (tile instanceof IPowerReceptor) {
            IPowerProvider provider = ((IPowerReceptor)tile).getPowerProvider();
            return provider instanceof IPowerProviderAdv;
        }
        return false;
    }

    public static void alertPlayerWolves(EntityPlayer player, EntityLiving par1EntityLiving, boolean par2) {
        if (!(par1EntityLiving instanceof EntityCreeper) && !(par1EntityLiving instanceof EntityGhast)) {
            EntityWolf var3;
            if (par1EntityLiving instanceof EntityWolf && (var3 = (EntityWolf)par1EntityLiving).func_70909_n() && player.field_71092_bJ.equals(var3.func_70905_p())) {
                return;
            }
            if (!(par1EntityLiving instanceof EntityPlayer)) {
                List var6 = player.field_70170_p.func_72872_a(EntityWolf.class, AxisAlignedBB.func_72332_a().func_72299_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, player.field_70165_t + 1.0, player.field_70163_u + 1.0, player.field_70161_v + 1.0).func_72314_b(16.0, 4.0, 16.0));
                for (EntityWolf var5 : var6) {
                    if (!var5.func_70909_n() || var5.func_70777_m() != null || !player.field_71092_bJ.equals(var5.func_70905_p()) || par2 && var5.func_70906_o()) continue;
                    var5.func_70904_g(false);
                    var5.func_70784_b((Entity)par1EntityLiving);
                }
            }
        }
    }

    public static boolean addLiquidToPlayer(InventoryPlayer inv, ItemStack bucket, LiquidStack myData) {
        if (bucket != null) {
            myData = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)bucket);
        }
        int emptyTankID = -1;
        if (myData == null) {
            return false;
        }
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null || !(inv.func_70301_a(i).func_77973_b() instanceof ItemBlockTank)) continue;
            if (inv.func_70301_a((int)i).field_77990_d != null && inv.func_70301_a((int)i).field_77990_d.func_74762_e("liquid.itemID") == myData.itemID && inv.func_70301_a((int)i).field_77990_d.func_74762_e("liquid.itemMeta") == myData.itemMeta) {
                int amount = inv.func_70301_a((int)i).field_77990_d.func_74762_e("liquid.amount");
                if (amount + myData.amount > 8000) continue;
                inv.func_70301_a((int)i).field_77990_d.func_74768_a("liquid.amount", amount + myData.amount);
                return true;
            }
            if (emptyTankID == -1 && inv.func_70301_a((int)i).field_77990_d != null && inv.func_70301_a((int)i).field_77990_d.func_74762_e("liquid.itemID") <= 0) {
                emptyTankID = i;
                continue;
            }
            if (emptyTankID != -1 || inv.func_70301_a((int)i).field_77990_d != null) continue;
            emptyTankID = i;
        }
        if (emptyTankID != -1) {
            if (inv.func_70301_a((int)emptyTankID).field_77990_d == null) {
                inv.func_70301_a(emptyTankID).func_77982_d(new NBTTagCompound());
            }
            inv.func_70301_a((int)emptyTankID).field_77990_d.func_74768_a("liquid.itemID", myData.itemID);
            inv.func_70301_a((int)emptyTankID).field_77990_d.func_74768_a("liquid.amount", myData.amount);
            inv.func_70301_a((int)emptyTankID).field_77990_d.func_74768_a("liquid.itemMeta", myData.itemMeta);
            return true;
        }
        return false;
    }

    public static boolean addLiquidToTank(ItemStack theTank, ItemStack bucket, LiquidStack myData) {
        if (bucket != null) {
            myData = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)bucket);
        }
        if (myData == null) {
            return false;
        }
        if (theTank.func_77973_b() instanceof ItemBlockTank) {
            if (theTank.field_77990_d != null && theTank.field_77990_d.func_74762_e("liquid.itemID") == myData.itemID && theTank.field_77990_d.func_74762_e("liquid.itemMeta") == myData.itemMeta) {
                int amount = theTank.field_77990_d.func_74762_e("liquid.amount");
                if (amount + myData.amount <= 8000) {
                    theTank.field_77990_d.func_74768_a("liquid.amount", amount + myData.amount);
                    return true;
                }
            } else if (theTank.field_77990_d == null) {
                theTank.func_77982_d(new NBTTagCompound());
                theTank.field_77990_d.func_74768_a("liquid.itemID", myData.itemID);
                theTank.field_77990_d.func_74768_a("liquid.amount", myData.amount);
                theTank.field_77990_d.func_74768_a("liquid.itemMeta", myData.itemMeta);
                return true;
            }
        }
        return false;
    }

    public static LiquidStack getTankLiquid(ItemStack theTank) {
        int amount;
        if (theTank.func_77973_b() instanceof ItemBlockTank && theTank.field_77990_d != null && (amount = theTank.field_77990_d.func_74762_e("liquid.amount")) > 0) {
            return new LiquidStack(theTank.field_77990_d.func_74762_e("liquid.itemID"), amount, theTank.field_77990_d.func_74762_e("liquid.itemMeta"));
        }
        return null;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean par3) {
        float var4 = 1.0f;
        float var5 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * var4;
        float var6 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * var4;
        double var7 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)var4;
        double var9 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)var4 + 1.62 - (double)player.field_70129_M;
        double var11 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)var4;
        Vec3 var13 = world.func_82732_R().func_72345_a(var7, var9, var11);
        float var14 = net.minecraft.util.MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = net.minecraft.util.MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -net.minecraft.util.MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = net.minecraft.util.MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (player instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return world.func_72831_a(var13, var23, par3, !par3);
    }

    public static void wrenchOutput(String playerName, int BlockID, int BlockMeta, double x, double y, double z) {
        if (TEProps.enableWrenchLogging) {
            ThermalExpansion.log.log(Level.INFO, "Player " + playerName + " wrenched " + " (" + BlockID + ":" + BlockMeta + ") at (" + x + "," + y + "," + z + ")");
        }
    }

    static {
        dummyTank = new LiquidTank(0);
        dummyProvider = new PowerProviderAdv();
    }
}

