/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.LightModel;
import cofh.render.RenderUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidRegistry;
import cpw.mods.fml.client.registry.ClientRegistry;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.device.TileTankPortable;

public class RenderTank
extends TileEntitySpecialRenderer
implements IItemRenderer {
    public static RenderTank instance = new RenderTank();
    static String texture;
    static CCModel[] liquid_models;
    static CCModel top_model;
    static CCModel[] side_models;
    static CCModel[] bottom_models;

    public static void initialize() {
        texture = "/mods/thermalexpansion/textures/blocks/Tank_Portable.png";
    }

    private static void generateLiquidModels() {
        double minXZ = 0.1975;
        double maxXZ = 0.8025;
        double minY = 0.0625;
        double maxY = 1.0 - minY;
        double increment = (maxY - minY) / 100.0;
        for (int i = 1; i < 101; ++i) {
            double yLevel = minY + increment * (double)i;
            RenderTank.liquid_models[i - 1] = CCModel.quadModel((int)24).generateBlock(0, minXZ, minY, minXZ, maxXZ, yLevel, maxXZ).computeNormals();
        }
    }

    private static void generateModels() {
        top_model.generateSlice(0, 0, -6.0, 7.0, -6.0, 12.0, 1.0, 12.0, 0.0, 12.0, 64.0, 64.0, 16.0).computeNormals().computeLighting(LightModel.standardLightModel);
        CCModel side_model = CCModel.quadModel((int)8).generateSlice(0, 1, -6.0, -8.0, -6.0, 12.0, 16.0, 1.0, 0.0, 32.0, 64.0, 64.0, 16.0);
        RenderTank.side_models[0] = CCModel.generateWalls((CCModel)side_model).computeNormals().computeLighting(LightModel.standardLightModel);
        side_model = CCModel.quadModel((int)8).generateSlice(0, 1, -6.0, -8.0, -6.0, 12.0, 16.0, 1.0, 32.0, 32.0, 64.0, 64.0, 16.0);
        RenderTank.side_models[1] = CCModel.generateWalls((CCModel)side_model).computeNormals().computeLighting(LightModel.standardLightModel);
        RenderTank.bottom_models[0] = CCModel.quadModel((int)8);
        RenderTank.bottom_models[1] = CCModel.quadModel((int)8);
        bottom_models[0].generateSlice(0, 0, -6.0, -8.0, -6.0, 12.0, 1.0, 12.0, 0.0, 0.0, 64.0, 64.0, 16.0).computeNormals().computeLighting(LightModel.standardLightModel);
        bottom_models[1].generateSlice(0, 0, -6.0, -8.0, -6.0, 12.0, 1.0, 12.0, 32.0, 0.0, 64.0, 64.0, 16.0).computeNormals().computeLighting(LightModel.standardLightModel);
    }

    public void render(boolean mode, double x, double y, double z) {
        CCRenderState.startDrawing((int)7);
        RenderUtils.bindTexture((String)texture);
        top_model.render(x + 0.5, y + 0.5, z + 0.5, 0.0, 12.0);
        if (mode) {
            side_models[1].render(x + 0.5, y + 0.5, z + 0.5, 32.0, 32.0);
            bottom_models[1].render(x + 0.5, y + 0.5, z + 0.5, 32.0, 0.0);
        } else {
            side_models[0].render(x + 0.5, y + 0.5, z + 0.5, 0.0, 32.0);
            bottom_models[0].render(x + 0.5, y + 0.5, z + 0.5, 0.0, 0.0);
        }
        CCRenderState.draw();
    }

    public void renderLiquid(boolean setColor, LiquidStack liquid, double x, double y, double z) {
        if (liquid == null || liquid.amount <= 0 || liquid.itemID <= 0) {
            return;
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.startDrawing((int)7);
        if (setColor) {
            RenderUtils.setLiquidRenderColor((LiquidStack)liquid);
        }
        RenderUtils.setLiquidTextureSheet((LiquidStack)liquid);
        Icon liquidTex = RenderUtils.getLiquidTexture((LiquidStack)liquid);
        int level = 99;
        if (LiquidRegistry.isLiquidCompressible((LiquidStack)liquid)) {
            int alpha = 128 * liquid.amount / 8000;
            CCRenderState.setColour((int)(-224 + alpha));
            liquid_models[level].render(x, y, z, liquidTex);
        } else {
            level = MathHelper.minI((int)99, (int)(liquid.amount * 100 / 8000));
        }
        liquid_models[level].render(x, y, z, liquidTex);
        CCRenderState.draw();
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
    }

    public void func_76894_a(TileEntity entity, double x, double y, double z, float f) {
        RenderUtils.preRender();
        TileTankPortable theTile = (TileTankPortable)entity;
        this.render(theTile.mode, x, y, z);
        this.renderLiquid(true, theTile.getTankLiquid(), x, y, z);
        CCRenderState.useNormals((boolean)false);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            offset = 0.0;
        }
        LiquidStack theLiquid = null;
        if (item.field_77990_d != null) {
            theLiquid = new LiquidStack(item.field_77990_d.func_74762_e("liquid.itemID"), item.field_77990_d.func_74762_e("liquid.amount"), item.field_77990_d.func_74762_e("liquid.itemMeta"));
        }
        RenderUtils.preRender();
        instance.render(false, offset, offset, offset);
        instance.renderLiquid(false, theLiquid, offset, offset, offset);
        CCRenderState.useNormals((boolean)false);
    }

    static {
        liquid_models = new CCModel[100];
        top_model = CCModel.quadModel((int)8);
        side_models = new CCModel[2];
        bottom_models = new CCModel[2];
        ClientRegistry.bindTileEntitySpecialRenderer(TileTankPortable.class, (TileEntitySpecialRenderer)instance);
        RenderTank.generateLiquidModels();
        RenderTank.generateModels();
    }
}

