/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.IUVTransformation;
import cofh.codechicken.core.render.IconTransformation;
import cofh.codechicken.core.render.LightModel;
import cofh.codechicken.core.vec.ITransformation;
import cofh.codechicken.core.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import thermalexpansion.block.plate.TilePlateRoot;
import thermalexpansion.core.TEProps;

public class RenderPlate
implements ISimpleBlockRenderingHandler {
    public static RenderPlate instance = new RenderPlate();
    static Icon[] texture = new Icon[7];
    static Icon[] texture_liquid = new Icon[3];
    static CCModel side_model;

    public static void initialize() {
        RenderPlate.texture_liquid[0] = IconRegistry.getIcon((String)"LiquidRedstone");
        RenderPlate.texture_liquid[1] = IconRegistry.getIcon((String)"LiquidGlowstone");
        RenderPlate.texture_liquid[2] = IconRegistry.getIcon((String)"LiquidEnder");
        RenderPlate.texture[6] = IconRegistry.getIcon((String)"PlateBottom");
        for (int i = 0; i < 6; ++i) {
            RenderPlate.texture[i] = IconRegistry.getIcon((String)"PlateTop", (int)i);
        }
    }

    private static void generateModels() {
        double d = 0.0;
        side_model = CCModel.quadModel((int)24).generateBlock(0, d, d, d, 1.0 - d, 0.0625, 1.0 - d).computeNormals().computeLighting(LightModel.standardLightModel);
    }

    public void render(int face, int liquid, double x, double y, double z) {
        side_model.render(4, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture_liquid[liquid]));
        side_model.render(4, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[face]));
        side_model.render(0, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[6]));
        side_model.render(8, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[6]));
        side_model.render(12, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[6]));
        side_model.render(16, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[6]));
        side_model.render(20, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[6]));
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.render(2, metadata % 3, 0.0, 0.0, 0.0);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity aTile = world.func_72796_p(x, y, z);
        if (!(aTile instanceof TilePlateRoot)) {
            return false;
        }
        TilePlateRoot theTile = (TilePlateRoot)aTile;
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        this.render(theTile.getFacing(), theTile.getType(), x, y, z);
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdPlate;
    }

    static {
        TEProps.renderIdPlate = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        RenderPlate.generateModels();
    }
}

