/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.render;

import cofh.codechicken.core.render.CCModel;
import cofh.codechicken.core.render.CCRenderState;
import cofh.codechicken.core.render.IUVTransformation;
import cofh.codechicken.core.render.IconTransformation;
import cofh.codechicken.core.render.LightModel;
import cofh.codechicken.core.vec.ITransformation;
import cofh.codechicken.core.vec.Vector3;
import cofh.render.IconRegistry;
import cofh.render.RenderUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.device.BlockEnergyCell;
import thermalexpansion.block.device.TileEnergyCell;
import thermalexpansion.core.TEProps;
import thermalexpansion.liquid.TELiquids;

@SideOnly(value=Side.CLIENT)
public class RenderEnergyCell
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public static RenderEnergyCell instance = new RenderEnergyCell();
    static Icon[] texture = new Icon[2];
    static Icon texture_liquid;
    static CCModel liquid_model;
    static CCModel frame_model;

    public static void initialize() {
        RenderEnergyCell.texture[0] = IconRegistry.getIcon((String)"EnergyCell");
        RenderEnergyCell.texture[1] = IconRegistry.getIcon((String)"EnergyCellInner");
        texture_liquid = IconRegistry.getIcon((String)"LiquidRedstone");
    }

    public void render(int metadata, double x, double y, double z) {
        int i;
        x += 0.5;
        y += 0.5;
        z += 0.5;
        for (i = 0; i < 48; i += 8) {
            frame_model.render(i, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[0]));
        }
        for (i = 4; i < 48; i += 8) {
            frame_model.render(i, 4, (ITransformation)new Vector3(x, y, z).translation(), (IUVTransformation)new IconTransformation(texture[1]));
        }
    }

    public void renderLiquid(int metadata, double x, double y, double z) {
        liquid_model.render(x, y, z, texture_liquid);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int chargeLevel = 10;
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        this.render(0, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.startDrawing((int)7);
        RenderUtils.setLiquidRenderColor((LiquidStack)TELiquids.liquidRedstone);
        CCRenderState.setBrightness((int)(165 + chargeLevel * 5));
        this.renderLiquid(0, -0.5, -0.5, -0.5);
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        GL11.glDisable((int)3042);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (!(tile instanceof TileEnergyCell)) {
            return false;
        }
        TileEnergyCell theTile = (TileEnergyCell)tile;
        int chargeLevel = MathHelper.minI((int)theTile.getScaledEnergyStored(16), (int)15);
        RenderUtils.beforeWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (BlockEnergyCell.renderPass == 0) {
            this.render(0, x, y, z);
        } else {
            RenderUtils.setLiquidRenderColor((LiquidStack)TELiquids.liquidRedstone);
            CCRenderState.setBrightness((int)(165 + chargeLevel * 5));
            this.renderLiquid(0, x, y, z);
        }
        RenderUtils.afterWorldRender((IBlockAccess)world, (int)x, (int)y, (int)z);
        return true;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return TEProps.renderIdEnergyCell;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                return true;
            }
            case EQUIPPED: {
                return true;
            }
            case INVENTORY: {
                return true;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        double offset = -0.5;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            offset = 0.0;
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderUtils.setBlockTextureSheet();
        RenderUtils.preRender();
        CCRenderState.startDrawing((int)7);
        instance.render(0, offset, offset, offset);
        if (item.func_77960_j() == 65) {
            instance.renderLiquid(0, offset, offset, offset);
        }
        CCRenderState.draw();
        CCRenderState.useNormals((boolean)false);
        RenderUtils.setItemTextureSheet();
        GL11.glDisable((int)3042);
    }

    static {
        liquid_model = CCModel.quadModel((int)24);
        frame_model = CCModel.quadModel((int)48);
        TEProps.renderIdEnergyCell = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)instance);
        liquid_model.generateBlock(0, 0.15, 0.15, 0.15, 0.85, 0.85, 0.85).computeNormals();
        frame_model.generateSlice(8, 0, -8.0, 5.0, -8.0, 16.0, 3.0, 16.0, 0.0, 0.0, 16.0, 16.0, 16.0).generateSidedParts(1, new Vector3()).computeNormals().computeLighting(LightModel.standardLightModel);
    }
}

