/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.core.ReflectionManager;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.src.ModLoader;
import org.lwjgl.opengl.GL11;
import thermalexpansion.api.crafting.IFurnaceRecipe;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.gui.gui.GuiFurnace;
import thermalexpansion.util.crafting.FurnaceManager;

public class PowFurnaceRecipeHandler
extends TemplateRecipeHandler {
    public static PowFurnaceRecipeHandler instance = new PowFurnaceRecipeHandler();
    public static final int MAX_ENERGY = Machines.powerData[Machines.Types.FURNACE.ordinal()].maxEnergy;
    public int[] energyAmount = new int[2];
    public int[] lastCycle = new int[2];
    public int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "thermalexpansion.furnace", new Object[0]));
    }

    public Class getGuiClass() {
        return GuiFurnace.class;
    }

    public String getRecipeName() {
        return CoreUtils.localize((String)"machine.furnace");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") || outputId.equals("thermalexpansion.furnace")) {
            IFurnaceRecipe[] recipes;
            for (IFurnaceRecipe recipe : recipes = FurnaceManager.getInstance().getRecipeList()) {
                this.arecipes.add(new PowFurnaceRecipe(recipe));
            }
            this.checkFurnaceRecipes(null);
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        IFurnaceRecipe[] recipes;
        for (IFurnaceRecipe recipe : recipes = FurnaceManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new PowFurnaceRecipe(recipe));
        }
        this.checkFurnaceRecipes(result);
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == PowFurnaceRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        IFurnaceRecipe[] recipes;
        for (IFurnaceRecipe recipe : recipes = FurnaceManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new PowFurnaceRecipe(recipe));
        }
        this.checkFurnaceIngred(ingredient);
    }

    public String getGuiTexture() {
        return "/mods/thermalexpansion/textures/gui/Furnace.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTexturedModalRect(51, 36, 176, 0, 16, 16);
        this.drawProgressBar(gui, 74, 26, 176, 16, 24, 16, 20, 0);
        this.drawEnergyBar(gui, recipe);
        gui.drawText(74, 17, ((PowFurnaceRecipe)((Object)this.arecipes.get((int)recipe))).energy + "MJ", 0x939393, false);
    }

    public void drawEnergyBar(GuiContainerManager gui, int recipe) {
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.arecipe[0] = -1;
            this.arecipe[1] = -1;
            this.energyAmount[0] = 0;
            this.energyAmount[1] = 0;
            this.lastCycle[0] = 0;
            this.lastCycle[1] = 0;
            this.drawEnergyBar(gui, recipe);
            return;
        }
        if (this.arecipe[0] == recipe) {
            int energy = this.getScaledEnergy(this.energyAmount[0]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[0]) {
                if (this.energyAmount[0] == MAX_ENERGY) {
                    this.energyAmount[0] = 0;
                }
                this.energyAmount[0] = this.energyAmount[0] + ((PowFurnaceRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[0] > MAX_ENERGY) {
                    this.energyAmount[0] = MAX_ENERGY;
                }
                this.lastCycle[0] = this.cycleticks;
            }
        } else {
            int energy = this.getScaledEnergy(this.energyAmount[1]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[1]) {
                if (this.energyAmount[1] == MAX_ENERGY) {
                    this.energyAmount[1] = 0;
                }
                this.energyAmount[1] = this.energyAmount[1] + ((PowFurnaceRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[1] > MAX_ENERGY) {
                    this.energyAmount[1] = MAX_ENERGY;
                }
                this.lastCycle[1] = this.cycleticks;
            }
        }
    }

    public int getScaledEnergy(int amount) {
        int scale = 40;
        int theResult = amount * scale / MAX_ENERGY;
        return theResult;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion.furnace";
    }

    public void checkFurnaceRecipes(ItemStack result) {
        ItemStack item;
        HashMap recipes;
        Map TErecipes = FurnaceManager.getRecipeMap();
        HashMap metarecipes = null;
        try {
            recipes = (HashMap)ModLoader.getPrivateValue(FurnaceRecipes.class, (Object)FurnaceRecipes.func_77602_a(), (int)1);
            try {
                metarecipes = (HashMap)ReflectionManager.getField(FurnaceRecipes.class, HashMap.class, (Object)FurnaceRecipes.func_77602_a(), (int)3);
            }
            catch (ArrayIndexOutOfBoundsException e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (TErecipes.containsKey(Arrays.asList((Integer)recipe.getKey(), 0)) || result != null && !NEIServerUtils.areStacksSameType((ItemStack)item, (ItemStack)result)) continue;
            this.arecipes.add(new PowFurnaceRecipe(new ItemStack(((Integer)recipe.getKey()).intValue(), 1, -1), item, 160));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (TErecipes.containsKey(Arrays.asList((Integer)((List)recipe.getKey()).get(0), (Integer)((List)recipe.getKey()).get(1))) || result != null && !NEIServerUtils.areStacksSameType((ItemStack)item, (ItemStack)result)) continue;
            this.arecipes.add(new PowFurnaceRecipe(new ItemStack(((Integer)((List)recipe.getKey()).get(0)).intValue(), 1, ((Integer)((List)recipe.getKey()).get(1)).intValue()), item, 160));
        }
    }

    public void checkFurnaceIngred(ItemStack ingredient) {
        ItemStack item;
        HashMap recipes;
        HashMap metarecipes = null;
        try {
            recipes = (HashMap)ModLoader.getPrivateValue(FurnaceRecipes.class, (Object)FurnaceRecipes.func_77602_a(), (int)1);
            try {
                metarecipes = (HashMap)ModLoader.getPrivateValue(FurnaceRecipes.class, (Object)FurnaceRecipes.func_77602_a(), (int)3);
            }
            catch (ArrayIndexOutOfBoundsException e) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (Map.Entry recipe : recipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)recipe.getKey()) continue;
            this.arecipes.add(new PowFurnaceRecipe(ingredient, item, 160));
        }
        if (metarecipes == null) {
            return;
        }
        for (Map.Entry recipe : metarecipes.entrySet()) {
            item = (ItemStack)recipe.getValue();
            if (ingredient.field_77993_c != (Integer)((List)recipe.getKey()).get(0) || ingredient.func_77960_j() != ((Integer)((List)recipe.getKey()).get(1)).intValue()) continue;
            this.arecipes.add(new PowFurnaceRecipe(ingredient, item, 160));
        }
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 8, 166, 65);
    }

    class PowFurnaceRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;
        int energy;

        public PowFurnaceRecipe(ItemStack input, ItemStack output, int energy) {
            super((TemplateRecipeHandler)PowFurnaceRecipeHandler.this);
            this.input = new PositionedStack((Object)input, 51, 18);
            this.output = new PositionedStack((Object)output, 111, 27);
            this.energy = energy;
        }

        public PowFurnaceRecipe(IFurnaceRecipe recipe) {
            super((TemplateRecipeHandler)PowFurnaceRecipeHandler.this);
            this.input = new PositionedStack((Object)recipe.getInput(), 51, 18);
            this.output = new PositionedStack((Object)recipe.getOutput(), 111, 27);
            this.energy = recipe.getEnergy();
        }

        public PositionedStack getIngredient() {
            int cycle = PowFurnaceRecipeHandler.this.cycleticks / 48;
            if (this.input.item.func_77960_j() == -1) {
                PositionedStack stack = this.input.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

