/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.nei.handlers;

import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import thermalexpansion.api.crafting.ICrucibleRecipe;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.gui.gui.GuiCrucible;
import thermalexpansion.plugins.nei.NEIGuiHandler;
import thermalexpansion.util.crafting.CrucibleManager;

public class CrucibleRecipeHandler
extends TemplateRecipeHandler {
    public static CrucibleRecipeHandler instance = new CrucibleRecipeHandler();
    public static final int MAX_ENERGY = Machines.powerData[Machines.Types.CRUCIBLE.ordinal()].maxEnergy;
    public static final int MAX_LIQUID = 10000;
    public int[] energyAmount = new int[2];
    public int[] liquidAmount = new int[2];
    public int[] lastCycle = new int[2];
    public int[] arecipe = new int[]{-1, -1};

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(98, 23, 24, 18), "thermalexpansion.crucible", new Object[0]));
    }

    public List handleTooltip(GuiRecipe gui, List currenttip, int recipe) {
        int minX1 = 151;
        int maxX1 = 167;
        int minY1 = 17;
        int maxY1 = 77;
        int yOffset = 66;
        Point mousepos = gui.manager.getMousePosition();
        int leftSide = (gui.field_73880_f - gui.field_74194_b) / 2;
        int topSide = (gui.field_73881_g - gui.field_74195_c) / 2;
        if (mousepos.x >= minX1 + leftSide && mousepos.x < maxX1 + leftSide && mousepos.y >= minY1 + topSide && mousepos.y < maxY1 + topSide && this.arecipe[0] == recipe) {
            currenttip.add(((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output.asItemStack().func_77973_b().func_77628_j(((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output.asItemStack()));
        } else if (mousepos.x >= minX1 + leftSide && mousepos.x < maxX1 + leftSide && mousepos.y >= minY1 + topSide + yOffset && mousepos.y < maxY1 + topSide + yOffset && this.arecipe[1] == recipe) {
            currenttip.add(((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output.asItemStack().func_77973_b().func_77628_j(((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output.asItemStack()));
        }
        return currenttip;
    }

    public Class getGuiClass() {
        return GuiCrucible.class;
    }

    public String getRecipeName() {
        return CoreUtils.localize((String)"machine.crucible");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("thermalexpansion.crucible")) {
            ICrucibleRecipe[] recipes;
            for (ICrucibleRecipe recipe : recipes = CrucibleManager.getInstance().getRecipeList()) {
                this.arecipes.add(new CrucibleRecipe(recipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ICrucibleRecipe[] recipes;
        for (ICrucibleRecipe recipe : recipes = CrucibleManager.getInstance().getRecipeList()) {
            if (!recipe.getOutput().isLiquidEqual(result)) continue;
            this.arecipes.add(new CrucibleRecipe(recipe));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == CrucibleRecipeHandler.class) {
            this.loadCraftingRecipes("thermalexpansion.crucible", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        ICrucibleRecipe[] recipes;
        for (ICrucibleRecipe recipe : recipes = CrucibleManager.getInstance().getRecipeList()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            this.arecipes.add(new CrucibleRecipe(recipe));
        }
    }

    public String getGuiTexture() {
        return "/mods/thermalexpansion/textures/gui/Crucible.png";
    }

    public void drawExtras(GuiContainerManager gui, int recipe) {
        gui.drawTexturedModalRect(51, 36, 176, 0, 16, 16);
        this.drawEnergyBar(gui, recipe);
        this.drawLiquid(98, 26, ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output, (int)((float)(this.cycleticks % 20) / 20.0f * 24.0f), 16, gui);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(98, 26, 192, 96, 24, 16);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(147, 7, 176, 104, 16, 49);
        gui.drawText(95, 17, ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).energy + "MJ", 0x939393, false);
        gui.drawText(95, 44, ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output.amount + "mB", 0x939393, false);
    }

    public void drawLiquidBar(GuiContainerManager gui, int recipe, int recipe2) {
        int n = recipe;
        this.liquidAmount[n] = this.liquidAmount[n] + ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe2))).output.amount;
        if (this.liquidAmount[recipe] >= 10000) {
            this.liquidAmount[recipe] = 0;
        }
    }

    public void drawEnergyBar(GuiContainerManager gui, int recipe) {
        if (this.arecipe[0] == -1) {
            this.arecipe[0] = recipe;
        } else if (this.arecipe[1] == -1 && this.arecipe[0] != recipe) {
            this.arecipe[1] = recipe;
        }
        if (this.arecipe[0] != recipe && this.arecipe[1] != recipe) {
            this.arecipe[0] = -1;
            this.arecipe[1] = -1;
            this.energyAmount[0] = 0;
            this.energyAmount[1] = 0;
            this.lastCycle[0] = 0;
            this.lastCycle[1] = 0;
            this.liquidAmount[0] = 0;
            this.liquidAmount[1] = 0;
            this.drawEnergyBar(gui, recipe);
            return;
        }
        if (this.arecipe[0] == recipe) {
            int energy = this.getScaledEnergy(this.energyAmount[0]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            this.drawLiquid(147, 61 - this.getScaledLiquid(this.liquidAmount[0]), ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output, 16, this.getScaledLiquid(this.liquidAmount[0]), gui);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[0]) {
                if (this.energyAmount[0] == MAX_ENERGY) {
                    this.energyAmount[0] = 0;
                }
                this.energyAmount[0] = this.energyAmount[0] + ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[0] >= MAX_ENERGY) {
                    this.energyAmount[0] = 0;
                }
                this.drawLiquidBar(gui, 0, recipe);
                this.lastCycle[0] = this.cycleticks;
            }
        } else {
            int energy = this.getScaledEnergy(this.energyAmount[1]);
            gui.drawTexturedModalRect(3, 1 + energy, 176, 33 + energy, 16, 40 - energy);
            this.drawLiquid(147, 61 - this.getScaledLiquid(this.liquidAmount[1]), ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).output, 16, this.getScaledLiquid(this.liquidAmount[1]), gui);
            if (this.cycleticks % 20 == 0 && this.cycleticks != this.lastCycle[1]) {
                if (this.energyAmount[1] == MAX_ENERGY) {
                    this.energyAmount[1] = 0;
                }
                this.energyAmount[1] = this.energyAmount[1] + ((CrucibleRecipe)((Object)this.arecipes.get((int)recipe))).energy;
                if (this.energyAmount[1] >= MAX_ENERGY) {
                    this.energyAmount[1] = 0;
                }
                this.drawLiquidBar(gui, 1, recipe);
                this.lastCycle[1] = this.cycleticks;
            }
        }
    }

    public int getScaledLiquid(int amount) {
        int scale = 60;
        int theResult = amount * scale / 10000;
        return theResult;
    }

    public int getScaledEnergy(int amount) {
        int scale = 40;
        int theResult = amount * scale / MAX_ENERGY;
        return theResult;
    }

    public String getOverlayIdentifier() {
        return "thermalexpansion.crucible";
    }

    protected void drawLiquid(int j, int k, LiquidStack theLiquid, int width, int height, GuiContainerManager gui) {
        if (height > 60) {
            height = 60;
        }
        RenderUtils.setLiquidTextureSheet((LiquidStack)theLiquid);
        int x = 0;
        int y = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (x = 0; x < width; x += 16) {
            for (y = 0; y < height; y += 16) {
                drawWidth = MathHelper.minI((int)(width - x), (int)16);
                drawHeight = MathHelper.minI((int)(height - y), (int)16);
                NEIGuiHandler.drawScaledTexturedModelRectFromIcon(gui, j + x, k + y, RenderUtils.getLiquidTexture((LiquidStack)theLiquid), drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawBackground(GuiContainerManager gui, int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.bindTexture((String)this.getGuiTexture());
        gui.drawTexturedModalRect(0, 0, 5, 8, 166, 65);
    }

    class CrucibleRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        LiquidStack output;
        int energy;

        public CrucibleRecipe(ICrucibleRecipe recipe) {
            super((TemplateRecipeHandler)CrucibleRecipeHandler.this);
            this.input = new PositionedStack((Object)recipe.getInput(), 51, 18);
            this.output = recipe.getOutput();
            this.energy = recipe.getEnergy();
        }

        public PositionedStack getIngredient() {
            int cycle = CrucibleRecipeHandler.this.cycleticks / 48;
            if (this.input.item.func_77960_j() == -1) {
                PositionedStack stack = this.input.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public ArrayList getOtherStacks() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            PositionedStack stack = this.getOtherStack();
            if (stack != null) {
                stacks.add(stack);
            }
            return stacks;
        }
    }
}

