/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.cc;

import cofh.api.block.IDismantleable;
import cofh.entity.PlayerFalse;
import cofh.util.BlockUtils;
import dan200.computer.api.IHostedPeripheral;
import dan200.turtle.api.ITurtleAccess;
import dan200.turtle.api.ITurtleUpgrade;
import dan200.turtle.api.TurtleSide;
import dan200.turtle.api.TurtleUpgradeType;
import dan200.turtle.api.TurtleVerb;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.Icon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.device.BlockTank;
import thermalexpansion.block.device.ItemBlockTank;
import thermalexpansion.plugins.cc.CCPlugin;

public class TurtleBucket
implements ITurtleUpgrade {
    private static final float DAMAGE_MULTIPLIER = 1.0f;
    private int m_id;
    private String m_adjective;
    protected ItemStack m_item;
    protected boolean m_secret;

    public TurtleBucket(int id, String adjective) {
        this.m_id = id;
        this.m_adjective = adjective;
        this.m_item = new ItemStack(Item.field_77788_aw);
        this.m_secret = false;
    }

    private boolean attack(ITurtleAccess turtle, int dir) {
        boolean result = turtle.attackWithItemStack(this.m_item.func_77946_l(), dir, 1.0f);
        if (!result) {
            return this.addLiquid(turtle, dir);
        }
        return result;
    }

    private boolean dig(ITurtleAccess turtle, int dir) {
        World worldObj = turtle.getWorld();
        Vec3 position = turtle.getPosition();
        int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
        int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
        int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
        if (newY < 0 || newY >= worldObj.func_72940_L()) {
            return false;
        }
        int bid = worldObj.func_72798_a(newX, newY, newZ);
        Block theBlock = Block.field_71973_m[bid];
        if (theBlock instanceof BlockTank) {
            PlayerFalse player = new PlayerFalse(worldObj);
            if (((IDismantleable)theBlock).canDismantle((EntityPlayer)player, worldObj, newX, newY, newZ)) {
                this.storeItem(turtle, ((IDismantleable)theBlock).dismantleBlock((EntityPlayer)player, worldObj, newX, newY, newZ, true));
            }
        } else if (CCPlugin.turtlesCanBreakBlocks) {
            if (!this.canBreakBlock(worldObj, newX, newY, newZ)) {
                return false;
            }
            if (this.canHarvestBlock(worldObj, newX, newY, newZ)) {
                ArrayList items = this.getBlockDropped(worldObj, newX, newY, newZ);
                for (ItemStack item : items) {
                    this.storeItem(turtle, item);
                }
            }
            int blockID = worldObj.func_72798_a(newX, newY, newZ);
            worldObj.func_72926_e(2001, newX, newY, newZ, blockID + worldObj.func_72798_a(newX, newY, newZ) * 4096);
            worldObj.func_94571_i(newX, newY, newZ);
        }
        return true;
    }

    public boolean addLiquid(ITurtleAccess theTurtle, int dir) {
        ItemStack bucket = LiquidContainerRegistry.EMPTY_BUCKET.func_77946_l();
        theTurtle.deployWithItemStack(bucket, dir);
        World worldObj = theTurtle.getWorld();
        Vec3 position = theTurtle.getPosition();
        int newX = (int)position.field_72450_a + Facing.field_71586_b[dir];
        int newY = (int)position.field_72448_b + Facing.field_71587_c[dir];
        int newZ = (int)position.field_72449_c + Facing.field_71585_d[dir];
        if (newY < 0 || newY >= worldObj.func_72940_L()) {
            return false;
        }
        if (!LiquidContainerRegistry.EMPTY_BUCKET.func_77969_a(bucket)) {
            if (!this.addLiquid(theTurtle, bucket, null)) {
                theTurtle.deployWithItemStack(bucket, dir);
                return false;
            }
            return true;
        }
        if (theTurtle.getSlotContents(theTurtle.getSelectedSlot()) == null && this.removeFromTanks(theTurtle, worldObj, newX, newY, newZ, dir)) {
            return true;
        }
        if (theTurtle.getSlotContents(theTurtle.getSelectedSlot()) != null && this.addToTanks(theTurtle, worldObj, newX, newY, newZ, dir)) {
            return true;
        }
        return this.placeLiquid(theTurtle, dir);
    }

    public boolean addLiquid(ITurtleAccess theTurtle, ItemStack bucket, LiquidStack myData) {
        if (bucket != null) {
            myData = LiquidContainerRegistry.getLiquidForFilledItem((ItemStack)bucket);
        }
        int emptyTankID = -1;
        if (myData == null) {
            return false;
        }
        for (int i = 0; i < theTurtle.getInventorySize(); ++i) {
            if (theTurtle.getSlotContents(i) == null || !(theTurtle.getSlotContents(i).func_77973_b() instanceof ItemBlockTank)) continue;
            if (theTurtle.getSlotContents((int)i).field_77990_d != null && theTurtle.getSlotContents((int)i).field_77990_d.func_74762_e("liquid.itemID") == myData.itemID && theTurtle.getSlotContents((int)i).field_77990_d.func_74762_e("liquid.itemMeta") == myData.itemMeta) {
                int amount = theTurtle.getSlotContents((int)i).field_77990_d.func_74762_e("liquid.amount");
                if (amount + myData.amount > 8000) continue;
                theTurtle.getSlotContents((int)i).field_77990_d.func_74768_a("liquid.amount", amount + myData.amount);
                return true;
            }
            if (emptyTankID == -1 && theTurtle.getSlotContents((int)i).field_77990_d != null && theTurtle.getSlotContents((int)i).field_77990_d.func_74762_e("liquid.itemID") <= 0) {
                emptyTankID = i;
                continue;
            }
            if (emptyTankID != -1 || theTurtle.getSlotContents((int)i).field_77990_d != null) continue;
            emptyTankID = i;
        }
        if (emptyTankID != -1) {
            if (theTurtle.getSlotContents((int)emptyTankID).field_77990_d == null) {
                theTurtle.getSlotContents(emptyTankID).func_77982_d(new NBTTagCompound());
            }
            theTurtle.getSlotContents((int)emptyTankID).field_77990_d.func_74768_a("liquid.itemID", myData.itemID);
            theTurtle.getSlotContents((int)emptyTankID).field_77990_d.func_74768_a("liquid.amount", myData.amount);
            theTurtle.getSlotContents((int)emptyTankID).field_77990_d.func_74768_a("liquid.itemMeta", myData.itemMeta);
            return true;
        }
        return false;
    }

    public boolean addToTanks(ITurtleAccess theTurtle, World worldObj, int x, int y, int z, int side) {
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (tile instanceof ITankContainer) {
            ITankContainer theTank = (ITankContainer)tile;
            ItemStack curItem = theTurtle.getSlotContents(theTurtle.getSelectedSlot());
            if (curItem != null && curItem.func_77973_b() instanceof ItemBlockTank && curItem.field_77990_d != null) {
                LiquidStack theLiquid = new LiquidStack(curItem.field_77990_d.func_74762_e("liquid.itemID"), curItem.field_77990_d.func_74762_e("liquid.amount"), curItem.field_77990_d.func_74762_e("liquid.itemMeta"));
                int filledAmount = theTank.fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), theLiquid.copy(), false);
                if (filledAmount > 0) {
                    filledAmount = curItem.field_77990_d.func_74762_e("liquid.amount") - theTank.fill(0, theLiquid.copy(), true);
                    curItem.field_77990_d.func_74768_a("liquid.amount", filledAmount);
                    if (curItem.field_77990_d.func_74762_e("liquid.amount") <= 0) {
                        curItem.field_77990_d = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public boolean removeFromTanks(ITurtleAccess theTurtle, World worldObj, int x, int y, int z, int side) {
        ITankContainer theTank;
        LiquidStack theLiquid;
        TileEntity tile = worldObj.func_72796_p(x, y, z);
        if (tile instanceof ITankContainer && (theLiquid = (theTank = (ITankContainer)tile).drain(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), 1000, false)) != null && theLiquid.amount == 1000 && this.addLiquid(theTurtle, null, theLiquid)) {
            theTank.drain(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), 1000, true);
            return true;
        }
        return false;
    }

    private boolean placeLiquid(ITurtleAccess theTurtle, int dir) {
        ItemStack curItem = theTurtle.getSlotContents(theTurtle.getSelectedSlot());
        if (curItem != null && curItem.field_77990_d != null && curItem.func_77973_b() instanceof ItemBlockTank) {
            LiquidStack theLiquid = new LiquidStack(curItem.field_77990_d.func_74762_e("liquid.itemID"), curItem.field_77990_d.func_74762_e("liquid.amount"), curItem.field_77990_d.func_74762_e("liquid.itemMeta"));
            if (theLiquid.amount >= 1000) {
                ItemStack theBucket = LiquidContainerRegistry.fillLiquidContainer((LiquidStack)theLiquid, (ItemStack)LiquidContainerRegistry.EMPTY_BUCKET);
                theTurtle.deployWithItemStack(theBucket, dir);
                if (LiquidContainerRegistry.EMPTY_BUCKET.func_77969_a(theBucket)) {
                    curItem.field_77990_d.func_74768_a("liquid.amount", curItem.field_77990_d.func_74762_e("liquid.amount") - 1000);
                    if (curItem.field_77990_d.func_74762_e("liquid.amount") <= 0) {
                        curItem.field_77990_d = null;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean canBreakBlock(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        return bid != 0 && bid != Block.field_71986_z.field_71990_ca && !(block.func_71934_m(world, x, y, z) <= -1.0f);
    }

    protected boolean canHarvestBlock(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        return block.field_72018_cp.func_76229_l();
    }

    private ArrayList getBlockDropped(World world, int x, int y, int z) {
        int bid = world.func_72798_a(x, y, z);
        Block block = Block.field_71973_m[bid];
        int metadata = world.func_72805_g(x, y, z);
        return block.getBlockDropped(world, x, y, z, metadata, 0);
    }

    public boolean rotateBlock(World worldObj, int block, int meta, int newX, int newY, int newZ) {
        if (BlockUtils.canRotate((int)block)) {
            worldObj.func_72921_c(newX, newY, newZ, BlockUtils.rotateVanillaBlock((World)worldObj, (int)block, (int)meta, (int)newX, (int)newY, (int)newZ), 1);
            return true;
        }
        return false;
    }

    public void storeItem(ITurtleAccess turtle, ItemStack item) {
        if (item != null && !turtle.storeItemStack(item) && !turtle.dropItemStack(item, turtle.getFacingDir())) {
            turtle.dropItemStack(item, turtle.getFacingDir());
        }
    }

    public int getUpgradeID() {
        return this.m_id;
    }

    public String getAdjective() {
        return this.m_adjective;
    }

    public TurtleUpgradeType getType() {
        return TurtleUpgradeType.Tool;
    }

    public ItemStack getCraftingItem() {
        return this.m_item;
    }

    public boolean isSecret() {
        return this.m_secret;
    }

    public IHostedPeripheral createPeripheral(ITurtleAccess turtle, TurtleSide side) {
        return null;
    }

    public boolean useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, int dir) {
        switch (verb.ordinal()) {
            case 1: {
                return this.attack(turtle, dir);
            }
            case 2: {
                return this.dig(turtle, dir);
            }
        }
        return this.dig(turtle, dir);
    }

    public Icon getIcon(ITurtleAccess turtle, TurtleSide side) {
        return this.m_item.func_77954_c();
    }
}

