/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.buildcraft.triggers;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ITriggerParameter;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.tesseract.TileTesseractRoot;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderTesseract;
import thermalexpansion.plugins.buildcraft.triggers.TriggerTE;

public class TriggerTesseract
extends TriggerTE {
    public State state;

    public TriggerTesseract(State state) {
        this.state = state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconIndex() {
        return this.state.ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return TriggerProviderTesseract.instance;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case HasValidOutputs: {
                return "Active Output Links";
            }
            case NoValidOutputs: {
                return "No Output Links";
            }
            case HasValidInputs: {
                return "Active Input Links";
            }
            case NoValidInputs: {
                return "No Input Links";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileTesseractRoot) {
            TileTesseractRoot theTile = (TileTesseractRoot)tile;
            switch (this.state) {
                case HasValidOutputs: {
                    return theTile.getValidOutputs().size() > 0;
                }
                case NoValidOutputs: {
                    return theTile.getValidOutputs().size() == 0;
                }
                case HasValidInputs: {
                    return theTile.getValidInputs().size() > 0;
                }
                case NoValidInputs: {
                    return theTile.getValidInputs().size() == 0;
                }
            }
        }
        return false;
    }

    public static enum State {
        HasValidOutputs,
        NoValidOutputs,
        HasValidInputs,
        NoValidInputs;

    }
}

