/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.buildcraft.triggers;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.block.device.TileEnergyCell;
import thermalexpansion.plugins.buildcraft.triggers.TriggerProviderEnergy;
import thermalexpansion.plugins.buildcraft.triggers.TriggerTE;

public class TriggerEnergy
extends TriggerTE {
    public State state;

    public TriggerEnergy(State state) {
        this.state = state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getIconIndex() {
        return this.state.ordinal();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return TriggerProviderEnergy.instance;
    }

    @Override
    public String getDescription() {
        switch (this.state) {
            case Empty: {
                return "No Energy";
            }
            case Contains: {
                return "Energy Stored";
            }
            case Space: {
                return "Can Store Energy";
            }
            case Full: {
                return "Full Energy";
            }
        }
        return "";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof IPowerReceptor) {
            IPowerProvider powerProvider = ((IPowerReceptor)tile).getPowerProvider();
            if (powerProvider == null) {
                return false;
            }
            if (tile instanceof TileEnergyCell) {
                TileEnergyCell theTile = (TileEnergyCell)tile;
                switch (this.state) {
                    case Empty: {
                        return powerProvider.getEnergyStored() <= (float)theTile.energyReceive;
                    }
                    case Contains: {
                        return powerProvider.getEnergyStored() > (float)theTile.energyReceive;
                    }
                    case Space: {
                        return powerProvider.getEnergyStored() < (float)(powerProvider.getMaxEnergyStored() - 5 * theTile.energySend);
                    }
                    case Full: {
                        return powerProvider.getEnergyStored() >= (float)(powerProvider.getMaxEnergyStored() - 5 * theTile.energySend);
                    }
                }
            }
            switch (this.state) {
                case Empty: {
                    return powerProvider.getEnergyStored() == 0.0f;
                }
                case Contains: {
                    return powerProvider.getEnergyStored() != 0.0f;
                }
                case Space: {
                    return powerProvider.getEnergyStored() < (float)powerProvider.getMaxEnergyStored();
                }
                case Full: {
                    return powerProvider.getEnergyStored() == (float)powerProvider.getMaxEnergyStored();
                }
            }
        }
        return false;
    }

    public static enum State {
        Empty,
        Contains,
        Space,
        Full;

    }
}

