/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.plugins.buildcraft.pipes;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.IPipeTransportItemsHook;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.pipes.PipeLogic;
import buildcraft.transport.pipes.PipeLogicStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.plugins.buildcraft.BCPlugin;

public class PipeItemsRedstone
extends Pipe
implements IPipeTransportItemsHook {
    boolean isPowering = false;

    public PipeItemsRedstone(int itemID) {
        super((PipeTransport)new PipeTransportItems(), (PipeLogic)new PipeLogicStone(), itemID);
    }

    public void updateEntity() {
        super.updateEntity();
        if (((PipeTransportItems)this.transport).travelingEntities.size() == 0 && this.isPowering) {
            this.isPowering = false;
            this.updateNeighbors(true);
        } else if (((PipeTransportItems)this.transport).travelingEntities.size() > 0 && !this.isPowering) {
            this.isPowering = true;
            this.updateNeighbors(true);
        }
    }

    public boolean canConnectRedstone() {
        if (this.isPowering) {
            return true;
        }
        return super.canConnectRedstone();
    }

    public int isPoweringTo(int side) {
        if (this.isPowering) {
            return 15;
        }
        return super.isPoweringTo(side);
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return BCPlugin.pipeIconProvider;
    }

    public int getIconIndex(ForgeDirection direction) {
        return this.isPowering ? 1 : 2;
    }

    public LinkedList filterPossibleMovements(LinkedList possibleOrientations, Position pos, IPipedItem item) {
        return possibleOrientations;
    }

    public void entityEntered(IPipedItem item, ForgeDirection orientation) {
    }

    public void readjustSpeed(IPipedItem item) {
        if (item.getSpeed() > Utils.pipeNormalSpeed) {
            item.setSpeed(item.getSpeed() - Utils.pipeNormalSpeed / 2.0f);
        }
        if (item.getSpeed() < Utils.pipeNormalSpeed) {
            item.setSpeed(Utils.pipeNormalSpeed);
        }
    }
}

