/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.liquid;

import cofh.util.CoreUtils;
import cofh.util.liquid.BucketHandler;
import cofh.util.liquid.DispenserEmptyBucketHandler;
import cofh.util.liquid.DispenserFilledBucketHandler;
import cofh.util.liquid.LiquidRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Property;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.tool.ItemBucket;
import thermalexpansion.liquid.BlockLiquidEnder;
import thermalexpansion.liquid.BlockLiquidGlowstone;
import thermalexpansion.liquid.BlockLiquidRedstone;

public class TELiquids {
    public static final int REDSTONE_LEVELS = 8;
    public static final int GLOWSTONE_LEVELS = 6;
    public static final int ENDER_LEVELS = 4;
    public static ItemBucket itemBucket;
    public static ItemStack bucketRedstone;
    public static ItemStack bucketGlowstone;
    public static ItemStack bucketEnder;
    public static Block blockRedstone;
    public static Block blockGlowstone;
    public static Block blockEnder;
    public static LiquidStack liquidRedstone;
    public static LiquidStack liquidGlowstone;
    public static LiquidStack liquidEnder;
    public static boolean effectRedstone;
    public static boolean effectGlowstone;
    public static boolean effectEnder;

    public static void configure() {
        ThermalExpansion.config.addBlockEntry("LiquidRedstone", 2);
        ThermalExpansion.config.addBlockEntry("LiquidGlowstone", 2);
        ThermalExpansion.config.addBlockEntry("LiquidEnder", 2);
        ThermalExpansion.config.addItemEntry("Tool.Bucket");
        String category = "tweak";
        Property curProp = ThermalExpansion.config.getProperty(category, "Liquid.Redstone.Effect", true);
        curProp.comment = "Enable this for Liquid Redstone to emit a signal proportional to its fluid level.";
        effectRedstone = curProp.getBoolean(true);
        curProp = ThermalExpansion.config.getProperty(category, "Liquid.Glowstone.Effect", true);
        curProp.comment = "Enable this for Liquid Glowstone to do...something.";
        effectGlowstone = curProp.getBoolean(true);
        curProp = ThermalExpansion.config.getProperty(category, "Liquid.Ender.Effect", true);
        curProp.comment = "Enable this for Liquid Ender to randomly teleport entities on contact.";
        effectEnder = curProp.getBoolean(true);
    }

    public static void initialize() {
        blockRedstone = new BlockLiquidRedstone(ThermalExpansion.config.getBlockId("LiquidRedstone"));
        blockGlowstone = new BlockLiquidGlowstone(ThermalExpansion.config.getBlockId("LiquidGlowstone"));
        blockEnder = new BlockLiquidEnder(ThermalExpansion.config.getBlockId("LiquidEnder"));
        GameRegistry.registerBlock((Block)blockRedstone, (String)"LiquidRedstone");
        GameRegistry.registerBlock((Block)blockGlowstone, (String)"LiquidGlowstone");
        GameRegistry.registerBlock((Block)blockEnder, (String)"LiquidEnder");
        CoreUtils.addName((Object)blockRedstone, (String)"liquid.redstone");
        CoreUtils.addName((Object)blockGlowstone, (String)"liquid.glowstone");
        CoreUtils.addName((Object)blockEnder, (String)"liquid.ender");
        liquidRedstone = new LiquidStack(TELiquids.blockRedstone.field_71990_ca, 1000);
        liquidGlowstone = new LiquidStack(TELiquids.blockGlowstone.field_71990_ca, 1000);
        liquidEnder = new LiquidStack(TELiquids.blockEnder.field_71990_ca, 1000);
        LiquidDictionary.getOrCreateLiquid((String)"redstone", (LiquidStack)liquidRedstone);
        LiquidDictionary.getOrCreateLiquid((String)"glowstone", (LiquidStack)liquidGlowstone);
        LiquidDictionary.getOrCreateLiquid((String)"ender", (LiquidStack)liquidEnder);
        itemBucket = (ItemBucket)new ItemBucket(ThermalExpansion.config.getItemId("Tool.Bucket")).func_77655_b("tool");
        TELiquids.loadItems();
    }

    private static void loadItems() {
        bucketRedstone = itemBucket.addItem(0, "bucketRedstone");
        bucketGlowstone = itemBucket.addItem(1, "bucketGlowstone");
        bucketEnder = itemBucket.addItem(2, "bucketEnder");
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(liquidRedstone, bucketRedstone, new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(liquidGlowstone, bucketGlowstone, new ItemStack(Item.field_77788_aw)));
        LiquidContainerRegistry.registerLiquid((LiquidContainerData)new LiquidContainerData(liquidEnder, bucketEnder, new ItemStack(Item.field_77788_aw)));
    }

    public static void loadRecipes() {
        TELiquids.registerLiquid("redstone", 7, 100, false);
        TELiquids.registerLiquid("glowstone", 15, 80, true);
        TELiquids.registerLiquid("ender", 0, 60, false);
        TELiquids.registerLiquid("Oil", 0, 60, false);
        TELiquids.registerLiquid("Fuel", 0, 80, false);
        TELiquids.registerLiquid("oil", 0, 60, false);
        TELiquids.registerLiquid("fuel", 0, 80, false);
        TELiquids.registerLiquid("steam", 0, 160, true);
        TELiquids.registerLiquid("biomass", 0, 40, false);
        TELiquids.registerLiquid("biofuel", 0, 80, false);
        TELiquids.registerLiquid("seedoil", 0, 60, false);
        TELiquids.registerLiquid("honey", 0, 40, false);
        TELiquids.registerLiquid("milk", 0, 80, false);
        TELiquids.registerLiquid("sludge", 0, 40, false);
        TELiquids.registerLiquid("sewage", 0, 40, false);
        TELiquids.registerLiquid("mobEssence", 7, 60, false);
        TELiquids.registerLiquid("biofuel", 0, 80, false);
        TELiquids.registerLiquid("pinkslime", 5, 40, false);
        BucketHandler.registerBucket((int)TELiquids.blockRedstone.field_71990_ca, (int)7, (ItemStack)bucketRedstone);
        BucketHandler.registerBucket((int)TELiquids.blockGlowstone.field_71990_ca, (int)5, (ItemStack)bucketGlowstone);
        BucketHandler.registerBucket((int)TELiquids.blockEnder.field_71990_ca, (int)3, (ItemStack)bucketEnder);
    }

    public static boolean registerLiquid(String name, int light, int viscosity, boolean isCompressible) {
        if (LiquidDictionary.getCanonicalLiquid((String)name) != null) {
            return LiquidRegistry.registerLiquid((LiquidStack)LiquidDictionary.getCanonicalLiquid((String)name), (int)light, (int)viscosity, (boolean)isCompressible);
        }
        return false;
    }

    public static void registerDispenserHandlers() {
        BlockDispenser.field_82527_a.func_82595_a((Object)itemBucket, (Object)new DispenserFilledBucketHandler());
        BlockDispenser.field_82527_a.func_82595_a((Object)Item.field_77788_aw, (Object)new DispenserEmptyBucketHandler());
    }

    static {
        effectRedstone = true;
        effectGlowstone = true;
        effectEnder = true;
    }
}

