/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiRoot;
import cofh.gui.element.TabRoot;
import cofh.render.RenderUtils;
import cofh.util.CoreUtils;
import cpw.mods.fml.common.network.PacketDispatcher;
import net.minecraft.network.packet.Packet;
import org.lwjgl.opengl.GL11;
import thermalexpansion.core.ISetSchematic;
import thermalexpansion.network.PacketSpecial;
import thermalexpansion.network.SpecialTinyPacketHandler;

public class TabSchematic
extends TabRoot {
    ISetSchematic myTile;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;

    public TabSchematic(GuiRoot gui, ISetSchematic theTile) {
        super(gui);
        this.myTile = theTile;
        this.maxHeight = 92;
        this.maxWidth = 112;
        this.backgroundColor = 0x2020B0;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("schematic");
        if (!this.isFullyOpened()) {
            return;
        }
        GuiRoot.guiFontRenderer.func_78261_a(CoreUtils.localize((String)"gui.schematic"), this.posX + 20, this.posY + 6, this.headerColor);
        GuiRoot.guiFontRenderer.func_78276_b("", this.posX, this.posY, 0xFFFFFF);
        if (this.myTile.canWriteSchematic()) {
            this.gui.drawButton("IconAccept", this.posX + 77, this.posY + 60, 1, 0);
        } else {
            this.gui.drawButton("IconAcceptInactive", this.posX + 77, this.posY + 60, 1, 2);
        }
    }

    public String getTooltip() {
        if (!this.isFullyOpened()) {
            return CoreUtils.localize((String)"gui.schematic");
        }
        return null;
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 8 || x >= 102 || (y -= this.currentShiftY) < 20 || y >= 84) {
            return false;
        }
        if (77 < x && x < 93 && 60 < y && y < 76) {
            if (this.myTile.canWriteSchematic()) {
                this.writeSchematic();
            }
        } else {
            this.gui.mouseClicked(1);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (this.isFullyOpened()) {
            float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
            float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
            float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            this.gui.func_73729_b(this.posX + 8, this.posY + 20, 16, 20, 94, 64);
            colorR = 255.0f;
            colorG = 255.0f;
            colorB = 255.0f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            RenderUtils.bindTexture((String)"/mods/thermalexpansion/textures/gui/elements/Slot_Grid_Schematic.png");
            this.gui.drawSizedTexturedModalRect(this.posX + 8, this.posY + 20, 0, 0, 64, 64, 64.0f, 64.0f);
            RenderUtils.bindTexture((String)"/mods/thermalexpansion/textures/gui/elements/Slot_Output_Schematic.png");
            this.gui.drawSizedTexturedModalRect(this.posX + 72, this.posY + 25, 0, 0, 26, 26, 26.0f, 26.0f);
        }
    }

    public void setFullyOpen() {
        super.setFullyOpen();
        for (int i = 0; i < this.myTile.getCraftingSlots().length; ++i) {
            this.myTile.getCraftingSlots()[i].field_75223_e = this.posX - this.gui.field_74198_m + 14 + 18 * (i % 3);
            this.myTile.getCraftingSlots()[i].field_75221_f = this.posY - this.gui.field_74197_n + 26 + 18 * (i / 3);
        }
        this.myTile.getResultSlot().field_75223_e = this.posX - this.gui.field_74198_m + 77;
        this.myTile.getResultSlot().field_75221_f = this.posY - this.gui.field_74197_n + 30;
    }

    public void toggleOpen() {
        if (this.open) {
            for (int i = 0; i < this.myTile.getCraftingSlots().length; ++i) {
                this.myTile.getCraftingSlots()[i].field_75223_e = -this.gui.field_74198_m - 16;
                this.myTile.getCraftingSlots()[i].field_75221_f = -this.gui.field_74197_n - 16;
            }
            this.myTile.getResultSlot().field_75223_e = -this.gui.field_74198_m - 16;
            this.myTile.getResultSlot().field_75221_f = -this.gui.field_74197_n - 16;
        }
        super.toggleOpen();
    }

    private boolean writeSchematic() {
        if (this.myTile.canWriteSchematic()) {
            PacketDispatcher.sendPacketToServer((Packet)new PacketSpecial((short)SpecialTinyPacketHandler.PACKET_TYPES.WRITE_SCHEM.ordinal()).getTinyPacket());
            return true;
        }
        return false;
    }
}

