/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.gui.element;

import cofh.gui.GuiRoot;
import cofh.gui.element.TabRoot;
import cofh.render.RenderUtils;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.opengl.GL11;
import thermalexpansion.block.machine.TileMachineRoot;

public class TabMachineConfig
extends TabRoot {
    public static String TUTORIAL_CONFIG = "The Configuration tab determines how items enter and leave this device.";
    public static String TUTORIAL_POWERED = "Requires Minecraft Joules to operate.";
    TileMachineRoot myTile;
    int headerColor = 14797103;
    int subheaderColor = 11186104;
    int textColor = 0;

    public TabMachineConfig(GuiRoot gui, TileMachineRoot theTile) {
        super(gui);
        this.myTile = theTile;
        this.maxHeight = 92;
        this.maxWidth = 100;
        this.backgroundColor = 564812;
    }

    public void draw() {
        this.drawBackground();
        this.drawTabIcon("IconConfigMachine");
        if (!this.isFullyOpened()) {
            return;
        }
        GuiRoot.guiFontRenderer.func_78261_a(CoreUtils.localize((String)"gui.configuration"), this.posX + 20, this.posY + 6, this.headerColor);
        GuiRoot.guiFontRenderer.func_78276_b("", this.posX, this.posY, 0xFFFFFF);
        RenderUtils.setBlockTextureSheet();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        for (int i = 0; i < 2; ++i) {
            this.gui.drawIcon(this.myTile.getBlockTexture(1, i), this.posX + 40, this.posY + 24, 0);
            this.gui.drawIcon(this.myTile.getBlockTexture(BlockUtils.SIDE_LEFT[this.myTile.getFacing()], i), this.posX + 20, this.posY + 44, 0);
            this.gui.drawIcon(this.myTile.getBlockTexture(this.myTile.getFacing(), i), this.posX + 40, this.posY + 44, 0);
            this.gui.drawIcon(this.myTile.getBlockTexture(BlockUtils.SIDE_RIGHT[this.myTile.getFacing()], i), this.posX + 60, this.posY + 44, 0);
            this.gui.drawIcon(this.myTile.getBlockTexture(0, i), this.posX + 40, this.posY + 64, 0);
            this.gui.drawIcon(this.myTile.getBlockTexture(BlockUtils.SIDE_OPPOSITE[this.myTile.getFacing()], i), this.posX + 60, this.posY + 64, 0);
        }
        GL11.glDisable((int)3042);
        RenderUtils.setDefaultFontTextureSheet();
    }

    public String getTooltip() {
        if (!this.isFullyOpened()) {
            return CoreUtils.localize((String)"gui.configuration");
        }
        return null;
    }

    public boolean handleMouseClicked(int x, int y, int mouseButton) {
        if (!this.isFullyOpened()) {
            return false;
        }
        if ((x -= this.currentShiftX) < 16 || x >= 80 || (y -= this.currentShiftY) < 20 || y >= 84) {
            return false;
        }
        if (40 <= x && x < 56 && 24 <= y && y < 40) {
            this.handleSideChange(1, mouseButton);
        } else if (20 <= x && x < 36 && 44 <= y && y < 60) {
            this.handleSideChange(BlockUtils.SIDE_LEFT[this.myTile.getFacing()], mouseButton);
        } else if (40 <= x && x < 56 && 44 <= y && y < 60) {
            this.handleSideChange(this.myTile.getFacing(), mouseButton);
        } else if (60 <= x && x < 76 && 44 <= y && y < 60) {
            this.handleSideChange(BlockUtils.SIDE_RIGHT[this.myTile.getFacing()], mouseButton);
        } else if (40 <= x && x < 56 && 64 <= y && y < 80) {
            this.handleSideChange(0, mouseButton);
        } else if (60 <= x && x < 76 && 64 <= y && y < 80) {
            this.handleSideChange(BlockUtils.SIDE_OPPOSITE[this.myTile.getFacing()], mouseButton);
        }
        return true;
    }

    protected void drawBackground() {
        super.drawBackground();
        if (this.isFullyOpened()) {
            float colorR = (float)(this.backgroundColor >> 16 & 0xFF) / 255.0f * 0.6f;
            float colorG = (float)(this.backgroundColor >> 8 & 0xFF) / 255.0f * 0.6f;
            float colorB = (float)(this.backgroundColor & 0xFF) / 255.0f * 0.6f;
            GL11.glColor4f((float)colorR, (float)colorG, (float)colorB, (float)1.0f);
            this.gui.func_73729_b(this.posX + 16, this.posY + 20, 16, 20, 64, 64);
        }
    }

    void handleSideChange(int side, int mouseButton) {
        if (GuiScreen.func_73877_p()) {
            if (side == this.myTile.getFacing()) {
                if (this.myTile.resetSides()) {
                    GuiRoot.guiSoundManager.func_77366_a("random.click", 1.0f, 0.2f);
                }
            } else if (this.myTile.setSide(side, 0)) {
                GuiRoot.guiSoundManager.func_77366_a("random.click", 1.0f, 0.4f);
            }
            return;
        }
        if (mouseButton == 0) {
            if (this.myTile.incrSide(side)) {
                GuiRoot.guiSoundManager.func_77366_a("random.click", 1.0f, 0.8f);
            }
        } else if (mouseButton == 1 && this.myTile.decrSide(side)) {
            GuiRoot.guiSoundManager.func_77366_a("random.click", 1.0f, 0.6f);
        }
    }
}

