/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tesseract;

import buildcraft.api.gates.IOverrideDefaultTriggers;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Property;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.tileentity.ITesseract;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.block.tesseract.BlockTesseract;
import thermalexpansion.block.tesseract.TesseractRegistry;

public abstract class TileTesseractRoot
extends TileRSControl
implements ITesseract,
ITilePacketHandler,
IOverrideDefaultTriggers {
    public static final String DEFAULT_OWNER = "[None]";
    public int frequency = -1;
    public String owner = "[None]";
    public String type = "base";
    public byte mode = (byte)2;
    public byte access = 0;
    public boolean isActive = false;
    public boolean saveSettings = false;
    int outputTrackerAdjacent;
    int outputTrackerRemote;
    public static int guiId = ThermalExpansion.proxy.registerGui("Tesseract", true);
    public static int[] packetIds = new int[4];

    public TileTesseractRoot(String type) {
        this.type = type;
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(3, 2, 1, 0, 1);
        payload.boolPayload[0] = this.isActive;
        payload.boolPayload[1] = this.redstoneDisable;
        payload.boolPayload[2] = this.redstoneState;
        payload.bytePayload[0] = this.mode;
        payload.bytePayload[1] = this.access;
        payload.intPayload[0] = this.frequency;
        payload.stringPayload[0] = this.owner;
        PacketTile packet = new PacketTile(packetIds[BlockTesseract.Packets.DESCRIPTION.ordinal()], this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public Packet getEntryPacket(int theFreq, String freqName, String type, boolean remove) {
        Payload payload = new Payload(1, 0, 0, 0, 3);
        payload.boolPayload[0] = remove;
        payload.stringPayload[0] = this.isPublic() ? "_public_" : this.owner.toLowerCase();
        payload.stringPayload[1] = String.valueOf(theFreq);
        payload.stringPayload[2] = freqName;
        PacketTile packet = new PacketTile(packetIds[BlockTesseract.Packets.ENTRY.ordinal()], this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public Packet getNameListPacket() {
        String lookupName = (this.isPublic() ? "_Public_" : this.owner) + "." + this.type;
        ConfigCategory curList = TesseractRegistry.linkConf.getCategory(lookupName.toLowerCase());
        if (curList != null) {
            Payload payload = new Payload(0, 0, 1, 0, curList.size() * 2);
            payload.intPayload[0] = curList.size();
            int i = 0;
            for (Property curProp : curList.values()) {
                payload.stringPayload[i * 2] = curProp.getName();
                payload.stringPayload[i * 2 + 1] = curProp.getString();
                ++i;
            }
            PacketTile packet = new PacketTile(packetIds[BlockTesseract.Packets.NAME_LIST.ordinal()], this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
            return packet.getPacket();
        }
        Payload payload = new Payload(0, 0, 1, 0, 0);
        payload.intPayload[0] = 0;
        PacketTile packet = new PacketTile(packetIds[BlockTesseract.Packets.NAME_LIST.ordinal()], this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public Packet getTileInfoPacket(int theFreq) {
        Payload payload = new Payload(0, 2, 1, 0, 0);
        payload.bytePayload[0] = this.mode;
        payload.bytePayload[1] = this.access;
        payload.intPayload[0] = theFreq;
        PacketTile packet = new PacketTile(packetIds[BlockTesseract.Packets.TILE_INFO.ordinal()], this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void setTileInfo(int theFreq) {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            this.frequency = theFreq;
            PacketUtils.sendToServer((Packet)this.getTileInfoPacket(theFreq));
        }
    }

    public void addEntry(int theFreq, String freqName) {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getEntryPacket(theFreq, freqName, this.type, false));
        }
    }

    public void removeEntry(int theFreq, String freqName) {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getEntryPacket(theFreq, freqName, this.type, true));
        }
    }

    public boolean clearSave() {
        if (!this.saveSettings) {
            return false;
        }
        this.saveSettings = false;
        return true;
    }

    public boolean setSave() {
        if (!this.saveSettings) {
            this.saveSettings = true;
            return true;
        }
        return false;
    }

    public void handleTilePacket(PacketTile packet) {
        int id = packet.getPacketId();
        if (id == packetIds[BlockTesseract.Packets.DESCRIPTION.ordinal()]) {
            this.isActive = packet.payload.boolPayload[0];
            this.redstoneDisable = packet.payload.boolPayload[1];
            this.redstoneState = packet.payload.boolPayload[2];
            this.mode = packet.payload.bytePayload[0];
            this.access = packet.payload.bytePayload[1];
            this.frequency = packet.payload.intPayload[0];
            this.owner = packet.payload.stringPayload[0];
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return;
        }
        if (id == packetIds[BlockTesseract.Packets.ENTRY.ordinal()]) {
            boolean remove = packet.payload.boolPayload[0];
            Property freqEntry = TesseractRegistry.linkConf.get(packet.payload.stringPayload[0] + "." + this.type, packet.payload.stringPayload[1], packet.payload.stringPayload[2]);
            freqEntry.set(packet.payload.stringPayload[2]);
            if (remove) {
                TesseractRegistry.linkConf.getCategory(packet.payload.stringPayload[0] + "." + this.type).remove((Object)packet.payload.stringPayload[1]);
            }
            packet.player.field_71135_a.func_72567_b(this.getNameListPacket());
            TesseractRegistry.linkConf.save();
            return;
        }
        if (id == packetIds[BlockTesseract.Packets.NAME_LIST.ordinal()]) {
            TesseractRegistry.clientFrequencyNames = new LinkedHashMap();
            TesseractRegistry.clientFrequencyNamesReversed = new LinkedHashMap();
            for (int i = 0; i < packet.payload.intPayload[0]; ++i) {
                if (packet.payload.stringPayload[i * 2 + 1].equals("")) continue;
                TesseractRegistry.clientFrequencyNames.put(packet.payload.stringPayload[i * 2], packet.payload.stringPayload[i * 2 + 1]);
                TesseractRegistry.clientFrequencyNamesReversed.put(packet.payload.stringPayload[i * 2 + 1], packet.payload.stringPayload[i * 2]);
            }
            ThermalExpansion.proxy.updateTeleportGui();
            return;
        }
        if (id == packetIds[BlockTesseract.Packets.TILE_INFO.ordinal()]) {
            this.removeFromRegistry();
            this.mode = packet.payload.bytePayload[0];
            this.access = packet.payload.bytePayload[1];
            this.frequency = packet.payload.intPayload[0];
            this.addToRegistry();
            this.isActive = this.frequency != -1;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockTesseract.field_71990_ca);
            packet.player.field_71135_a.func_72567_b(this.getNameListPacket());
            return;
        }
    }

    public abstract List getValidInputs();

    public abstract List getValidOutputs();

    public abstract void addToRegistry();

    public abstract void removeFromRegistry();

    public abstract void incrementOutputTrackerAdjacent();

    public void incrementOutputTrackerRemote(int max) {
        ++this.outputTrackerRemote;
        if (this.outputTrackerRemote > max) {
            this.outputTrackerRemote = 0;
        }
    }

    public abstract int getId();

    public String getName() {
        return "tesseract." + this.type;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? 7 : 0;
    }

    public void onChunkUnload() {
        this.removeFromRegistry();
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (CoreUtils.isFalsePlayer((EntityPlayer)player)) {
            return false;
        }
        if (this.isPublic() || this.owner.equalsIgnoreCase(player.field_71092_bJ) || CoreUtils.isOp((EntityPlayer)player)) {
            ((EntityPlayerMP)player).field_71135_a.func_72567_b(this.getNameListPacket());
            player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            return true;
        }
        player.func_70006_a("This Tesseract is private and belongs to " + this.owner + "! You could have lost your hand!");
        return false;
    }

    public void setOwnerName(String playerName) {
        this.owner = playerName;
    }

    public boolean isPublic() {
        return this.access == 0;
    }

    public boolean isFriends() {
        return this.access == 1;
    }

    public boolean isPrivate() {
        return this.access == 2;
    }

    public boolean canSend() {
        return this.mode != 1;
    }

    public boolean canReceive() {
        return this.mode != 0;
    }

    public boolean isOwner(String username) {
        return username == null ? false : username.equals(this.owner);
    }

    public boolean canPlayerBreak(String username) {
        return this.isPublic() || this.owner.equals(DEFAULT_OWNER) || this.owner.equals(username);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.frequency = data.func_74762_e("frequency");
        this.owner = data.func_74779_i("owner");
        if (this.owner == "") {
            this.owner = DEFAULT_OWNER;
        }
        this.mode = data.func_74771_c("mode");
        this.access = data.func_74771_c("flag.access");
        this.isActive = data.func_74767_n("flag.active");
        this.saveSettings = data.func_74767_n("flag.save");
        this.outputTrackerAdjacent = data.func_74762_e("output.adjacent");
        this.outputTrackerRemote = data.func_74762_e("output.remote");
        this.addToRegistry();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("frequency", this.frequency);
        data.func_74778_a("owner", this.owner);
        data.func_74774_a("mode", this.mode);
        data.func_74774_a("flag.access", this.access);
        data.func_74757_a("flag.active", this.isActive);
        data.func_74757_a("flag.save", this.saveSettings);
        data.func_74768_a("output.adjacent", this.outputTrackerAdjacent);
        data.func_74768_a("output.remote", this.outputTrackerRemote);
    }

    public String getOwner() {
        return this.isPublic() ? "_public_" : this.owner;
    }

    @Override
    public List getValidInputLinks() {
        return this.getValidInputs();
    }

    @Override
    public List getValidOutputLinks() {
        return this.getValidOutputs();
    }

    @Override
    public LinkedList getTriggers() {
        return null;
    }

    static {
        TileTesseractRoot.packetIds[BlockTesseract.Packets.DESCRIPTION.ordinal()] = PacketHandler.getAvailablePacketId();
        TileTesseractRoot.packetIds[BlockTesseract.Packets.ENTRY.ordinal()] = PacketHandler.getAvailablePacketId();
        TileTesseractRoot.packetIds[BlockTesseract.Packets.NAME_LIST.ordinal()] = PacketHandler.getAvailablePacketId();
        TileTesseractRoot.packetIds[BlockTesseract.Packets.TILE_INFO.ordinal()] = PacketHandler.getAvailablePacketId();
    }
}

