/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.tesseract;

import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.liquid.LiquidTankDummy;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.tesseract.BlockTesseract;
import thermalexpansion.block.tesseract.TesseractRegistry;
import thermalexpansion.block.tesseract.TileTesseractRoot;
import thermalexpansion.util.Utils;

public class TileTesseractLiquid
extends TileTesseractRoot
implements ITankContainer {
    private LiquidTankDummy myTank = new LiquidTankDummy((ITankContainer)this);

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileTesseractLiquid.class, (String)"cofh.thermalexpansion.TesseractLiquid", (String[])new String[]{"thermalexpansion.transport.TeleportLiquid"});
    }

    public TileTesseractLiquid() {
        super("liquid");
    }

    @Override
    public List getValidInputs() {
        List theTeleports = TesseractRegistry.getLinkedInputs(this);
        LinkedList<TileTesseractLiquid> validInputs = new LinkedList<TileTesseractLiquid>();
        if (theTeleports == null || !this.redstoneControlOrDisable()) {
            return validInputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            TileTesseractLiquid curTile = (TileTesseractLiquid)theTeleports.get(i);
            if (curTile.equals(this) || !curTile.redstoneControlOrDisable()) continue;
            validInputs.add(curTile);
        }
        return validInputs;
    }

    @Override
    public List getValidOutputs() {
        List theTeleports = TesseractRegistry.getLinkedOutputs(this);
        LinkedList<TileTesseractLiquid> validOutputs = new LinkedList<TileTesseractLiquid>();
        if (theTeleports == null || !this.redstoneControlOrDisable()) {
            return validOutputs;
        }
        for (int i = 0; i < theTeleports.size(); ++i) {
            TileTesseractLiquid curTile = (TileTesseractLiquid)theTeleports.get(i);
            if (curTile.equals(this) || !curTile.redstoneControlOrDisable()) continue;
            validOutputs.add(curTile);
        }
        return validOutputs;
    }

    @Override
    public void addToRegistry() {
        if (this.frequency == -1) {
            return;
        }
        TesseractRegistry.add(this);
    }

    @Override
    public void removeFromRegistry() {
        TesseractRegistry.remove(this);
    }

    @Override
    public void incrementOutputTrackerAdjacent() {
        int theSide;
        ++this.outputTrackerAdjacent;
        for (theSide = this.outputTrackerAdjacent; theSide < 6; ++theSide) {
            if (!Utils.isAdjacentTank(this, theSide)) continue;
            this.outputTrackerAdjacent = theSide;
            return;
        }
        for (theSide = 0; theSide < this.outputTrackerAdjacent && theSide < 6; ++theSide) {
            if (!Utils.isAdjacentTank(this, theSide)) continue;
            this.outputTrackerAdjacent = theSide;
            return;
        }
        this.outputTrackerAdjacent = 0;
    }

    public int sendLiquid(LiquidStack theStack, boolean doFill) {
        int i;
        List validOutputs = this.getValidOutputs();
        int startAmount = theStack.amount;
        if (validOutputs.size() <= 0 || startAmount <= 0) {
            return 0;
        }
        for (i = this.outputTrackerRemote; i < validOutputs.size() && theStack != null && theStack.amount > 0; ++i) {
            theStack = ((TileTesseractLiquid)validOutputs.get(i)).receiveLiquid(theStack, doFill);
        }
        for (i = 0; i < validOutputs.size() && i < this.outputTrackerRemote && theStack != null && theStack.amount > 0; ++i) {
            theStack = ((TileTesseractLiquid)validOutputs.get(i)).receiveLiquid(theStack, doFill);
        }
        this.incrementOutputTrackerRemote(validOutputs.size() - 1);
        return startAmount - theStack.amount;
    }

    public LiquidStack receiveLiquid(LiquidStack theStack, boolean doFill) {
        int theSide;
        for (theSide = this.outputTrackerAdjacent; theSide < 6 && theStack != null && theStack.amount > 0; ++theSide) {
            theStack.amount -= this.addToAdjTank(this, theSide, theStack.copy(), doFill);
        }
        for (theSide = 0; theSide < this.outputTrackerAdjacent && theSide < 6 && theStack != null && theStack.amount > 0; ++theSide) {
            theStack.amount -= this.addToAdjTank(this, theSide, theStack.copy(), doFill);
        }
        this.incrementOutputTrackerAdjacent();
        return theStack;
    }

    public int addToAdjTank(TileEntity tile, int from, LiquidStack theLiquid, boolean doFill) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)tile.field_70329_l, (int)tile.field_70330_m, (int)tile.field_70327_n, (int)from);
        TileEntity tilePipe = tile.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (tilePipe instanceof TileTesseractLiquid) {
            return 0;
        }
        return Utils.addToAdjTank(this, from, theLiquid, doFill);
    }

    @Override
    public int getId() {
        return BlockTesseract.Types.LIQUID.ordinal();
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.frequency == -1 || !this.canSend() || CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return 0;
        }
        if (this.redstoneControlOrDisable()) {
            return this.sendLiquid(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.myTank;
    }
}

