/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.crafting.TransposerManager;

public class TileTransposer
extends TileMachinePower
implements ITankContainer {
    public static final int ID = Machines.Types.TRANSPOSER.ordinal();
    static int outputChance = 100;
    static final int RATE = 100;
    public static final int MAX_LIQUID = 10000;
    LiquidTankAdv myTank = new LiquidTankAdv(10000);
    public LiquidStack renderLiquid = new LiquidStack(0, 0);
    public boolean reverseFlag;
    public boolean reverse;
    int outputTracker;
    int outputTrackerLiquid;
    private static int modePacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        Machines.guiIds[TileTransposer.ID] = ThermalExpansion.proxy.registerGui("Transposer", true);
        GameRegistry.registerTileEntityWithAlternatives(TileTransposer.class, (String)"cofh.thermalexpansion.Transposer", (String[])new String[]{"thermalexpansion.factory.Filler"});
    }

    public TileTransposer() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[2];
        this.processInv = new ItemStack[1];
    }

    @Override
    public int getId() {
        return ID;
    }

    public Packet getModePacket() {
        Payload payload = new Payload(1, 0, 0, 0, 0);
        payload.boolPayload[0] = this.reverseFlag;
        PacketTile packet = new PacketTile(modePacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void setMode(boolean mode) {
        this.reverseFlag = mode;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getModePacket());
        }
    }

    public LiquidTankAdv getTank() {
        return this.myTank;
    }

    public LiquidStack getTankLiquid() {
        return this.myTank.getLiquidNoCopy();
    }

    public int getScaledLiquid(int scale) {
        if (this.myTank.getLiquidID() <= 0) {
            return 0;
        }
        return this.myTank.getLiquidAmount() * scale / 10000;
    }

    @Override
    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == modePacketId) {
            this.reverseFlag = packet.payload.boolPayload[0];
            if (this.processCur == 0.0f) {
                this.reverse = this.reverseFlag;
                if (this.reverse) {
                    this.myTank.setTankPressure(1);
                } else {
                    this.myTank.setTankPressure(0);
                }
            }
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, TEBlocks.blockMachine.field_71990_ca);
        } else {
            super.handleTilePacket(packet);
        }
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        if (!this.reverse) {
            if (this.myTank.getLiquidID() <= 0) {
                return false;
            }
            TransposerManager.TransposerRecipe recipeFill = TransposerManager.getFillRecipe(this.inventory[0], this.myTank.getLiquidNoCopy());
            if (recipeFill == null) {
                return false;
            }
            int energy = recipeFill.getEnergy();
            if (this.myProvider.getEnergyStored() < (float)energy) {
                return false;
            }
            int liquid = recipeFill.getLiquid().amount;
            if (this.myTank.getLiquidAmount() < liquid) {
                return false;
            }
            if (this.inventory[1] == null) {
                return true;
            }
            ItemStack output = recipeFill.getOutput();
            if (!this.inventory[1].func_77969_a(output)) {
                return false;
            }
            int result = this.inventory[1].field_77994_a + output.field_77994_a;
            return result <= this.func_70297_j_() && result <= output.func_77976_d();
        }
        TransposerManager.TransposerRecipe recipeExtraction = TransposerManager.getExtractionRecipe(this.inventory[0]);
        if (recipeExtraction == null) {
            return false;
        }
        int energy = recipeExtraction.getEnergy();
        if (this.myProvider.getEnergyStored() < (float)energy) {
            return false;
        }
        LiquidStack liquid = recipeExtraction.getLiquid();
        if (this.myTank.fill(liquid, false) != liquid.amount) {
            return false;
        }
        if (this.inventory[1] == null) {
            return true;
        }
        ItemStack output = recipeExtraction.getOutput();
        if (output == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        int result = this.inventory[1].field_77994_a + output.field_77994_a;
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    @Override
    public boolean canFinish() {
        TransposerManager.TransposerRecipe recipe;
        if (this.processCur < this.processEnd) {
            return false;
        }
        ItemStack output = null;
        if (!this.reverse) {
            if (this.myTank.getLiquidID() <= 0) {
                this.processCur = 0.0f;
                this.isActive = false;
                return false;
            }
            recipe = TransposerManager.getFillRecipe(this.processInv[0], this.myTank.getLiquidNoCopy());
            if (recipe == null) {
                this.processCur = 0.0f;
                this.isActive = false;
                return false;
            }
            output = recipe.getOutput();
        } else {
            recipe = TransposerManager.getExtractionRecipe(this.processInv[0]);
            if (recipe == null) {
                this.processCur = 0.0f;
                this.isActive = false;
                return false;
            }
            output = recipe.getOutput();
            if (output == null) {
                return true;
            }
        }
        if (this.inventory[1] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(output)) {
            return false;
        }
        int result = this.inventory[1].field_77994_a + output.field_77994_a;
        return result <= this.func_70297_j_() && result <= output.func_77976_d();
    }

    @Override
    protected void processStart() {
        this.processInv[0] = this.inventory[0].func_77946_l();
        if (!this.reverse) {
            this.processEnd = TransposerManager.getFillRecipe(this.processInv[0], this.myTank.getLiquidNoCopy()).getEnergy();
            this.renderLiquid = this.myTank.getLiquid();
        } else {
            this.processEnd = TransposerManager.getExtractionRecipe(this.processInv[0]).getEnergy();
            this.renderLiquid = TransposerManager.getExtractionRecipe(this.processInv[0]).getLiquid();
        }
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void processFinish() {
        if (!this.reverse) {
            TransposerManager.TransposerRecipe recipeFill = TransposerManager.getFillRecipe(this.processInv[0], this.myTank.getLiquidNoCopy());
            ItemStack output = recipeFill.getOutput();
            if (this.inventory[1] == null) {
                this.inventory[1] = output;
            } else {
                this.inventory[1].field_77994_a += output.field_77994_a;
            }
            this.myTank.drain(recipeFill.getLiquid().amount, true);
        } else {
            TransposerManager.TransposerRecipe recipeExtraction = TransposerManager.getExtractionRecipe(this.processInv[0]);
            ItemStack output = recipeExtraction.getOutput();
            int outputItemChance = recipeExtraction.getChance();
            if (this.field_70331_k.field_73012_v.nextInt(outputChance) < outputItemChance) {
                if (this.inventory[1] == null) {
                    this.inventory[1] = output;
                } else {
                    this.inventory[1].field_77994_a += output.field_77994_a;
                }
            }
            this.myTank.fill(recipeExtraction.getLiquid(), true);
        }
        this.reverse = this.reverseFlag;
        if (this.reverse) {
            this.myTank.setTankPressure(1);
        } else {
            this.myTank.setTankPressure(0);
        }
    }

    protected void transferLiquid() {
        if (this.myTank.getLiquidAmount() <= 0) {
            return;
        }
        for (int i = this.outputTrackerLiquid + 1; i <= this.outputTrackerLiquid + 6; ++i) {
            int[] coords;
            TileEntity tile;
            int side = i % 6;
            if (this.sideCache[side] != 3 || !((tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof ITankContainer)) continue;
            int fillQty = MathHelper.minI((int)this.myTank.getLiquidAmount(), (int)100);
            int quantity = ((ITankContainer)tile).fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), new LiquidStack(this.myTank.getLiquidID(), fillQty, this.myTank.getLiquidMeta()), true);
            if (quantity <= 0) continue;
            this.myTank.drain(quantity, true);
            this.outputTrackerLiquid = side;
            break;
        }
    }

    @Override
    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(1, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.reverse && this.myTank.getLiquidID() > 0) {
            this.transferLiquid();
        }
        super.func_70316_g();
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.reverseFlag = j == 1;
            }
            case 1: {
                this.reverse = j == 1;
                return;
            }
            case 2: {
                this.myTank.setLiquidID(j);
                return;
            }
            case 3: {
                this.myTank.setLiquidMeta(j);
                return;
            }
            case 4: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (this.reverseFlag) {
            iCrafting.func_71112_a(container, 0, 1);
        } else {
            iCrafting.func_71112_a(container, 0, 0);
        }
        if (this.reverse) {
            iCrafting.func_71112_a(container, 1, 1);
        } else {
            iCrafting.func_71112_a(container, 1, 0);
        }
        if (this.myTank.getLiquidID() > 0 && this.myTank.getLiquidID() != this.renderLiquid.itemID) {
            this.renderLiquid = this.myTank.getLiquid().copy();
        }
        iCrafting.func_71112_a(container, 2, this.renderLiquid.itemID);
        iCrafting.func_71112_a(container, 3, this.renderLiquid.itemMeta);
        iCrafting.func_71112_a(container, 4, this.myTank.getLiquidAmount());
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
        this.outputTrackerLiquid = data.func_74762_e("output.liquid");
        this.reverseFlag = this.reverse = data.func_74767_n("process.mode");
        if (this.reverse) {
            this.myTank.setTankPressure(1);
        } else {
            this.myTank.setTankPressure(0);
        }
        if (data.func_74764_b("tank")) {
            this.myTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("tank")));
            this.renderLiquid = this.myTank.getLiquid();
        } else if (this.processInv[0] != null && this.reverse && TransposerManager.getExtractionRecipe(this.processInv[0]) != null) {
            this.renderLiquid = TransposerManager.getExtractionRecipe(this.processInv[0]).getLiquid();
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
        data.func_74768_a("output.liquid", this.outputTrackerLiquid);
        data.func_74757_a("process.mode", this.reverse);
        if (this.myTank.getLiquidID() > 0) {
            data.func_74782_a("tank", (NBTBase)this.myTank.getLiquidNoCopy().writeToNBT(new NBTTagCompound()));
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.reverse) {
            return 0;
        }
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        return this.myTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.reverse) {
            return null;
        }
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 3) {
            return null;
        }
        return this.myTank.drain(maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.reverse && this.sideCache[direction.ordinal()] != 3) {
            return new ILiquidTank[0];
        }
        if (!this.reverse && this.sideCache[direction.ordinal()] != 1) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.reverse && this.sideCache[direction.ordinal()] != 3) {
            return null;
        }
        if (!this.reverse && this.sideCache[direction.ordinal()] != 1) {
            return null;
        }
        return this.myTank;
    }
}

