/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.BlockUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.crafting.SmelterManager;

public class TileSmelter
extends TileMachinePower {
    public static final int ID = Machines.Types.SMELTER.ordinal();
    static int secondaryChance = 100;
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        Machines.guiIds[TileSmelter.ID] = ThermalExpansion.proxy.registerGui("Smelter", true);
        GameRegistry.registerTileEntityWithAlternatives(TileSmelter.class, (String)"cofh.thermalexpansion.Smelter", (String[])new String[]{"thermalexpansion.factory.Smelter"});
    }

    public TileSmelter() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[5];
        this.processInv = new ItemStack[2];
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null && this.inventory[1] == null) {
            return false;
        }
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.inventory[0], this.inventory[1]);
        if (recipe == null) {
            return false;
        }
        if (recipe.getPrimaryInput().func_77969_a(this.inventory[0]) ? recipe.getPrimaryInput().field_77994_a > this.inventory[0].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[1].field_77994_a : recipe.getPrimaryInput().field_77994_a > this.inventory[1].field_77994_a || recipe.getSecondaryInput().field_77994_a > this.inventory[0].field_77994_a) {
            return false;
        }
        int energy = recipe.getEnergy();
        if (this.myProvider.getEnergyStored() < (float)energy) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[4] != null) {
            if (!this.inventory[4].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[4].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(primaryItem) && !this.inventory[3].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            int result = this.inventory[3].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        if (!this.inventory[3].func_77969_a(primaryItem)) {
            int result = this.inventory[2].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        int result = this.inventory[2].field_77994_a + this.inventory[3].field_77994_a + primaryItem.field_77994_a;
        return result <= primaryItem.func_77976_d() * 2;
    }

    @Override
    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.processInv[0], this.processInv[1]);
        if (recipe == null) {
            this.processCur = 0.0f;
            this.isActive = false;
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[4] != null) {
            if (!this.inventory[4].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[4].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[2].func_77969_a(primaryItem) && !this.inventory[3].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            int result = this.inventory[3].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        if (!this.inventory[3].func_77969_a(primaryItem)) {
            int result = this.inventory[2].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        int result = this.inventory[2].field_77994_a + this.inventory[3].field_77994_a + primaryItem.field_77994_a;
        return result <= primaryItem.func_77976_d() * 2;
    }

    @Override
    protected void processStart() {
        this.processInv[0] = this.inventory[0].func_77946_l();
        this.processInv[1] = this.inventory[1].func_77946_l();
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.processInv[0], this.processInv[1]);
        this.processEnd = recipe.getEnergy();
        if (recipe.getPrimaryInput().func_77969_a(this.inventory[0])) {
            this.inventory[0].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[1].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        } else {
            this.inventory[1].field_77994_a -= recipe.getPrimaryInput().field_77994_a;
            this.inventory[0].field_77994_a -= recipe.getSecondaryInput().field_77994_a;
        }
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[1].field_77994_a <= 0) {
            this.inventory[1] = null;
        }
    }

    @Override
    protected void processFinish() {
        SmelterManager.SmelterRecipe recipe = SmelterManager.getRecipe(this.processInv[0], this.processInv[1]);
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[2] == null) {
            this.inventory[2] = primaryItem;
        } else if (this.inventory[2].func_77969_a(primaryItem)) {
            int result = this.inventory[2].field_77994_a + primaryItem.field_77994_a;
            if (result <= primaryItem.func_77976_d()) {
                this.inventory[2].field_77994_a += primaryItem.field_77994_a;
            } else {
                int stackDiff = primaryItem.func_77976_d() - this.inventory[2].field_77994_a;
                this.inventory[2].field_77994_a += stackDiff;
                if (this.inventory[3] == null) {
                    this.inventory[3] = primaryItem;
                    this.inventory[3].field_77994_a = primaryItem.field_77994_a - stackDiff;
                } else {
                    this.inventory[3].field_77994_a += primaryItem.field_77994_a - stackDiff;
                }
            }
        } else if (this.inventory[3] == null) {
            this.inventory[3] = primaryItem;
        } else {
            this.inventory[3].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null) {
            int secondaryItemChance = recipe.getSecondaryOutputChance();
            if (this.field_70331_k.field_73012_v.nextInt(secondaryChance) < secondaryItemChance) {
                if (this.inventory[4] == null) {
                    this.inventory[4] = secondaryItem;
                } else {
                    this.inventory[4].field_77994_a += secondaryItem.field_77994_a;
                }
            }
        }
    }

    @Override
    protected void transferProducts() {
        int side;
        int i;
        for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 2 && this.sideCache[side] != 4) continue;
            if (this.ejectItem(2, 4, side)) {
                if (!this.ejectItem(3, 4, side)) {
                    this.ejectItem(2, 4, side);
                }
                this.outputTrackerPrimary = side;
                break;
            }
            if (!this.ejectItem(3, 4, side)) continue;
            if (!this.ejectItem(2, 4, side)) {
                this.ejectItem(3, 4, side);
            }
            this.outputTrackerPrimary = side;
            break;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 3 && this.sideCache[side] != 4 || !this.ejectItem(4, 4, side)) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTrackerPrimary = data.func_74762_e("output.primary");
        this.outputTrackerSecondary = data.func_74762_e("output.secondary");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output.primary", this.outputTrackerPrimary);
        data.func_74768_a("output.secondary", this.outputTrackerSecondary);
    }

    @Override
    public boolean setFacing(int i) {
        this.sideCache[i] = 0;
        this.sideCache[BlockUtils.SIDE_OPPOSITE[i]] = 6;
        this.sideCache[BlockUtils.SIDE_LEFT[i]] = 5;
        this.facing = (byte)i;
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }
}

