/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.crafting.SawmillManager;

public class TileSawmill
extends TileMachinePower {
    public static final int ID = Machines.Types.SAWMILL.ordinal();
    static int secondaryChance = 100;
    int outputTrackerPrimary;
    int outputTrackerSecondary;

    public static void initialize() {
        Machines.guiIds[TileSawmill.ID] = ThermalExpansion.proxy.registerGui("Sawmill", true);
        GameRegistry.registerTileEntityWithAlternatives(TileSawmill.class, (String)"cofh.thermalexpansion.Sawmill", (String[])new String[]{"thermalexpansion.factory.Sawmill"});
    }

    public TileSawmill() {
        this.sideCache = new byte[]{3, 3, 2, 2, 2, 2};
        this.inventory = new ItemStack[4];
        this.processInv = new ItemStack[1];
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    public boolean canStart() {
        if (this.inventory[0] == null) {
            return false;
        }
        SawmillManager.SawmillRecipe recipe = SawmillManager.getRecipe(this.inventory[0]);
        if (recipe == null) {
            return false;
        }
        int energy = recipe.getEnergy();
        if (this.myProvider.getEnergyStored() < (float)energy) {
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[1] == null || this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(primaryItem) && !this.inventory[2].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[1].func_77969_a(primaryItem)) {
            int result = this.inventory[2].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            int result = this.inventory[1].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        int result = this.inventory[1].field_77994_a + this.inventory[2].field_77994_a + primaryItem.field_77994_a;
        return result <= primaryItem.func_77976_d() * 2;
    }

    @Override
    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        SawmillManager.SawmillRecipe recipe = SawmillManager.getRecipe(this.processInv[0]);
        if (recipe == null) {
            this.processCur = 0.0f;
            this.isActive = false;
            return false;
        }
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (secondaryItem != null && this.inventory[3] != null) {
            if (!this.inventory[3].func_77969_a(secondaryItem)) {
                return false;
            }
            if (this.inventory[3].field_77994_a + secondaryItem.field_77994_a > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        if (this.inventory[1] == null || this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[1].func_77969_a(primaryItem) && !this.inventory[2].func_77969_a(primaryItem)) {
            return false;
        }
        if (!this.inventory[1].func_77969_a(primaryItem)) {
            int result = this.inventory[2].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        if (!this.inventory[2].func_77969_a(primaryItem)) {
            int result = this.inventory[1].field_77994_a + primaryItem.field_77994_a;
            return result <= primaryItem.func_77976_d();
        }
        int result = this.inventory[1].field_77994_a + this.inventory[2].field_77994_a + primaryItem.field_77994_a;
        return result <= primaryItem.func_77976_d() * 2;
    }

    @Override
    protected void processStart() {
        this.processInv[0] = this.inventory[0].func_77946_l();
        SawmillManager.SawmillRecipe recipe = SawmillManager.getRecipe(this.processInv[0]);
        this.processEnd = recipe.getEnergy();
        this.inventory[0].field_77994_a -= recipe.getInput().field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void processFinish() {
        SawmillManager.SawmillRecipe recipe = SawmillManager.getRecipe(this.processInv[0]);
        ItemStack primaryItem = recipe.getPrimaryOutput();
        ItemStack secondaryItem = recipe.getSecondaryOutput();
        if (this.inventory[1] == null) {
            this.inventory[1] = primaryItem;
        } else if (this.inventory[1].func_77969_a(primaryItem)) {
            int result = this.inventory[1].field_77994_a + primaryItem.field_77994_a;
            if (result <= primaryItem.func_77976_d()) {
                this.inventory[1].field_77994_a += primaryItem.field_77994_a;
            } else {
                int stackDiff = primaryItem.func_77976_d() - this.inventory[1].field_77994_a;
                this.inventory[1].field_77994_a += stackDiff;
                if (this.inventory[2] == null) {
                    this.inventory[2] = primaryItem;
                    this.inventory[2].field_77994_a = primaryItem.field_77994_a - stackDiff;
                } else {
                    this.inventory[2].field_77994_a += primaryItem.field_77994_a - stackDiff;
                }
            }
        } else if (this.inventory[2] == null) {
            this.inventory[2] = primaryItem;
        } else {
            this.inventory[2].field_77994_a += primaryItem.field_77994_a;
        }
        if (secondaryItem != null) {
            int secondaryItemChance = recipe.getSecondaryOutputChance();
            if (this.field_70331_k.field_73012_v.nextInt(secondaryChance) < secondaryItemChance) {
                if (this.inventory[3] == null) {
                    this.inventory[3] = secondaryItem;
                } else {
                    this.inventory[3].field_77994_a += secondaryItem.field_77994_a;
                }
            }
        }
    }

    @Override
    protected void transferProducts() {
        int side;
        int i;
        for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 2 && this.sideCache[side] != 4) continue;
            if (this.ejectItem(1, 4, side)) {
                if (!this.ejectItem(2, 4, side)) {
                    this.ejectItem(1, 4, side);
                }
                this.outputTrackerPrimary = side;
                break;
            }
            if (!this.ejectItem(2, 4, side)) continue;
            if (!this.ejectItem(1, 4, side)) {
                this.ejectItem(2, 4, side);
            }
            this.outputTrackerPrimary = side;
            break;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (this.sideCache[side] != 3 && this.sideCache[side] != 4 || !this.ejectItem(3, 4, side)) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTrackerPrimary = data.func_74762_e("output.primary");
        this.outputTrackerSecondary = data.func_74762_e("output.secondary");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output.primary", this.outputTrackerPrimary);
        data.func_74768_a("output.secondary", this.outputTrackerSecondary);
    }
}

