/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.CoreUtils;
import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;

public class TileIceGen
extends TileMachinePower
implements ITankContainer {
    public static final int ID = Machines.Types.ICE_GEN.ordinal();
    static ItemStack[] processItems = new ItemStack[3];
    static int[] processWater;
    static int[] processEnergy;
    public static final int MAX_LIQUID = 4000;
    LiquidTankAdv myTank = new LiquidTankAdv(LiquidRegistry.WATER_ID, 0, 4000);
    byte curSelection;
    byte prevSelection;
    int outputTracker;
    private static int modePacketId;

    public static void initialize() {
        Machines.guiIds[TileIceGen.ID] = ThermalExpansion.proxy.registerGui("IceGen", true);
        GameRegistry.registerTileEntityWithAlternatives(TileIceGen.class, (String)"cofh.thermalexpansion.IceGen", (String[])new String[]{"thermalexpansion.factory.IceGen"});
    }

    public TileIceGen() {
        this.sideCache = new byte[]{2, 2, 1, 1, 1, 1};
        this.inventory = new ItemStack[4];
        this.inventory[1] = processItems[0];
        this.inventory[2] = processItems[1];
        this.inventory[3] = processItems[2];
        this.myTank.setLocked(true);
    }

    @Override
    public int getId() {
        return ID;
    }

    public LiquidStack getTankLiquid() {
        return this.myTank.getLiquidNoCopy();
    }

    public LiquidTankAdv getTank() {
        return this.myTank;
    }

    public int getCurSelection() {
        return this.curSelection;
    }

    public int getPrevSelection() {
        return this.prevSelection;
    }

    public Packet getModePacket() {
        Payload payload = new Payload(0, 1, 0, 0, 0);
        payload.bytePayload[0] = this.curSelection;
        PacketTile packet = new PacketTile(modePacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void setCurSelection(int i) {
        this.curSelection = (byte)i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            PacketUtils.sendToServer((Packet)this.getModePacket());
        }
    }

    public int getScaledLiquid(int id, int scale) {
        if (id == LiquidRegistry.WATER_ID) {
            if (this.myTank.getLiquidAmount() >= 4000) {
                return scale;
            }
            return this.myTank.getLiquidAmount() * scale / 4000;
        }
        return 0;
    }

    @Override
    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == modePacketId) {
            this.curSelection = packet.payload.bytePayload[0];
            if (this.processCur == 0.0f) {
                this.prevSelection = this.curSelection;
            }
        } else {
            super.handleTilePacket(packet);
        }
    }

    @Override
    public boolean canStart() {
        if (this.myProvider.getEnergyStored() < (float)processEnergy[this.curSelection]) {
            return false;
        }
        if (this.myTank.getLiquidAmount() < processWater[this.curSelection]) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (!this.inventory[0].func_77969_a(processItems[this.curSelection])) {
            return false;
        }
        int result = this.inventory[0].field_77994_a + TileIceGen.processItems[this.curSelection].field_77994_a;
        return result <= this.func_70297_j_() && result <= processItems[this.prevSelection].func_77976_d();
    }

    @Override
    public boolean canFinish() {
        if (this.processCur < this.processEnd) {
            return false;
        }
        if (this.inventory[0] == null) {
            return true;
        }
        if (this.inventory[0].func_77973_b() != processItems[this.prevSelection].func_77973_b()) {
            return false;
        }
        int result = this.inventory[0].field_77994_a + TileIceGen.processItems[this.prevSelection].field_77994_a;
        return result <= this.func_70297_j_() && result <= processItems[this.prevSelection].func_77976_d();
    }

    @Override
    protected void processStart() {
        this.processEnd = processEnergy[this.curSelection];
        this.myTank.adjustLiquid(-processWater[this.curSelection]);
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void processFinish() {
        if (this.inventory[0] == null) {
            this.inventory[0] = processItems[this.prevSelection].func_77946_l();
        } else {
            this.inventory[0].field_77994_a += TileIceGen.processItems[this.prevSelection].field_77994_a;
        }
        this.prevSelection = this.curSelection;
    }

    @Override
    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(0, 4, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void receiveGuiNetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.curSelection = (byte)j;
                return;
            }
            case 1: {
                this.prevSelection = (byte)j;
                return;
            }
            case 2: {
                this.myTank.setLiquidAmount(j);
                return;
            }
        }
    }

    @Override
    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, (int)this.curSelection);
        iCrafting.func_71112_a(container, 1, (int)this.prevSelection);
        iCrafting.func_71112_a(container, 2, this.myTank.getLiquidAmount());
        super.sendGuiNetworkData(container, iCrafting);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
        this.prevSelection = data.func_74771_c("selection.prev");
        this.curSelection = data.func_74771_c("selection.cur");
        this.myTank.setLiquidAmount(data.func_74762_e("qty.water"));
        this.inventory[1] = processItems[0];
        this.inventory[2] = processItems[1];
        this.inventory[3] = processItems[2];
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
        data.func_74774_a("selection.prev", this.prevSelection);
        data.func_74774_a("selection.cur", this.curSelection);
        data.func_74768_a("qty.water", this.myTank.getLiquidAmount());
    }

    @Override
    public int func_70302_i_() {
        return this.inventory.length - 3;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from != ForgeDirection.UNKNOWN && this.sideCache[from.ordinal()] != 1) {
            return 0;
        }
        return this.myTank.fill(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction == ForgeDirection.UNKNOWN) {
            return new ILiquidTank[0];
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.sideCache[direction.ordinal()] != 1) {
            return null;
        }
        return this.myTank;
    }

    static {
        TileIceGen.processItems[0] = new ItemStack(Item.field_77768_aD, 4, 0);
        TileIceGen.processItems[1] = new ItemStack(Block.field_72039_aU);
        TileIceGen.processItems[2] = new ItemStack(Block.field_72036_aT);
        processWater = new int[]{500, 500, 1000};
        processEnergy = new int[]{80, 80, 160};
        modePacketId = PacketHandler.getAvailablePacketId();
    }
}

