/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.machine;

import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.IChargeableItem;
import thermalexpansion.block.machine.Machines;
import thermalexpansion.block.machine.TileMachinePower;
import thermalexpansion.util.energy.PowerProviderAdv;

public class TileCharger
extends TileMachinePower {
    public static final int ID = Machines.Types.CHARGER.ordinal();
    int outputTracker;

    public static void initialize() {
        Machines.guiIds[TileCharger.ID] = ThermalExpansion.proxy.registerGui("Charger", true);
        GameRegistry.registerTileEntity(TileCharger.class, (String)"cofh.thermalexpansion.Charger");
    }

    public TileCharger() {
        this.config = Machines.powerData[this.getId()];
        this.myProvider = new PowerProviderAdv();
        this.myProvider.configure(2 * this.config.maxPower, this.config.maxEnergy);
        this.sideCache = new byte[]{1, 1, 2, 2, 2, 2};
        this.inventory = new ItemStack[2];
    }

    @Override
    public int getId() {
        return ID;
    }

    @Override
    protected boolean canStart() {
        return this.inventory[1] == null && this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IChargeableItem && this.myProvider.getEnergyStored() > 0.0f;
    }

    @Override
    protected void processStart() {
        this.inventory[1] = this.inventory[0].func_77946_l();
        this.inventory[1].field_77994_a = 1;
        --this.inventory[0].field_77994_a;
        if (this.inventory[0].field_77994_a <= 0) {
            this.inventory[0] = null;
        }
    }

    @Override
    protected void transferProducts() {
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (this.sideCache[side] != 2 || !this.ejectItem(1, 1, side)) continue;
            this.outputTracker = side;
            break;
        }
    }

    @Override
    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        boolean curActive = this.isActive;
        if (this.isActive) {
            float energy = MathHelper.minF((float)this.myProvider.getEnergyStored(), (float)this.getPower());
            if (this.inventory[1] != null && this.inventory[1].func_77973_b() instanceof IChargeableItem) {
                IChargeableItem theItem = (IChargeableItem)this.inventory[1].func_77973_b();
                this.myProvider.subtractEnergy(theItem.receiveEnergy(this.inventory[1], energy, true));
                if (theItem.getEnergyStored(this.inventory[1]) == theItem.getMaxEnergyStored(this.inventory[1])) {
                    this.transferProducts();
                    if (this.canStart() && this.redstoneControlOrDisable()) {
                        this.processStart();
                    } else {
                        this.isActive = false;
                        this.wasActive = true;
                        this.tracker.markTime(this.field_70331_k);
                    }
                }
            } else if (this.myProvider.getEnergyStored() == 0.0f || this.inventory[1] == null) {
                this.isActive = false;
                this.wasActive = true;
                this.tracker.markTime(this.field_70331_k);
            }
        } else if (this.redstoneControlOrDisable()) {
            if (this.field_70331_k.func_72820_D() % 40L == 0L) {
                this.transferProducts();
            }
            if (this.canStart()) {
                this.processStart();
                this.isActive = true;
            }
        }
        this.updateIfChanged(curActive);
    }

    @Override
    public float getPower() {
        if (!this.isActive || this.inventory[1] == null) {
            return 0.0f;
        }
        float power = 0.0f;
        power = this.myProvider.getEnergyStored() > this.config.maxPowerLevel ? (float)this.config.maxPower : (this.myProvider.getEnergyStored() < this.config.energyRamp ? this.config.minPower : this.myProvider.getEnergyStored() / this.config.energyRamp);
        return MathHelper.minF((float)power, (float)((IChargeableItem)this.inventory[1].func_77973_b()).receiveEnergy(this.inventory[1], power, false));
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.outputTracker = data.func_74762_e("output");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("output", this.outputTracker);
    }

    @Override
    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (super.func_102007_a(slot, itemstack, side)) {
            return itemstack == null ? false : itemstack.func_77973_b() instanceof IChargeableItem;
        }
        return false;
    }
}

