/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidRegistry;
import cofh.util.liquid.LiquidTankAdv;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.TileTERoot;

public class TileTankPortable
extends TileTERoot
implements ITilePacketHandler,
ITankContainer {
    public static final int RENDER_LEVELS = 100;
    static final int UPDATE_FACTOR = 4;
    public static final int MAX_LIQUID = 8000;
    protected boolean placingBlock = true;
    byte[] sideConfig = new byte[]{0, 0, 0, 0, 0, 0};
    public LiquidTankAdv myTank = new LiquidTankAdv(8000);
    public boolean mode;
    public int lastDisplayLevel = 0;
    private static int descPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileTankPortable.class, (String)"cofh.thermalexpansion.PortableTank", (String[])new String[]{"thermalexpansion.factory.PortableTank"});
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(1, 0, 3, 0, 0);
        payload.boolPayload[0] = this.mode;
        if (this.myTank.getLiquidID() > 0) {
            payload.intPayload[0] = this.myTank.getLiquidID();
            payload.intPayload[1] = this.myTank.getLiquidMeta();
            payload.intPayload[2] = this.myTank.getLiquidAmount();
        } else {
            payload.intPayload[0] = 0;
            payload.intPayload[1] = 0;
            payload.intPayload[2] = 0;
        }
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        this.mode = packet.payload.boolPayload[0];
        if (packet.payload.intPayload[0] != 0) {
            this.myTank.setLiquid(new LiquidStack(packet.payload.intPayload[0], packet.payload.intPayload[2], packet.payload.intPayload[1]));
        } else {
            this.myTank.setLiquid(new LiquidStack(0, 0));
        }
        if (LiquidRegistry.getLiquidLightLevel((LiquidStack)this.myTank.getLiquidNoCopy()) != 0) {
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void updateRender() {
        int curDisplayLevel = 0;
        if (this.myTank.getLiquidID() > 0) {
            curDisplayLevel = (int)((float)this.myTank.getLiquidAmount() / 8000.0f * 99.0f);
            if (curDisplayLevel == 0) {
                curDisplayLevel = 1;
            }
        } else if (this.lastDisplayLevel != 0) {
            this.lastDisplayLevel = 0;
            this.sendUpdatePacket(Side.CLIENT);
        }
        if (curDisplayLevel <= this.lastDisplayLevel - 4) {
            this.lastDisplayLevel = curDisplayLevel;
            this.sendUpdatePacket(Side.CLIENT);
        } else if (curDisplayLevel >= this.lastDisplayLevel + 4) {
            this.lastDisplayLevel = curDisplayLevel;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public LiquidStack getTankLiquid() {
        return this.myTank.getLiquidNoCopy();
    }

    public void changeMode(EntityPlayer player) {
        this.mode = !this.mode;
        this.sendUpdatePacket(Side.CLIENT);
    }

    @Override
    public void onNeighborBlockChange() {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)0);
        TileEntity theTile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        this.sideConfig[0] = theTile instanceof TileTankPortable ? (byte)1 : 0;
        coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)1);
        theTile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        this.sideConfig[1] = theTile instanceof TileTankPortable ? (byte)1 : 0;
    }

    public void placeBlock() {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)0);
        TileEntity theTile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (theTile instanceof TileTankPortable) {
            this.mode = true;
            this.sideConfig[0] = 1;
        } else {
            this.sideConfig[0] = 0;
        }
        coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)1);
        theTile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        this.sideConfig[1] = theTile instanceof TileTankPortable ? (byte)1 : 0;
    }

    public void func_70316_g() {
        if (!this.placingBlock) {
            this.sendUpdatePacket(Side.CLIENT);
            this.placingBlock = true;
        }
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.mode) {
            this.transferLiquid();
        }
        if (this.field_70331_k.func_72820_D() % 4L == 0L) {
            this.updateRender();
        }
        super.func_70316_g();
    }

    protected void transferLiquid() {
        if (this.myTank.getLiquidAmount() <= 0) {
            return;
        }
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)0);
        if (this.sideConfig[0] == 1) {
            TileTankPortable theTile = (TileTankPortable)this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            if (theTile.myTank.getLiquidID() <= 0 || theTile.myTank.getLiquidAmount() != 8000) {
                int fillQty = MathHelper.minI((int)this.myTank.getLiquidAmount(), (int)1000);
                int quantity = theTile.fill(ForgeDirection.UP, new LiquidStack(this.myTank.getLiquidID(), fillQty, this.myTank.getLiquidMeta()), true);
                if (quantity > 0) {
                    this.myTank.drain(quantity, true);
                }
            }
        } else {
            TileEntity theTile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            if (theTile instanceof ITankContainer) {
                int fillQty = MathHelper.minI((int)this.myTank.getLiquidAmount(), (int)LiquidRegistry.getLiquidViscosity((LiquidStack)this.myTank.getLiquidNoCopy()));
                int quantity = ((ITankContainer)theTile).fill(ForgeDirection.UP, new LiquidStack(this.myTank.getLiquidID(), fillQty, this.myTank.getLiquidMeta()), true);
                if (quantity > 0) {
                    this.myTank.drain(quantity, true);
                }
            }
        }
        if (this.myTank.getLiquidAmount() <= 0) {
            this.updateRender();
        }
    }

    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.placingBlock = false;
        this.mode = data.func_74767_n("process.mode");
        this.sideConfig = data.func_74770_j("side.array");
        if (this.sideConfig.length == 0) {
            this.sideConfig = new byte[]{0, 0, 0, 0, 0, 0};
        }
        if (data.func_74764_b("tank")) {
            this.myTank.setLiquid(LiquidStack.loadLiquidStackFromNBT((NBTTagCompound)data.func_74775_l("tank")));
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74757_a("process.mode", this.mode);
        data.func_74773_a("side.array", this.sideConfig);
        if (this.myTank.getLiquidID() > 0) {
            data.func_74782_a("tank", (NBTBase)this.myTank.getLiquidNoCopy().writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public int getLightValue() {
        if (this.myTank.getLiquidID() <= 0) {
            return 0;
        }
        int liquidLightLevel = LiquidRegistry.getLiquidLightLevel((LiquidStack)this.myTank.getLiquidNoCopy());
        if (this.myTank.getLiquidAmount() <= 2000) {
            return liquidLightLevel >> 1;
        }
        if (this.myTank.getLiquidAmount() >= 6000) {
            return liquidLightLevel;
        }
        return (liquidLightLevel >> 1) + (liquidLightLevel - (liquidLightLevel >> 1)) * (this.myTank.getLiquidAmount() - 2000) / 4000;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (from.ordinal() == 0 && this.mode && this.sideConfig[0] != 1) {
            return 0;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return 0;
        }
        if (this.myTank.getLiquidID() > 0 && !this.myTank.getLiquidNoCopy().isLiquidEqual(resource)) {
            return 0;
        }
        int theAmount = this.myTank.fill(resource, doFill);
        if (from.ordinal() != 1 && this.sideConfig[1] == 1 && theAmount == 0) {
            int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)1);
            TileTankPortable theTile = (TileTankPortable)this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            return theTile.fill(ForgeDirection.DOWN, resource, doFill);
        }
        if (from.ordinal() != 1 && this.sideConfig[1] == 1 && theAmount != resource.amount) {
            int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)1);
            TileTankPortable theTile = (TileTankPortable)this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
            LiquidStack remaining = resource.copy();
            remaining.amount -= theAmount;
            return theAmount + theTile.fill(ForgeDirection.DOWN, remaining, doFill);
        }
        return theAmount;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (from.ordinal() == 0 && this.mode && this.sideConfig[0] != 1) {
            return null;
        }
        if (from.ordinal() > 1 && from.ordinal() < 6) {
            return null;
        }
        LiquidStack theLiquid = this.myTank.drain(maxDrain, doDrain);
        return theLiquid;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (direction.ordinal() > 1) {
            return new ILiquidTank[0];
        }
        return new ILiquidTank[]{this.myTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (direction.ordinal() > 1) {
            return null;
        }
        return this.myTank;
    }
}

