/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.block.TileRSControl;
import thermalexpansion.util.Utils;
import thermalexpansion.util.energy.PowerProviderAdv;

public class TileEnergyCell
extends TileRSControl
implements ITilePacketHandler,
IPowerReceptor {
    public static final int MAX_SEND = 100;
    public static final int MAX_RECEIVE = 100;
    public static final int DEFAULT_SEND = 50;
    public static final int DEFAULT_RECEIVE = 100;
    public static final int STORAGE = 600000;
    PowerProviderAdv myProvider = new PowerProviderAdv();
    public int energyReceive = 100;
    public int energySend = 50;
    int energyTracker;
    int outputTracker;
    private static int guiId = ThermalExpansion.proxy.registerGui("EnergyCell", true);
    private static int descPacketId = PacketHandler.getAvailablePacketId();
    private static int guiPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileEnergyCell.class, (String)"cofh.thermalexpansion.EnergyCell", (String[])new String[]{"thermalexpansion.energy.EnergyStorage"});
    }

    public TileEnergyCell() {
        this.myProvider.configure(100, 600000);
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(2, 0, 2, 1, 0);
        payload.boolPayload[0] = this.redstoneDisable;
        payload.boolPayload[1] = this.redstoneState;
        payload.intPayload[0] = this.energySend;
        payload.intPayload[1] = this.energyReceive;
        payload.floatPayload[0] = this.myProvider.getEnergyStored();
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public Packet getGuiPacket() {
        Payload payload = new Payload(2, 0, 2, 1, 0);
        payload.boolPayload[0] = this.redstoneDisable;
        payload.boolPayload[1] = this.redstoneState;
        payload.intPayload[0] = this.energySend;
        payload.intPayload[1] = this.energyReceive;
        payload.floatPayload[0] = this.myProvider.getEnergyStored();
        PacketTile packet = new PacketTile(guiPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void handleTilePacket(PacketTile packet) {
        if (packet.getPacketId() == descPacketId) {
            this.redstoneDisable = packet.payload.boolPayload[0];
            this.redstoneState = packet.payload.boolPayload[1];
            this.energySend = packet.payload.intPayload[0];
            this.energyReceive = packet.payload.intPayload[1];
            this.myProvider.setEnergyStored(packet.payload.floatPayload[0]);
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        } else if (packet.getPacketId() == guiPacketId) {
            this.redstoneDisable = packet.payload.boolPayload[0];
            this.redstoneState = packet.payload.boolPayload[1];
            this.energySend = packet.payload.intPayload[0];
            this.energyReceive = packet.payload.intPayload[1];
            if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
                this.myProvider.setEnergyStored(packet.payload.floatPayload[0]);
            }
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void func_70316_g() {
        int energyStage;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.redstoneControlOrDisable()) {
            int i;
            for (i = this.outputTracker; i < 6 && this.myProvider.getEnergyStored() > 0.0f; ++i) {
                this.transferEnergy(i);
            }
            for (i = 0; i < this.outputTracker && this.myProvider.getEnergyStored() > 0.0f; ++i) {
                this.transferEnergy(i);
            }
            ++this.outputTracker;
            this.outputTracker %= 6;
        }
        if (this.energyTracker != (energyStage = MathHelper.minI((int)10, (int)this.getScaledEnergyStored(11)))) {
            this.energyTracker = energyStage;
            this.sendUpdatePacket(Side.CLIENT);
        }
    }

    public void setEnergyStored(int quantity) {
        this.myProvider.setEnergyStored(quantity);
    }

    public void setEnergyConfig() {
        PacketUtils.sendToServer((Packet)this.getGuiPacket());
    }

    protected void transferEnergy(int side) {
        int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side);
        TileEntity tile = this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
        if (!(tile instanceof TileEnergyCell) && Utils.isPoweredTile(tile)) {
            ForgeDirection sideFD = ForgeDirection.VALID_DIRECTIONS[side].getOpposite();
            IPowerProvider tilePP = ((IPowerReceptor)tile).getPowerProvider();
            float powerRequested = ((IPowerReceptor)tile).powerRequest(sideFD);
            if (powerRequested > 0.0f) {
                float adjustedEnergyRequest = MathHelper.minF((float)powerRequested, (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()));
                float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)this.energySend);
                float energy = this.myProvider.useEnergy(0.0f, energyMax, true);
                tilePP.receiveEnergy(energy, sideFD);
            }
        }
    }

    public void receiveGuiNetworkData(int i, int j) {
    }

    public void sendGuiNetworkData(Container container, ICrafting iCrafting) {
        if (iCrafting instanceof EntityPlayer && CoreUtils.isServerWorld((World)this.field_70331_k)) {
            PacketUtils.sendToPlayer((EntityPlayer)((EntityPlayer)iCrafting), (Packet)this.getGuiPacket());
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.myProvider.setEnergyStored(data.func_74760_g("energy.stored"));
            if (Float.isNaN(this.myProvider.getEnergyStored())) {
                this.myProvider.setEnergyStored(0.0f);
            }
        }
        catch (Exception e) {
            this.myProvider.setEnergyStored(0.0f);
        }
        this.energySend = data.func_74762_e("energy.send");
        this.energyReceive = data.func_74762_e("energy.receive");
        if (this.energySend > 100) {
            this.energySend = 100;
        }
        if (this.energyReceive > 100) {
            this.energyReceive = 100;
        }
        this.outputTracker = data.func_74762_e("output");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74776_a("energy.stored", this.myProvider.getEnergyStored());
        data.func_74768_a("energy.send", this.energySend);
        data.func_74768_a("energy.receive", this.energyReceive);
        data.func_74768_a("output", this.outputTracker);
    }

    public int getScaledEnergyStored(int scale) {
        return (int)(this.myProvider.getEnergyStored() * (float)scale / (float)this.myProvider.getMaxEnergyStored());
    }

    public float getEnergy() {
        return this.myProvider.getEnergyStored();
    }

    public float getMaxEnergy() {
        return this.myProvider.getMaxEnergyStored();
    }

    @Override
    public int getLightValue() {
        return MathHelper.minI((int)10, (int)this.getScaledEnergyStored(11));
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        player.openGui((Object)ThermalExpansion.instance, guiId, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public PowerProvider getPowerProvider() {
        return this.myProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.myProvider.getEnergyStored() == (float)this.myProvider.getMaxEnergyStored()) {
            return 0;
        }
        return MathHelper.ceil((double)MathHelper.minF((float)this.energyReceive, (float)((float)this.myProvider.getMaxEnergyStored() - this.myProvider.getEnergyStored())));
    }
}

