/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thermalexpansion.api.item.IChargeableItem;
import thermalexpansion.block.device.BlockEnergyCell;
import thermalexpansion.block.device.TileEnergyCell;

public class ItemBlockEnergyCell
extends ItemBlock
implements IChargeableItem {
    public ItemBlockEnergyCell(int i) {
        super(i);
        this.func_77656_e(1);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public String func_77628_j(ItemStack itemstack) {
        return CoreUtils.localize((String)this.func_77667_c(itemstack));
    }

    public String func_77667_c(ItemStack itemstack) {
        return "device.energyCell";
    }

    public int func_77647_b(int i) {
        return 0;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.uncommon;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean check) {
        int energy = 0;
        int send = 0;
        int receive = 0;
        boolean redDisable = false;
        boolean redState = false;
        if (stack.field_77990_d == null) {
            BlockEnergyCell.setDefaultTag(stack, 0);
        }
        energy = (int)stack.field_77990_d.func_74760_g("energy.stored");
        send = stack.field_77990_d.func_74762_e("energy.send");
        receive = stack.field_77990_d.func_74762_e("energy.receive");
        redDisable = stack.field_77990_d.func_74767_n("red.disable");
        redState = stack.field_77990_d.func_74767_n("red.state");
        list.add("Charge: " + energy + " MJ");
        list.add("Send/Receive: " + send + "/" + receive);
        if (redDisable) {
            list.add("Signal: Disabled");
        } else if (!redState) {
            list.add("Signal: Enabled, Low");
        } else {
            list.add("Signal: Enabled, High");
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!world.func_72832_d(x, y, z, this.func_77883_f(), 0, 3)) {
            return false;
        }
        if (world.func_72798_a(x, y, z) == this.func_77883_f()) {
            Block.field_71973_m[this.func_77883_f()].func_71860_a(world, x, y, z, (EntityLiving)player, stack);
            if (stack.field_77990_d != null) {
                TileEnergyCell theTile = (TileEnergyCell)world.func_72796_p(x, y, z);
                theTile.setEnergyStored((int)stack.field_77990_d.func_74760_g("energy.stored"));
                theTile.energySend = stack.field_77990_d.func_74762_e("energy.send");
                theTile.energyReceive = stack.field_77990_d.func_74762_e("energy.receive");
                theTile.setRedstoneDisable(stack.field_77990_d.func_74767_n("red.disable"));
                theTile.setRedstoneState(stack.field_77990_d.func_74767_n("red.state"));
            }
        }
        return true;
    }

    public int getItemDamageFromStackForDisplay(ItemStack stack) {
        if (stack.field_77990_d == null) {
            return 600001;
        }
        return (int)(600001.0f - stack.field_77990_d.func_74760_g("energy.stored"));
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        return 600001;
    }

    public boolean isItemStackDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public float receiveEnergy(ItemStack theItem, float energy, boolean doReceive) {
        if (theItem.field_77990_d == null) {
            BlockEnergyCell.setDefaultTag(theItem, 0);
        }
        float stored = theItem.field_77990_d.func_74760_g("energy.stored");
        float receive = MathHelper.minF((float)energy, (float)MathHelper.minF((float)(600000.0f - stored), (float)500.0f));
        if (doReceive) {
            theItem.field_77990_d.func_74776_a("energy.stored", stored += receive);
        }
        return receive;
    }

    @Override
    public float transferEnergy(ItemStack theItem, float energy, boolean doTransfer) {
        if (theItem.field_77990_d == null) {
            BlockEnergyCell.setDefaultTag(theItem, 0);
        }
        float stored = theItem.field_77990_d.func_74760_g("energy.stored");
        float transfer = MathHelper.minF((float)energy, (float)MathHelper.minF((float)stored, (float)500.0f));
        if (doTransfer) {
            theItem.field_77990_d.func_74776_a("energy.stored", stored -= transfer);
        }
        return transfer;
    }

    @Override
    public float getEnergyStored(ItemStack theItem) {
        if (theItem.field_77990_d == null) {
            BlockEnergyCell.setDefaultTag(theItem, 0);
        }
        return theItem.field_77990_d.func_74760_g("energy.stored");
    }

    @Override
    public float getMaxEnergyStored(ItemStack theItem) {
        return 600000.0f;
    }
}

