/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.device;

import buildcraft.api.tools.IToolWrench;
import cofh.util.CoreUtils;
import cofh.util.IInitializer;
import cofh.util.ItemUtils;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.BlockTERoot;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.device.TileTankPortable;
import thermalexpansion.util.Utils;

public class BlockTank
extends BlockTERoot
implements IInitializer {
    public static boolean enable;
    public static ItemStack portableTank;

    public BlockTank(int id) {
        super(id, Material.field_76264_q);
        this.func_71905_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
        this.func_71848_c(3.0f);
        this.func_71894_b(150.0f);
        this.func_71884_a(field_71974_j);
        this.func_71864_b("thermalexpansion.tank");
    }

    public TileEntity createTileEntity(World world, int metadata) {
        return new TileTankPortable();
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        if (enable) {
            list.add(new ItemStack(itemId, 1, 0));
        }
    }

    @Override
    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (CoreUtils.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        TileTankPortable theTile = (TileTankPortable)world.func_72796_p(x, y, z);
        if (Utils.fillTankWithContainer(theTile, player)) {
            return true;
        }
        if (Utils.emptyTankIntoContainer(theTile, player, theTile.myTank.getLiquidNoCopy())) {
            return true;
        }
        if (ItemUtils.isHoldingContainer((EntityPlayer)player)) {
            return true;
        }
        if (Utils.isHoldingUsableWrench(player, x, y, z)) {
            if (CoreUtils.isServerWorld((World)world)) {
                theTile = (TileTankPortable)world.func_72796_p(x, y, z);
                theTile.changeMode(player);
                ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_71861_g(World world, int i, int j, int k) {
        TileTankPortable theTile = new TileTankPortable();
        world.func_72837_a(i, j, k, (TileEntity)theTile);
        TileTankPortable tile = (TileTankPortable)world.func_72796_p(i, j, k);
        tile.placeBlock();
    }

    public int func_71857_b() {
        return -1;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @Override
    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        TileTankPortable theTile = (TileTankPortable)world.func_72796_p(x, y, z);
        NBTTagCompound tag = null;
        if (theTile != null && theTile.myTank.getLiquidID() > 0) {
            tag = new NBTTagCompound();
            LiquidStack myLiquid = theTile.myTank.getLiquidNoCopy();
            tag.func_74768_a("liquid.itemID", myLiquid.itemID);
            tag.func_74768_a("liquid.amount", myLiquid.amount);
            tag.func_74768_a("liquid.itemMeta", myLiquid.itemMeta);
        }
        return super.dismantleBlock(player, tag, world, x, y, z, returnBlock);
    }

    @Override
    public boolean canDismantle(EntityPlayer player, World world, int i, int j, int k) {
        return true;
    }

    public void initialize() {
        TileTankPortable.initialize();
        portableTank = new ItemStack(TEBlocks.blockTank, 1, 0);
        ItemRegistry.registerItem("portableTank", portableTank);
    }

    public void loadRecipes() {
        if (enable) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(TEBlocks.blockTank, new Object[]{" G ", "GTG", " G ", Character.valueOf('G'), TEBlocks.blockGlass, Character.valueOf('T'), "ingotTin"}));
        }
    }

    static {
        String category = "block.feature";
        enable = ThermalExpansion.config.get(category, "Tank.Portable", true);
    }
}

