/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import cofh.api.tileentity.ITileInfo;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cofh.util.liquid.LiquidRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.GridLiquid;
import thermalexpansion.block.conduit.TileConduitRoot;

public class TileConduitLiquid
extends TileConduitRoot
implements ITilePacketHandler,
ITankContainer,
ITileInfo {
    public boolean isNode = false;
    public GridLiquid myGrid;
    public int liquidID = 0;
    public int liquidMeta = 0;
    public int liquidLevel = 0;
    public int liquidAmount = 0;
    public int lastWriteStorage = 0;
    LiquidStack renderLiquid = new LiquidStack(0, 0, 0);
    public static int updateDelay = 4;
    private static int descPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileConduitLiquid.class, (String)"cofh.thermalexpansion.ConduitLiquid", (String[])new String[]{"thermalexpansion.transport.ConduitLiquid"});
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(0, 7, 3, 0, 0);
        payload.bytePayload[0] = this.mode;
        System.arraycopy(this.sideCache, 0, payload.bytePayload, 1, this.sideCache.length);
        payload.intPayload[0] = this.liquidID;
        payload.intPayload[1] = this.liquidMeta;
        payload.intPayload[2] = this.liquidLevel;
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void sendDescPacket() {
        PacketUtils.sendToPlayers((Packet)this.func_70319_e(), (TileEntity)this);
    }

    public void handleTilePacket(PacketTile packet) {
        this.mode = packet.payload.bytePayload[0];
        System.arraycopy(packet.payload.bytePayload, 1, this.sideCache, 0, this.sideCache.length);
        LiquidStack prevRenderLiquid = this.renderLiquid.copy();
        this.renderLiquid = new LiquidStack(packet.payload.intPayload[0], 1, packet.payload.intPayload[1]);
        this.liquidLevel = packet.payload.intPayload[2];
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        if (LiquidRegistry.getLiquidLightLevel((LiquidStack)this.renderLiquid) != 0 || this.liquidLevel == 0) {
            this.field_70331_k.func_72969_x(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    @Override
    public int getLightValue() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return LiquidRegistry.getLiquidLightLevel((LiquidStack)this.renderLiquid);
        }
        if (this.myGrid != null) {
            return LiquidRegistry.getLiquidLightLevel((LiquidStack)this.myGrid.myTank.getLiquid());
        }
        return 0;
    }

    @Override
    public int getRenderId() {
        return BlockConduit.Types.LIQUID.ordinal();
    }

    @Override
    public LiquidStack getRenderLiquid() {
        return this.renderLiquid;
    }

    @Override
    public int getRenderLiquidLevel() {
        return this.liquidLevel;
    }

    @Override
    public void debugOutput() {
        if (this.myGrid != null) {
            System.out.println(this.isNode);
            System.out.println(this.myGrid.conduitCount);
            System.out.println(this.myGrid.getLiquidAmount());
            System.out.println(this.myGrid.myTank.getCapacity());
        }
    }

    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public void breakBlock() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.conduitInvalid = true;
        TileConduitLiquid[] allSides = this.getAdjacentConduits(-1);
        if (this.myGrid != null) {
            this.myGrid.destroy();
            if (this.isNode) {
                this.myGrid.removeNode(this);
            } else {
                this.myGrid.removeConduit(this);
            }
        } else {
            return;
        }
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].myGrid = null;
            allSides[i].sideCache[i ^ 1] = 0;
        }
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].updateGridIfNull();
        }
        this.needsGrid = true;
        this.myGrid = null;
    }

    @Override
    public void onBlockAdded() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkIfNode();
        TileConduitLiquid[] allSides = this.getAdjacentConduits(-1);
        boolean hasAdjacent = false;
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            hasAdjacent = true;
            break;
        }
        if (hasAdjacent) {
            for (i = 0; i < 6; ++i) {
                if (allSides[i] == null || allSides[i].myGrid == null) continue;
                if (this.needsGrid) {
                    this.myGrid = allSides[i].myGrid;
                    if (!this.isNode) {
                        this.myGrid.addConduit(this);
                    } else {
                        this.myGrid.addNode(this);
                    }
                    this.needsGrid = false;
                    continue;
                }
                if (this.conduitInvalid && !this.canConnectTo(allSides[i])) {
                    allSides[i] = null;
                    continue;
                }
                if (allSides[i].myGrid.contains(this)) continue;
                allSides[i].myGrid.setNewGrid(this.myGrid);
            }
        } else {
            this.myGrid = new GridLiquid(this.field_70331_k);
            if (!this.isNode) {
                this.myGrid.addConduit(this);
            } else {
                this.myGrid.addNode(this);
            }
            this.needsGrid = false;
        }
        this.placingBlock = false;
    }

    @Override
    public void changeMode(EntityPlayer player) {
        if (this.isNode) {
            this.mode = (byte)(this.mode + 1);
            this.mode = (byte)(this.mode % 2);
            this.myGrid.changeMode(this);
            this.checkConnections();
            this.sendDescPacket();
        }
    }

    @Override
    public boolean wrenchAction(EntityPlayer player, int side) {
        int[] coords;
        TileEntity theTile;
        if (this.myGrid == null) {
            return false;
        }
        if (this.sideCache[side] == 0 && (theTile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof TileConduitLiquid) {
            TileConduitLiquid theCond = (TileConduitLiquid)theTile;
            if (this.liquidID == theCond.liquidID || theCond.liquidID == 0) {
                this.sideCache[side] = 1;
                this.sendDescPacket();
                theCond.sideCache[BlockUtils.SIDE_OPPOSITE[side]] = 1;
                theCond.myGrid.setNewGrid(this.myGrid);
                theCond.sendDescPacket();
                return true;
            }
            if (this.liquidID == 0 && theCond.liquidID != 0 && theCond.myGrid != null) {
                theCond.sideCache[BlockUtils.SIDE_OPPOSITE[side]] = 1;
                theCond.sendDescPacket();
                this.sideCache[side] = 1;
                this.myGrid.setNewGrid(theCond.myGrid);
                this.sendDescPacket();
            }
        }
        return false;
    }

    @Override
    public void checkConnections() {
        TileEntity[] theReceptors = this.getAdjacentTankContainers(-1);
        for (int i = 0; i < 6; ++i) {
            if (theReceptors[i] == null) {
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof TileConduitLiquid) {
                if (this.canConnectTo((TileConduitLiquid)theReceptors[i])) {
                    this.sideCache[i] = 1;
                    continue;
                }
                this.sideCache[i] = 0;
                continue;
            }
            this.sideCache[i] = 2;
        }
    }

    @Override
    public void onNeighborBlockChange() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkIfNode();
        this.sendDescPacket();
    }

    public boolean canConnectTo(TileConduitLiquid theCond) {
        if (this.myGrid != null && theCond.myGrid != null) {
            return this.myGrid == theCond.myGrid;
        }
        return this.liquidID == theCond.liquidID;
    }

    @Override
    public boolean canTransfer() {
        return this.mode == 0;
    }

    public void onChunkUnload() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.myGrid != null) {
            this.myGrid.unloadConduit(this);
        }
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.needsGrid && !this.placingBlock) {
            this.updateGridIfNull();
        }
        if (this.isNode && this.myGrid != null) {
            this.myGrid.transferLiquid(this);
        }
        if (this.myGrid != null && this.field_70331_k.func_72820_D() % (long)updateDelay == 0L) {
            this.myGrid.updateRender(this);
            if (this.myGrid.liquidLevel != this.liquidLevel || this.myGrid.liquidID != this.liquidID || this.myGrid.liquidMeta != this.liquidMeta) {
                this.liquidID = this.myGrid.liquidID;
                this.liquidMeta = this.myGrid.liquidMeta;
                this.liquidLevel = this.myGrid.liquidLevel;
                this.sendDescPacket();
            }
        }
    }

    public void updateConnections() {
        boolean sendUpdate = false;
        for (int i = 0; i < 6; ++i) {
            int[] coords;
            TileEntity theTile;
            if (this.sideCache[i] != 0 || !((theTile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i))[0], coords[1], coords[2])) instanceof TileConduitLiquid)) continue;
            TileConduitLiquid theCond = (TileConduitLiquid)theTile;
            if (this.myGrid != theCond.myGrid) continue;
            this.sideCache[i] = 1;
            sendUpdate = true;
            theCond.sideCache[BlockUtils.SIDE_OPPOSITE[i]] = 1;
            theCond.sendDescPacket();
        }
        if (sendUpdate) {
            this.sendDescPacket();
        }
    }

    public void updateGrid(int from, GridLiquid theGrid) {
        this.needsGrid = false;
        if (this.myGrid != null) {
            if (this.isNode) {
                this.myGrid.removeNode(this);
            } else {
                this.myGrid.removeConduit(this);
            }
        }
        this.myGrid = theGrid;
        if (this.isNode) {
            this.myGrid.addNode(this);
        } else {
            this.myGrid.addConduit(this);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] == 1) {
                int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i);
                TileConduitLiquid curCon = (TileConduitLiquid)this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
                if (curCon == null || curCon.conduitInvalid || theGrid.contains(curCon)) continue;
                curCon.updateGrid(BlockUtils.SIDE_OPPOSITE[i], theGrid);
                continue;
            }
            if (this.sideCache[i] != 2 || this.isNode) continue;
            this.myGrid.removeConduit(this);
            this.isNode = true;
            this.myGrid.addNode(this);
        }
    }

    public void updateGridIfNull() {
        if (this.myGrid == null) {
            GridLiquid newGrid = new GridLiquid(this.field_70331_k);
            newGrid.liquidID = this.liquidID;
            newGrid.liquidMeta = this.liquidMeta;
            newGrid.liquidLevel = this.liquidLevel;
            this.updateGrid(-1, newGrid);
        }
    }

    public TileEntity[] getAdjacentTankContainers(int lastSide) {
        TileEntity[] ret = new TileEntity[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide) continue;
            curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2]);
            if (curTile instanceof TileConduitLiquid) {
                if (!this.canConnectTo((TileConduitLiquid)curTile)) continue;
                ret[i] = curTile;
                continue;
            }
            if (!(curTile instanceof ITankContainer) || ((ITankContainer)curTile).getTanks(ForgeDirection.VALID_DIRECTIONS[i]) == null || ((ITankContainer)curTile).getTanks(ForgeDirection.VALID_DIRECTIONS[i].getOpposite()).length <= 0) continue;
            ret[i] = curTile;
        }
        return ret;
    }

    public TileConduitLiquid[] getAdjacentConduits(int lastSide) {
        TileConduitLiquid[] ret = new TileConduitLiquid[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide || !((curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2])) instanceof TileConduitLiquid) || !this.canConnectTo((TileConduitLiquid)curTile)) continue;
            ret[i] = (TileConduitLiquid)curTile;
        }
        return ret;
    }

    public void checkIfNode() {
        boolean noneFound = true;
        TileEntity[] theReceptors = this.getAdjacentTankContainers(-1);
        for (int i = 0; i < 6; ++i) {
            if (theReceptors[i] == null) {
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof TileConduitLiquid) {
                this.sideCache[i] = 1;
                continue;
            }
            this.sideCache[i] = 2;
            this.isNode = true;
            noneFound = false;
            if (this.myGrid == null) continue;
            this.myGrid.removeConduit(this);
            this.myGrid.addNode(this);
        }
        if (noneFound) {
            this.isNode = false;
            if (this.myGrid != null) {
                this.myGrid.removeNode(this);
                this.myGrid.addConduit(this);
            }
        }
    }

    public int transferLiquid(int side, int availableLiquid) {
        int[] coords;
        TileEntity tile;
        if (this.sideCache[side] == 2 && (tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof ITankContainer) {
            ITankContainer tankTile = (ITankContainer)tile;
            LiquidStack tempLiquid = this.myGrid.myTank.getLiquid().copy();
            tempLiquid.amount = availableLiquid;
            int amountSent = tankTile.fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), tempLiquid, false);
            if (amountSent > 0) {
                return tankTile.fill(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), this.myGrid.myTank.drain(amountSent, true), true);
            }
        }
        return 0;
    }

    public void extractLiquid(int side) {
        int[] coords;
        TileEntity tile;
        if (!this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            return;
        }
        if (this.sideCache[side] == 2 && (tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2])) instanceof ITankContainer) {
            ITankContainer tankTile = (ITankContainer)tile;
            int maxInput = MathHelper.minI((int)(this.myGrid.myTank.getCapacity() - this.myGrid.getLiquidAmount()), (int)this.myGrid.liquidThroughput);
            LiquidStack returned = tankTile.drain(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), maxInput, false);
            if (returned != null && returned.itemID != 0) {
                if (this.myGrid.myTank.getLiquid() == null) {
                    this.myGrid.myTank.setLiquid(tankTile.drain(ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), maxInput, true).copy());
                } else if (this.myGrid.myTank.getLiquid().isLiquidEqual(returned)) {
                    this.myGrid.myTank.getLiquid().amount += tankTile.drain((ForgeDirection)ForgeDirection.VALID_DIRECTIONS[side].getOpposite(), (int)maxInput, (boolean)true).copy().amount;
                }
            }
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.liquidAmount = data.func_74762_e("liquid.amount");
        this.liquidID = data.func_74762_e("liquid.ID");
        this.liquidMeta = data.func_74762_e("liquid.meta");
        if (this.liquidID < 4096 && Block.field_71973_m[this.liquidID] == null || Item.field_77698_e[this.liquidID] == null) {
            this.liquidAmount = 0;
            this.liquidID = 0;
            this.liquidMeta = 0;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.myGrid != null) {
            if (this.myGrid.myTank.getLiquid() != null) {
                this.lastWriteStorage = this.myGrid.getSharedAmount(this);
                data.func_74768_a("liquid.amount", this.lastWriteStorage);
                data.func_74768_a("liquid.ID", this.myGrid.myTank.getLiquid().itemID);
                data.func_74768_a("liquid.meta", this.myGrid.myTank.getLiquid().itemMeta);
            } else {
                data.func_74768_a("liquid.amount", 0);
                data.func_74768_a("liquid.ID", 0);
                data.func_74768_a("liquid.meta", 0);
            }
        } else {
            data.func_74768_a("liquid.amount", 0);
            data.func_74768_a("liquid.ID", 0);
            data.func_74768_a("liquid.meta", 0);
        }
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.myGrid != null && this.mode != 1 && resource.amount > 0) {
            return this.myGrid.myTank.fill(resource, doFill);
        }
        return 0;
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (this.myGrid != null && this.mode != 1 && resource.amount > 0) {
            return this.myGrid.myTank.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.myGrid != null) {
            return this.myGrid.myTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.myGrid != null) {
            return this.myGrid.myTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        if (this.myGrid != null && direction != ForgeDirection.UNKNOWN && this.sideCache[direction.ordinal()] == 2) {
            return new ILiquidTank[]{this.myGrid.myTank};
        }
        return new ILiquidTank[0];
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (this.myGrid != null) {
            return this.myGrid.myTank;
        }
        return null;
    }

    public List getTileInfo() {
        LinkedList<String> toReturn = new LinkedList<String>();
        if (this.myGrid.myTank.getLiquid() == null) {
            toReturn.add("Liquid: Empty");
            return toReturn;
        }
        toReturn.add("Liquid: " + this.myGrid.myTank.getLiquid().asItemStack().func_82833_r());
        toReturn.add("Amount: " + this.myGrid.getLiquidAmount() + "/" + this.myGrid.myTank.getCapacity() + " mB");
        toReturn.add("Throughput: " + this.myGrid.getLiquidThroughput() + "mB/t");
        return toReturn;
    }

    public void sendTileInfoToPlayer(EntityPlayer thePlayer) {
        List tileInfo = this.getTileInfo();
        for (int i = 0; i < tileInfo.size(); ++i) {
            thePlayer.func_70006_a((String)tileInfo.get(i));
        }
    }
}

