/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.transport.IPipeTile;
import cofh.api.tileentity.ITileInfo;
import cofh.network.ITilePacketHandler;
import cofh.network.PacketHandler;
import cofh.network.PacketTile;
import cofh.network.PacketUtils;
import cofh.network.Payload;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.MathHelper;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import thermalexpansion.block.conduit.BlockConduit;
import thermalexpansion.block.conduit.GridEnergy;
import thermalexpansion.block.conduit.TileConduitRoot;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.util.Utils;

public class TileConduitEnergy
extends TileConduitRoot
implements ITilePacketHandler,
IPowerReceptor,
ITileInfo {
    boolean isNode = false;
    public GridEnergy myGrid = null;
    public float tempEnergyStored = 0.0f;
    public float lastWriteAverage = 0.0f;
    public List energySent = null;
    public boolean trackEnergy = false;
    private static int descPacketId = PacketHandler.getAvailablePacketId();

    public static void initialize() {
        GameRegistry.registerTileEntityWithAlternatives(TileConduitEnergy.class, (String)"cofh.thermalexpansion.ConduitEnergy", (String[])new String[]{"thermalexpansion.transport.ConduitEnergy"});
    }

    public Packet func_70319_e() {
        Payload payload = new Payload(0, 7, 0, 0, 0);
        payload.bytePayload[0] = this.mode;
        System.arraycopy(this.sideCache, 0, payload.bytePayload, 1, this.sideCache.length);
        PacketTile packet = new PacketTile(descPacketId, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
        return packet.getPacket();
    }

    public void sendDescPacket() {
        PacketUtils.sendToPlayers((Packet)this.func_70319_e(), (TileEntity)this);
    }

    public void handleTilePacket(PacketTile packet) {
        this.mode = packet.payload.bytePayload[0];
        System.arraycopy(packet.payload.bytePayload, 1, this.sideCache, 0, this.sideCache.length);
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public int getLightValue() {
        return 7;
    }

    @Override
    public int getRenderId() {
        return BlockConduit.Types.ENERGY.ordinal();
    }

    @Override
    public LiquidStack getRenderLiquid() {
        return TELiquids.liquidRedstone;
    }

    @Override
    public int getRenderLiquidLevel() {
        return TileConduitRoot.LiquidRenderInfo.FULL.ordinal();
    }

    @Override
    public void debugOutput() {
        if (this.myGrid != null) {
            System.out.println(this.isNode);
            System.out.println(this.myGrid.nodeCount);
            System.out.println(this.myGrid.myProvider.getEnergyStored());
            System.out.println(this.myGrid.myProvider.getMaxEnergyStored());
        }
    }

    public boolean isNode() {
        return this.isNode;
    }

    @Override
    public void breakBlock() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.conduitInvalid = true;
        TileConduitEnergy[] allSides = this.getAdjacentConduits(-1);
        if (this.myGrid != null) {
            this.myGrid.destroy();
            if (this.isNode) {
                this.myGrid.removeNode(this);
            } else {
                this.myGrid.removeConduit(this);
            }
        } else {
            return;
        }
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].myGrid = null;
            allSides[i].sideCache[i ^ 1] = 0;
        }
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            allSides[i].updateGridIfNull();
        }
        this.needsGrid = true;
        this.myGrid = null;
    }

    @Override
    public void onBlockAdded() {
        int i;
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkIfNode();
        TileConduitEnergy[] allSides = this.getAdjacentConduits(-1);
        boolean hasAdjacent = false;
        for (i = 0; i < 6; ++i) {
            if (allSides[i] == null) continue;
            hasAdjacent = true;
            break;
        }
        if (hasAdjacent) {
            for (i = 0; i < 6; ++i) {
                if (allSides[i] == null || allSides[i].myGrid == null) continue;
                if (this.needsGrid) {
                    this.myGrid = allSides[i].myGrid;
                    if (!this.isNode) {
                        this.myGrid.addConduit(this);
                    } else {
                        this.myGrid.addNode(this);
                    }
                    this.needsGrid = false;
                    continue;
                }
                if (!this.canConnectTo(allSides[i])) {
                    allSides[i] = null;
                    continue;
                }
                if (allSides[i].myGrid.contains(this)) continue;
                allSides[i].myGrid.setNewGrid(this.myGrid);
            }
        } else {
            this.myGrid = new GridEnergy(this.field_70331_k);
            if (!this.isNode) {
                this.myGrid.addConduit(this);
            } else {
                this.myGrid.addNode(this);
            }
            this.needsGrid = false;
        }
        this.placingBlock = false;
    }

    @Override
    public void changeMode(EntityPlayer player) {
        if (this.isNode) {
            this.mode = (byte)(this.mode + 1);
            this.mode = (byte)(this.mode % 2);
            this.myGrid.changeMode(this);
            this.checkConnections();
            this.sendDescPacket();
        }
    }

    @Override
    public boolean wrenchAction(EntityPlayer player, int side) {
        return false;
    }

    @Override
    public void checkConnections() {
        TileEntity[] theReceptors = this.getAdjacentPoweredTiles(-1);
        for (int i = 0; i < 6; ++i) {
            if (theReceptors[i] == null) {
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof TileConduitEnergy) {
                if (this.canConnectTo((TileConduitEnergy)theReceptors[i])) {
                    this.sideCache[i] = 1;
                    continue;
                }
                this.sideCache[i] = 0;
                continue;
            }
            this.sideCache[i] = 2;
        }
    }

    @Override
    public void onNeighborBlockChange() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        this.checkIfNode();
        this.sendDescPacket();
    }

    public boolean canConnectTo(TileConduitEnergy theCond) {
        return true;
    }

    @Override
    public boolean canTransfer() {
        return this.mode == 0;
    }

    public void onChunkUnload() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.myGrid != null) {
            if (this.isNode) {
                this.myGrid.myProvider.subtractEnergy(this.lastWriteAverage);
                this.myGrid.removeNode(this);
            } else {
                this.myGrid.removeConduit(this);
            }
        }
    }

    public void func_70316_g() {
        if (CoreUtils.isClientWorld((World)this.field_70331_k)) {
            return;
        }
        if (this.needsGrid && !this.placingBlock) {
            this.updateGridIfNull();
        }
        if (this.isNode && this.myGrid != null) {
            this.myGrid.transferEnergy(this);
        }
    }

    public void updateConnections() {
        boolean sendUpdate = false;
        for (int i = 0; i < 6; ++i) {
            int[] coords;
            TileEntity theTile;
            if (this.sideCache[i] != 0 || !((theTile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i))[0], coords[1], coords[2])) instanceof TileConduitEnergy)) continue;
            TileConduitEnergy theCond = (TileConduitEnergy)theTile;
            if (this.myGrid != theCond.myGrid) continue;
            this.sideCache[i] = 1;
            sendUpdate = true;
            theCond.sideCache[BlockUtils.SIDE_OPPOSITE[i]] = 1;
            theCond.sendDescPacket();
        }
        if (sendUpdate) {
            this.sendDescPacket();
        }
    }

    public void updateGrid(int from, GridEnergy theGrid) {
        this.needsGrid = false;
        if (this.myGrid != null) {
            if (this.isNode) {
                this.myGrid.removeNode(this);
            } else {
                this.myGrid.removeConduit(this);
            }
        }
        this.myGrid = theGrid;
        if (this.isNode) {
            this.myGrid.addNode(this);
        } else {
            this.myGrid.addConduit(this);
        }
        for (int i = 0; i < 6; ++i) {
            if (this.sideCache[i] == 1) {
                int[] coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)i);
                TileConduitEnergy curCon = (TileConduitEnergy)this.field_70331_k.func_72796_p(coords[0], coords[1], coords[2]);
                if (curCon == null || curCon.conduitInvalid || theGrid.contains(curCon)) continue;
                curCon.updateGrid(BlockUtils.SIDE_OPPOSITE[i], theGrid);
                continue;
            }
            if (this.sideCache[i] != 2 || this.isNode) continue;
            this.myGrid.removeConduit(this);
            this.isNode = true;
            this.myGrid.addNode(this);
        }
        this.conduitInvalid = false;
    }

    public void updateGridIfNull() {
        if (this.myGrid == null) {
            GridEnergy newGrid = new GridEnergy(this.field_70331_k);
            this.updateGrid(-1, newGrid);
        }
    }

    public TileEntity[] getAdjacentPoweredTiles(int lastSide) {
        TileEntity[] ret = new TileEntity[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide) continue;
            curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2]);
            if (curTile instanceof TileConduitEnergy) {
                if (!this.canConnectTo((TileConduitEnergy)curTile)) continue;
                ret[i] = curTile;
                continue;
            }
            if (!Utils.isPoweredTile(curTile) || curTile instanceof IPipeTile) continue;
            ret[i] = curTile;
        }
        return ret;
    }

    public TileConduitEnergy[] getAdjacentConduits(int lastSide) {
        TileConduitEnergy[] ret = new TileConduitEnergy[6];
        TileEntity curTile = null;
        for (int i = 0; i < 6; ++i) {
            if (i == lastSide || !((curTile = this.field_70331_k.func_72796_p(this.field_70329_l + BlockUtils.SIDE_COORD_MOD[i][0], this.field_70330_m + BlockUtils.SIDE_COORD_MOD[i][1], this.field_70327_n + BlockUtils.SIDE_COORD_MOD[i][2])) instanceof TileConduitEnergy) || !this.canConnectTo((TileConduitEnergy)curTile)) continue;
            ret[i] = (TileConduitEnergy)curTile;
        }
        return ret;
    }

    public void checkIfNode() {
        boolean noneFound = true;
        TileEntity[] theReceptors = this.getAdjacentPoweredTiles(-1);
        for (int i = 0; i < 6; ++i) {
            if (theReceptors[i] == null) {
                this.sideCache[i] = 0;
                continue;
            }
            if (theReceptors[i] instanceof TileConduitEnergy) {
                if (this.canConnectTo((TileConduitEnergy)theReceptors[i])) {
                    this.sideCache[i] = 1;
                    continue;
                }
                this.sideCache[i] = 0;
                continue;
            }
            this.sideCache[i] = 2;
            this.isNode = true;
            noneFound = false;
            if (this.myGrid == null) continue;
            this.myGrid.removeConduit(this);
            this.myGrid.addNode(this);
        }
        if (noneFound) {
            this.isNode = false;
            if (this.myGrid != null) {
                this.myGrid.removeNode(this);
                this.myGrid.addConduit(this);
            }
        }
    }

    protected float transferEnergy(int side, float availableEnergy) {
        int[] coords;
        TileEntity tile;
        if (this.sideCache[side] == 2 && Utils.isPoweredTile(tile = this.field_70331_k.func_72796_p((coords = BlockUtils.getAdjacentCoordinatesForSide((int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n, (int)side))[0], coords[1], coords[2]))) {
            ForgeDirection sideFD = ForgeDirection.VALID_DIRECTIONS[side].getOpposite();
            IPowerProvider tilePP = ((IPowerReceptor)tile).getPowerProvider();
            float powerRequested = ((IPowerReceptor)tile).powerRequest(sideFD);
            if (powerRequested > 0.0f) {
                float adjustedEnergyRequest = MathHelper.minF((float)powerRequested, (float)((float)tilePP.getMaxEnergyStored() - tilePP.getEnergyStored()));
                float energyMax = MathHelper.minF((float)adjustedEnergyRequest, (float)availableEnergy);
                float energy = this.myGrid.myProvider.useEnergy(0.0f, energyMax, true);
                tilePP.receiveEnergy(energy, sideFD);
                return energy;
            }
        }
        return 0.0f;
    }

    public float getAverageTransfer() {
        if (this.energySent.size() <= 0) {
            return 0.0f;
        }
        float total = 0.0f;
        for (int i = 0; i < this.energySent.size(); ++i) {
            total += ((Float)this.energySent.get(i)).floatValue();
        }
        return total / (float)this.energySent.size();
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        try {
            this.tempEnergyStored = data.func_74760_g("energy.stored");
            if (Float.isNaN(this.tempEnergyStored)) {
                this.tempEnergyStored = 0.0f;
            }
        }
        catch (Exception e) {
            this.tempEnergyStored = 0.0f;
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        if (this.isNode && this.myGrid != null) {
            this.lastWriteAverage = this.myGrid.getNodeEnergy();
            data.func_74776_a("energy.stored", this.lastWriteAverage);
        } else if (this.tempEnergyStored > 0.0f) {
            data.func_74776_a("energy.stored", this.tempEnergyStored);
        } else {
            this.lastWriteAverage = 0.0f;
            data.func_74776_a("energy.stored", 0.0f);
        }
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
    }

    @Override
    public IPowerProvider getPowerProvider() {
        if (CoreUtils.isServerWorld((World)this.field_70331_k) && this.myGrid != null) {
            return this.myGrid.myProvider;
        }
        return Utils.dummyProvider;
    }

    @Override
    public void doWork() {
    }

    @Override
    public int powerRequest(ForgeDirection from) {
        if (this.myGrid == null || this.mode == 0) {
            return 0;
        }
        return this.myGrid.myProvider.powerRequest();
    }

    public List getTileInfo() {
        LinkedList<String> toReturn = new LinkedList<String>();
        if (this.isNode && this.mode == 0) {
            if (this.energySent != null) {
                toReturn.add("Average Distribution (" + this.energySent.size() + " ticks): " + this.getAverageTransfer());
                this.trackEnergy = false;
                this.energySent = null;
            } else {
                this.energySent = new LinkedList();
                this.trackEnergy = true;
                toReturn.add("Monitoring for 20 ticks...");
            }
        } else {
            IPowerProvider tilePP = this.getPowerProvider();
            float saturation = 100.0f * tilePP.getEnergyStored() / (float)tilePP.getMaxEnergyStored();
            toReturn.add("Network Saturation: " + String.format("%.1f", Float.valueOf(saturation)) + "%");
        }
        return toReturn;
    }

    public void sendTileInfoToPlayer(EntityPlayer thePlayer) {
        List tileInfo = this.getTileInfo();
        for (int i = 0; i < tileInfo.size(); ++i) {
            thePlayer.func_70006_a((String)tileInfo.get(i));
        }
    }
}

