/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import cofh.util.MathHelper;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.util.energy.IPowerProviderAdv;

public class PowerProviderGrid
extends PowerProvider
implements IPowerProviderAdv {
    public static int maxNodeStorage = 1000;

    public PowerProviderGrid() {
        this.powerLoss = 0;
        this.powerLossRegularity = 72000;
        this.configure(maxNodeStorage, 0);
    }

    public void configure(int maxEnergyReceived, int maxStoredEnergy) {
        super.configure(0, 2, maxEnergyReceived, 0, maxStoredEnergy);
    }

    @Override
    public boolean update(IPowerReceptor receptor) {
        return false;
    }

    @Override
    public void receiveEnergy(float quantity, ForgeDirection from) {
        this.addEnergy(quantity);
    }

    public void setMaxEnergyStored(int nodeCount) {
        this.maxEnergyStored = nodeCount * maxNodeStorage;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void addEnergy(float quantity) {
        this.energyStored += quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        }
    }

    @Override
    public void subtractEnergy(float quantity) {
        this.energyStored -= quantity;
        if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void setEnergyStored(float quantity) {
        this.energyStored = quantity;
        if (this.energyStored > (float)this.maxEnergyStored) {
            this.energyStored = this.maxEnergyStored;
        } else if (this.energyStored < 0.0f) {
            this.energyStored = 0.0f;
        }
    }

    @Override
    public void roundEnergyStored() {
        this.energyStored = MathHelper.round((double)this.energyStored);
    }

    @Override
    public int powerRequest() {
        if (this.energyStored == (float)this.maxEnergyStored) {
            return 0;
        }
        return MathHelper.minI((int)maxNodeStorage, (int)MathHelper.ceil((double)((float)this.maxEnergyStored - this.energyStored)));
    }
}

