/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.block.conduit;

import buildcraft.api.tools.IToolWrench;
import cofh.api.block.IDismantleable;
import cofh.render.IconRegistry;
import cofh.util.BlockUtils;
import cofh.util.CoreUtils;
import cofh.util.IInitializer;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.api.item.ItemRegistry;
import thermalexpansion.block.TEBlocks;
import thermalexpansion.block.conduit.TileConduitEnergy;
import thermalexpansion.block.conduit.TileConduitLiquid;
import thermalexpansion.block.conduit.TileConduitRoot;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;
import thermalexpansion.liquid.TELiquids;
import thermalexpansion.util.Utils;
import thermalexpansion.util.crafting.TransposerManager;

public class BlockConduit
extends BlockContainer
implements IDismantleable,
IInitializer {
    public static final String[] NAMES = new String[]{"energy", "liquid", "item"};
    public static final int GROUPING = 4096;
    public static final int ITEM_ENERGY = Types.ENERGY.ordinal() * 4096;
    public static final int ITEM_LIQUID = Types.LIQUID.ordinal() * 4096;
    public static final int ITEM_ITEM_BASE = Types.ITEM_BASE.ordinal() * 4096;
    public static boolean[] enable = new boolean[Types.values().length];
    public static int renderPass = 0;
    public static ItemStack conduitEnergy;
    public static ItemStack conduitLiquid;
    public static ItemStack conduitItemBase;

    public BlockConduit(int id) {
        super(id, Material.field_76264_q);
        this.func_71848_c(3.0f);
        this.func_71894_b(150.0f);
        this.func_71884_a(field_71976_h);
        this.func_71849_a(ThermalExpansion.tab);
        this.func_71864_b("thermalexpansion.conduit");
    }

    public TileEntity func_72274_a(World world) {
        return null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (CoreUtils.isServerWorld((World)world)) {
            return null;
        }
        if (metadata == Types.ENERGY.ordinal()) {
            return new TileConduitEnergy();
        }
        if (metadata == Types.LIQUID.ordinal()) {
            return new TileConduitLiquid();
        }
        return null;
    }

    public float func_71904_a(Entity entity) {
        return this.field_72029_cc / 5.0f;
    }

    public void func_71879_a(int itemId, CreativeTabs tab, List list) {
        for (int i = 0; i < Types.values().length - 1; ++i) {
            if (!enable[i]) continue;
            list.add(new ItemStack(itemId, 1, i * 4096));
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        Item equipped;
        Item item = equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        if (player.func_70093_af()) {
            if (Utils.isHoldingUsableWrench(player, x, y, z)) {
                if (CoreUtils.isServerWorld((World)world)) {
                    this.dismantleBlock(player, world, x, y, z, false);
                    ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
                }
                return true;
            }
            return false;
        }
        if (Utils.isHoldingUsableWrench(player, x, y, z)) {
            if (CoreUtils.isServerWorld((World)world)) {
                TileConduitRoot tile = (TileConduitRoot)world.func_72796_p(x, y, z);
                if (tile == null) {
                    return false;
                }
                if (!tile.wrenchAction(player, BlockUtils.getCurrentMousedOverSide((World)world, (EntityPlayer)player))) {
                    tile.changeMode(player);
                }
                ((IToolWrench)equipped).wrenchUsed(player, x, y, z);
            }
            return true;
        }
        return false;
    }

    public void func_71861_g(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileConduitRoot theTile = null;
        if (metadata == Types.ENERGY.ordinal()) {
            theTile = new TileConduitEnergy();
        }
        if (metadata == Types.LIQUID.ordinal()) {
            theTile = new TileConduitLiquid();
        }
        world.func_72837_a(x, y, z, (TileEntity)theTile);
        TileConduitRoot tile = (TileConduitRoot)world.func_72796_p(x, y, z);
        tile.onBlockAdded();
    }

    public void func_71863_a(World world, int x, int y, int z, int blockId) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileConduitRoot) {
            ((TileConduitRoot)tile).onNeighborBlockChange();
        }
    }

    public void func_71871_a(World world, int x, int y, int z, AxisAlignedBB axis, List list, Entity entity) {
        this.func_71905_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
        super.func_71871_a(world, x, y, z, axis, list, entity);
        TileConduitRoot theTile = (TileConduitRoot)world.func_72796_p(x, y, z);
        if (theTile != null) {
            if (theTile.sideCache[0] != 0) {
                this.func_71905_a(0.3f, 0.0f, 0.3f, 0.7f, 0.7f, 0.7f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
            if (theTile.sideCache[1] != 0) {
                this.func_71905_a(0.3f, 0.3f, 0.3f, 0.7f, 1.0f, 0.7f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
            if (theTile.sideCache[2] != 0) {
                this.func_71905_a(0.3f, 0.3f, 0.0f, 0.7f, 0.7f, 0.7f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
            if (theTile.sideCache[3] != 0) {
                this.func_71905_a(0.3f, 0.3f, 0.3f, 0.7f, 0.7f, 1.0f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
            if (theTile.sideCache[4] != 0) {
                this.func_71905_a(0.0f, 0.3f, 0.3f, 0.7f, 0.7f, 0.7f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
            if (theTile.sideCache[5] != 0) {
                this.func_71905_a(0.3f, 0.3f, 0.3f, 1.0f, 0.7f, 0.7f);
                super.func_71871_a(world, x, y, z, axis, list, entity);
            }
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        double[] min = new double[]{x, y, z};
        double[] max = new double[]{x + 1, y + 1, z + 1};
        TileConduitRoot theTile = (TileConduitRoot)world.func_72796_p(x, y, z);
        if (theTile != null) {
            if (theTile.sideCache[0] == 0) {
                min[1] = min[1] + 0.3;
            }
            if (theTile.sideCache[1] == 0) {
                max[1] = max[1] - 0.3;
            }
            if (theTile.sideCache[2] == 0) {
                min[2] = min[2] + 0.3;
            }
            if (theTile.sideCache[3] == 0) {
                max[2] = max[2] - 0.3;
            }
            if (theTile.sideCache[4] == 0) {
                min[0] = min[0] + 0.3;
            }
            if (theTile.sideCache[5] == 0) {
                max[0] = max[0] - 0.3;
            }
        }
        return AxisAlignedBB.func_72330_a((double)min[0], (double)min[1], (double)min[2], (double)max[0], (double)max[1], (double)max[2]);
    }

    public void func_71902_a(IBlockAccess world, int x, int y, int z) {
        float[] min = new float[]{0.0f, 0.0f, 0.0f};
        float[] max = new float[]{1.0f, 1.0f, 1.0f};
        TileConduitRoot theTile = (TileConduitRoot)world.func_72796_p(x, y, z);
        if (theTile != null) {
            if (theTile.sideCache[0] == 0) {
                min[1] = (float)((double)min[1] + 0.3);
            }
            if (theTile.sideCache[1] == 0) {
                max[1] = (float)((double)max[1] - 0.3);
            }
            if (theTile.sideCache[2] == 0) {
                min[2] = (float)((double)min[2] + 0.3);
            }
            if (theTile.sideCache[3] == 0) {
                max[2] = (float)((double)max[2] - 0.3);
            }
            if (theTile.sideCache[4] == 0) {
                min[0] = (float)((double)min[0] + 0.3);
            }
            if (theTile.sideCache[5] == 0) {
                max[0] = (float)((double)max[0] - 0.3);
            }
        }
        this.func_71905_a(min[0], min[1], min[2], max[0], max[1], max[2]);
    }

    public int func_71899_b(int i) {
        return i * 4096;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return TEProps.renderIdConduit;
    }

    public boolean canRenderInPass(int pass) {
        renderPass = pass;
        return pass < 2;
    }

    public int func_71856_s_() {
        return 1;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileConduitRoot && tile.field_70331_k != null) {
            return ((TileConduitRoot)tile).getLightValue();
        }
        return 0;
    }

    public Icon func_71858_a(int side, int metadata) {
        return IconRegistry.getIcon((String)"HardenedGlass");
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister icon) {
    }

    public ItemStack dismantleBlock(EntityPlayer player, World world, int x, int y, int z, boolean returnBlock) {
        int metadata = world.func_72805_g(x, y, z);
        ItemStack dropBlock = new ItemStack(this.field_71990_ca, 1, metadata * 4096);
        world.func_94571_i(x, y, z);
        if (dropBlock != null && !returnBlock) {
            float f = 0.3f;
            double x2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double y2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double z2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entity = new EntityItem(world, (double)x + x2, (double)y + y2, (double)z + z2, dropBlock);
            entity.field_70293_c = 10;
            world.func_72838_d((Entity)entity);
            Utils.wrenchOutput(player.field_71092_bJ, this.field_71990_ca, 1, x, y, z);
        }
        return dropBlock;
    }

    public boolean canDismantle(EntityPlayer player, World world, int x, int y, int z) {
        return true;
    }

    public void initialize() {
        TileConduitEnergy.initialize();
        TileConduitLiquid.initialize();
        conduitEnergy = new ItemStack(TEBlocks.blockConduit, 1, ITEM_ENERGY);
        conduitLiquid = new ItemStack(TEBlocks.blockConduit, 1, ITEM_LIQUID);
        ItemRegistry.registerItem("conduitEnergy", conduitEnergy);
        ItemRegistry.registerItem("conduitLiquid", conduitLiquid);
    }

    public void loadRecipes() {
        if (enable[Types.ENERGY.ordinal()]) {
            ItemStack conduitEnergyStack = TEItems.conduitEnergyEmpty.func_77946_l();
            conduitEnergyStack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(conduitEnergyStack, new Object[]{"IGI", Character.valueOf('I'), "ingotElectrum", Character.valueOf('G'), TEBlocks.blockGlass}));
            TransposerManager.getInstance().addFillRecipe(80, TEItems.conduitEnergyEmpty, conduitEnergy, new LiquidStack(TELiquids.blockRedstone.field_71990_ca, 200), false, false);
        }
        if (enable[Types.LIQUID.ordinal()]) {
            ItemStack conduitLiquidStack = conduitLiquid.func_77946_l();
            conduitLiquidStack.field_77994_a = 4;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(conduitLiquidStack, new Object[]{"IGI", Character.valueOf('I'), "ingotCopper", Character.valueOf('G'), TEBlocks.blockGlass}));
        }
    }

    static {
        String category = "block.feature";
        BlockConduit.enable[Types.ENERGY.ordinal()] = ThermalExpansion.config.get(category, "Conduit.Energy", true);
        BlockConduit.enable[Types.LIQUID.ordinal()] = ThermalExpansion.config.get(category, "Conduit.Liquid", true);
    }

    public static enum Types {
        ENERGY,
        LIQUID,
        ITEM_BASE;

    }
}

