/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.util;

import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.oredict.ShapedOreRecipe;
import openperipheral.OpenPeripheral;

public class RecipeUtils {
    public static String page1 = "Thank you for choosing OpenPeripheral.\n\n" + "OpenPeripheral turns the majority of blocks, from a variety of mods, into ComputerCraft peripherals.\n\n";
    public static String page2 = "To get started, try placing a computer to the right to a noteblock.\n\n" + "Next, in the computer enter \"lua\" to access the lua console.\n\n" + "The lua console allows you to type code that will be instantly executed.\n\n";
    public static String page3 = "Now that you're inside Lua, type:\n\n" + "nb = peripheral.wrap(\"left\")\n\n" + "This will allow you to call functions on the noteblock.\n\n";
    public static String page4 = "To see what functions are available, type:\n\n" + "nb.listMethods()\n\n" + "As you can see, there's the method you just called, but also 'changePitch' and 'triggerNote'.\n\n";
    public static String page5 = "Try calling:\n\n" + "nb.triggerNote()\n\n" + "Did you hear it play a note? Cool huh?\n\n";
    public static String page6 = "Now try some other blocks. It's not just vanilla blocks that work, a whole range of blocks from a wide variety of mods are supported!";
    public static String page7 = "Peripheral Glasses\n" + "-----------------\n\n" + "Peripheral Glasses are a powerful new feature that let you publish information to the players HUD, and send commands via chat back to your computer. See the ComputerCraft forums for more information.";
    public static String page8 = "Peripheral Proxy\n" + "-----------------\n\n" + "You can't connect wired modems to non-solid blocks, so stick down a Peripheral Proxy next to you're block and attach your wired modem to that instead!";

    public static void addGlassesRecipe() {
        Block peripheral = RecipeUtils.getCCBlock("peripheral");
        Block cable = RecipeUtils.getCCBlock("cable");
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Item)OpenPeripheral.Items.glasses), new Object[]{"mcm", Character.valueOf('m'), new ItemStack(peripheral, 1, 4), Character.valueOf('c'), new ItemStack(cable)}));
    }

    public static void addBridgeRecipe() {
        Block peripheral = RecipeUtils.getCCBlock("peripheral");
        Block cable = RecipeUtils.getCCBlock("cable");
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)OpenPeripheral.Blocks.glassesBridge), new Object[]{"lwl", "wrw", "lwl", Character.valueOf('w'), new ItemStack(cable, 1, 1), Character.valueOf('r'), new ItemStack(Block.field_94341_cq), Character.valueOf('l'), new ItemStack(peripheral, 1, 1)}));
    }

    public static void addTicketMachineRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)OpenPeripheral.Blocks.ticketMachine), new Object[]{"iii", "iii", "igi", Character.valueOf('i'), new ItemStack(Item.field_77703_o), Character.valueOf('g'), new ItemStack(Block.field_72003_bq)}));
    }

    public static void addProxyRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)OpenPeripheral.Blocks.proxy), new Object[]{"iri", "rrr", "iri", Character.valueOf('i'), new ItemStack(Item.field_77703_o), Character.valueOf('r'), new ItemStack(Item.field_77767_aC)}));
    }

    public static void addPIMRecipe() {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack((Block)OpenPeripheral.Blocks.playerInventory), new Object[]{"ooo", "rcr", Character.valueOf('o'), new ItemStack(Block.field_72089_ap), Character.valueOf('r'), new ItemStack(Item.field_77767_aC), Character.valueOf('c'), new ItemStack((Block)Block.field_72077_au)}));
    }

    private static Block getCCBlock(String fieldName) {
        Block block = null;
        try {
            Field peripheralField;
            Class<?> cc = Class.forName("dan200.ComputerCraft$Blocks");
            if (cc != null && (peripheralField = cc.getDeclaredField(fieldName)) != null) {
                block = (Block)peripheralField.get(cc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return block;
    }

    public static ItemStack getGuideItemStack() {
        ItemStack book = new ItemStack(Item.field_77823_bG);
        NBTTagCompound bookTag = new NBTTagCompound();
        bookTag.func_74778_a("title", "OpenPeripheral Guide");
        bookTag.func_74778_a("author", "Mikee & the OpenMods team");
        NBTTagList bookPages = new NBTTagList("pages");
        bookPages.func_74742_a((NBTBase)new NBTTagString("1", page1));
        bookPages.func_74742_a((NBTBase)new NBTTagString("2", page2));
        bookPages.func_74742_a((NBTBase)new NBTTagString("3", page3));
        bookPages.func_74742_a((NBTBase)new NBTTagString("4", page4));
        bookPages.func_74742_a((NBTBase)new NBTTagString("5", page5));
        bookPages.func_74742_a((NBTBase)new NBTTagString("6", page6));
        bookPages.func_74742_a((NBTBase)new NBTTagString("7", page7));
        bookPages.func_74742_a((NBTBase)new NBTTagString("8", page8));
        bookTag.func_74782_a("pages", (NBTBase)bookPages);
        book.func_77982_d(bookTag);
        return book;
    }

    public static void addBookRecipe() {
        Block cable = RecipeUtils.getCCBlock("cable");
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(RecipeUtils.getGuideItemStack(), new Object[]{"r", "c", "b", Character.valueOf('r'), new ItemStack(Item.field_77767_aC), Character.valueOf('c'), new ItemStack(cable), Character.valueOf('b'), new ItemStack(Item.field_77760_aL)}));
    }
}

