/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;

public class PacketChunker {
    private byte packetId = 0;
    private final HashMap packetStack = new HashMap();
    public static final PacketChunker instance = new PacketChunker();

    public Packet[] createPackets(byte[] data) throws IOException {
        int start = 0;
        int maxChunkSize = 32667;
        byte numChunks = (byte)Math.ceil((double)data.length / (double)maxChunkSize);
        Packet[] packets = new Packet[numChunks];
        int META_LENGTH = 3;
        for (byte i = 0; i < numChunks; i = (byte)(i + 1)) {
            int chunkSize = Math.min(data.length - start, maxChunkSize);
            byte[] chunk = new byte[3 + chunkSize];
            chunk[0] = numChunks;
            chunk[1] = i;
            chunk[2] = this.packetId;
            System.arraycopy(data, start, chunk, 3, chunkSize);
            Packet250CustomPayload packet = new Packet250CustomPayload();
            packet.field_73630_a = "OpenPeripheral";
            packet.field_73629_c = chunk;
            packet.field_73628_b = chunk.length;
            packets[i] = packet;
            start += chunkSize;
        }
        this.packetId = (byte)(this.packetId + 1);
        return packets;
    }

    public byte[] getBytes(Packet250CustomPayload packet) throws IOException {
        DataInputStream inputStream1 = new DataInputStream(new ByteArrayInputStream(packet.field_73629_c));
        short chunkLength = inputStream1.readByte();
        byte chunkIndex = inputStream1.readByte();
        byte incomingPacketId = inputStream1.readByte();
        if (!this.packetStack.containsKey(incomingPacketId)) {
            this.packetStack.put(incomingPacketId, new byte[chunkLength][]);
        }
        byte[][] stack = (byte[][])this.packetStack.get(incomingPacketId);
        byte[] remainingBytes = new byte[packet.field_73629_c.length - 3];
        inputStream1.read(remainingBytes, 0, remainingBytes.length);
        stack[chunkIndex] = remainingBytes;
        int chunksLeft = 0;
        for (byte[] s : stack) {
            if (s != null) continue;
            chunksLeft = (byte)(chunksLeft + 1);
        }
        if (chunksLeft == 0) {
            int totalLength = 0;
            for (byte[] s : stack) {
                totalLength += s.length;
            }
            byte[] fullPacket = new byte[totalLength];
            int offset = 0;
            for (short i = 0; i < chunkLength; i = (short)(i + 1)) {
                byte[] chunkPart = stack[i];
                System.arraycopy(chunkPart, 0, fullPacket, offset, chunkPart.length);
                offset += chunkPart.length;
            }
            this.packetStack.remove(incomingPacketId);
            return fullPacket;
        }
        return null;
    }
}

