/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.tileentity;

import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import openperipheral.api.IConditionalSlots;
import openperipheral.api.IInventoryCallback;
import openperipheral.common.core.OPInventory;

public class TileEntityTicketMachine
extends TileEntity
implements IInventory,
ISidedInventory,
IInventoryCallback,
IConditionalSlots {
    public static final int[] SLOTS = new int[]{38, 34, 62, 34, 119, 34};
    protected OPInventory inventory = new OPInventory("ticketmachine", false, 3);
    private Item ticketItem;
    private boolean hasTicket = false;
    private boolean isLocked = false;
    private String owner = "TicketMachine";

    public TileEntityTicketMachine() {
        this.inventory.addCallback(this);
        ItemStack ticketStack = GameRegistry.findItemStack((String)"Railcraft", (String)"routing.ticket", (int)1);
        if (ticketStack != null) {
            this.ticketItem = ticketStack.func_77973_b();
        }
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int i) {
        return this.inventory.func_70304_b(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public String func_70303_b() {
        return this.inventory.func_70303_b();
    }

    public boolean func_94042_c() {
        return this.inventory.func_94042_c();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inventory.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (i == 2) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (i == 0 && item == Item.field_77759_aK) {
            return true;
        }
        return i == 1 && item == Item.field_77756_aW;
    }

    public boolean createTicket(String destination) {
        ItemStack paperStack = this.inventory.func_70301_a(0);
        ItemStack inkStack = this.inventory.func_70301_a(1);
        ItemStack outputStack = this.inventory.func_70301_a(2);
        try {
            if (this.func_94041_b(0, paperStack) && this.func_94041_b(1, inkStack) && outputStack == null) {
                ItemStack output = new ItemStack(this.ticketItem);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a("owner", this.owner);
                tag.func_74778_a("dest", destination);
                output.func_77982_d(tag);
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
                this.func_70299_a(2, output);
                this.field_70331_k.func_72908_a((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5, "openperipheral.ticketmachine", 0.3f, 0.6f);
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public boolean hasTicket() {
        return this.hasTicket;
    }

    public Packet func_70319_e() {
        Packet132TileEntityData packet = new Packet132TileEntityData();
        packet.field_73330_d = 0;
        packet.field_73334_a = this.field_70329_l;
        packet.field_73332_b = this.field_70330_m;
        packet.field_73333_c = this.field_70327_n;
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNetwork(nbt);
        packet.field_73331_e = nbt;
        return packet;
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData pkt) {
        this.readFromNetwork(pkt.field_73331_e);
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void readFromNetwork(NBTTagCompound tag) {
        this.hasTicket = tag.func_74767_n("hasTicket");
    }

    public void writeToNetwork(NBTTagCompound tag) {
        tag.func_74757_a("hasTicket", this.hasTicket);
    }

    public void addBlockEvent(int eventId, int eventParam) {
        this.field_70331_k.func_72965_b(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca, eventId, eventParam);
    }

    public void onBlockEventReceived(int eventId, int eventParam) {
        if (this.field_70331_k.field_72995_K && eventId == 0) {
            this.isLocked = eventParam == 1;
        }
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74757_a("locked", this.isLocked);
        this.inventory.writeToNBT(tag);
        tag.func_74778_a("owner", this.owner);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.isLocked = tag.func_74767_n("locked");
        this.inventory.readFromNBT(tag);
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_74779_i("owner");
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return i == 2;
    }

    @Override
    public void onInventoryChanged(IInventory inventory) {
        if (!this.field_70331_k.field_72995_K) {
            boolean nowHasTicket;
            boolean bl = nowHasTicket = inventory.func_70301_a(2) != null;
            if (nowHasTicket != this.hasTicket) {
                this.hasTicket = nowHasTicket;
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    @Override
    public boolean canTakeStack(int slotNumber, EntityPlayer player) {
        return slotNumber == 2 || !this.isLocked;
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.getOrientation((int)this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
    }

    public void lock() {
        this.isLocked = true;
        if (!this.field_70331_k.field_72995_K) {
            this.addBlockEvent(0, 1);
        }
    }

    public void unlock() {
        this.isLocked = false;
        if (!this.field_70331_k.field_72995_K) {
            this.addBlockEvent(0, 0);
        }
    }

    public boolean isLocked() {
        return this.isLocked;
    }
}

