/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.tileentity;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import openperipheral.common.block.BlockProxy;
import openperipheral.common.util.BlockUtils;

public class TileEntityProxy
extends TileEntity
implements IPeripheral {
    private IPeripheral peripheral;
    private boolean initialized = false;

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.initialized) {
            BlockProxy.refreshProxiedPeripheral(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
            this.initialized = true;
        }
    }

    public void setPeripheral(IPeripheral peripheral) {
        this.peripheral = peripheral;
        if (!this.field_70331_k.field_72995_K) {
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        TileEntity te;
                        int offsetX = this.field_70329_l + x;
                        int offsetY = this.field_70330_m + y;
                        int offsetZ = this.field_70327_n + z;
                        int tots = Math.abs(x) + Math.abs(y) + Math.abs(z);
                        if (tots < -1 || tots > 1 || (te = this.field_70331_k.func_72796_p(offsetX, offsetY, offsetZ)) == null || te.getClass().getName() != "dan200.computer.shared.TileEntityCable" || peripheral != null) continue;
                        int blockId = this.field_70331_k.func_72798_a(offsetX, offsetY, offsetZ);
                        int meta = this.field_70331_k.func_72805_g(offsetX, offsetY, offsetZ);
                        int subtype = TileEntityProxy.getCableSubtypeFromMetadata(meta);
                        if (subtype != 1 && subtype != 2) continue;
                        BlockUtils.dropItemStackInWorld(this.field_70331_k, offsetX, offsetY, offsetZ, new ItemStack(blockId, 1, 1));
                        if (subtype == 2) {
                            BlockUtils.dropItemStackInWorld(this.field_70331_k, offsetX, offsetY, offsetZ, new ItemStack(blockId, 1, 0));
                        }
                        this.field_70331_k.func_94571_i(offsetX, offsetY, offsetZ);
                    }
                }
            }
        }
    }

    public static int getCableSubtypeFromMetadata(int metadata) {
        if (metadata >= 0 && metadata < 6) {
            return 1;
        }
        if (metadata >= 6 && metadata < 12) {
            return 2;
        }
        return 0;
    }

    public String getType() {
        if (this.peripheral == null) {
            return null;
        }
        return this.peripheral.getType();
    }

    public String[] getMethodNames() {
        if (this.peripheral == null) {
            return new String[0];
        }
        return this.peripheral.getMethodNames();
    }

    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        if (this.peripheral == null) {
            return null;
        }
        return this.peripheral.callMethod(computer, method, arguments);
    }

    public boolean canAttachToSide(int side) {
        return true;
    }

    public void attach(IComputerAccess computer) {
        if (this.peripheral != null) {
            this.peripheral.attach(computer);
        }
    }

    public void detach(IComputerAccess computer) {
        if (this.peripheral != null) {
            this.peripheral.detach(computer);
        }
    }
}

