/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.tileentity;

import dan200.computer.api.IComputerAccess;
import dan200.computer.core.ILuaObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import openperipheral.api.IAttachable;
import openperipheral.api.IDrawable;
import openperipheral.common.drawable.DrawableBox;
import openperipheral.common.drawable.DrawableText;
import openperipheral.common.util.ByteUtils;
import openperipheral.common.util.FontSizeChecker;
import openperipheral.common.util.MiscUtils;
import openperipheral.common.util.PacketChunker;
import openperipheral.common.util.StringUtils;
import openperipheral.common.util.ThreadLock;

public class TileEntityGlassesBridge
extends TileEntity
implements IAttachable {
    public HashMap drawables = new HashMap();
    public HashMap changes = new HashMap();
    public ArrayList players = new ArrayList();
    public ArrayList newPlayers = new ArrayList();
    private ArrayList computers = new ArrayList();
    private ThreadLock lock = new ThreadLock();
    private String guid = StringUtils.randomString(8);
    private short count = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getKeyForDrawable(IDrawable d) {
        Short rtn = -1;
        try {
            this.lock.lock();
            try {
                for (Map.Entry entry : this.drawables.entrySet()) {
                    if (!((IDrawable)entry.getValue()).equals(d)) continue;
                    rtn = (Short)entry.getKey();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeleted(IDrawable d) {
        try {
            this.lock.lock();
            try {
                Short key = this.getKeyForDrawable(d);
                if (key != -1) {
                    this.changes.put(key, (short)0);
                    this.drawables.remove(key);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markChanged(IDrawable d, int slot) {
        if (slot == -1) {
            return;
        }
        try {
            this.lock.lock();
            try {
                Short key = this.getKeyForDrawable(d);
                if (key != -1) {
                    Short current = (Short)this.changes.get(key);
                    if (current == null) {
                        current = 0;
                    }
                    current = ByteUtils.set(current, slot, true);
                    current = ByteUtils.set(current, 0, true);
                    this.changes.put(key, current);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void registerPlayer(EntityPlayer player) {
        if (!this.players.contains(player.field_71092_bJ) && !this.newPlayers.contains(player.field_71092_bJ)) {
            this.newPlayers.add(player.field_71092_bJ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            try {
                this.lock.lock();
                try {
                    if (this.newPlayers.size() > 0) {
                        Packet[] fullPackets;
                        for (Packet packet : fullPackets = this.createFullPackets()) {
                            for (String playerName : this.newPlayers) {
                                EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(playerName);
                                if (player == null) continue;
                                player.field_71135_a.func_72567_b(packet);
                            }
                        }
                    }
                    if (this.players.size() > 0) {
                        Packet[] changePackets = null;
                        if (this.changes.size() > 0) {
                            changePackets = this.createChangePackets();
                        }
                        Iterator iter = this.players.iterator();
                        while (iter.hasNext()) {
                            String playerName = (String)iter.next();
                            EntityPlayerMP player = MinecraftServer.func_71276_C().func_71203_ab().func_72361_f(playerName);
                            if (player == null || !this.isPlayerValid((EntityPlayer)player)) {
                                iter.remove();
                                if (player == null) continue;
                                this.sendClearScreenToPlayer((EntityPlayer)player);
                                continue;
                            }
                            if (changePackets == null || changePackets.length <= 0) continue;
                            for (Packet packet : changePackets) {
                                player.field_71135_a.func_72567_b(packet);
                            }
                        }
                    }
                    this.changes.clear();
                    for (String newPlayer : this.newPlayers) {
                        if (this.players.contains(newPlayer)) continue;
                        this.players.add(newPlayer);
                    }
                    this.newPlayers.clear();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void sendClearScreenToPlayer(EntityPlayer player) {
        try {
            if (player instanceof EntityPlayerMP) {
                Packet[] packets;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(bos);
                outputStream.writeByte(0);
                byte[] data = bos.toByteArray();
                for (Packet p : packets = PacketChunker.instance.createPackets(data)) {
                    ((EntityPlayerMP)player).field_71135_a.func_72567_b(p);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isPlayerValid(EntityPlayer player) {
        ItemStack glasses = player.field_71071_by.func_70440_f(3);
        if (glasses == null) {
            return false;
        }
        Item item = glasses.func_77973_b();
        if (!MiscUtils.canBeGlasses(glasses)) {
            return false;
        }
        if (!glasses.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = glasses.func_77978_p();
        if (!tag.func_74764_b("openp")) {
            return false;
        }
        NBTTagCompound openPTag = tag.func_74775_l("openp");
        if (!openPTag.func_74764_b("guid")) {
            return false;
        }
        return openPTag.func_74779_i("guid").equals(this.guid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet[] createFullPackets() {
        Packet[] packets = null;
        try {
            this.lock.lock();
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(bos);
                outputStream.writeByte(1);
                outputStream.writeShort((short)this.drawables.size());
                for (Map.Entry entries : this.drawables.entrySet()) {
                    Short drawableId = (Short)entries.getKey();
                    this.writeDrawableToStream(outputStream, drawableId, (short)Short.MAX_VALUE);
                }
                packets = PacketChunker.instance.createPackets(bos.toByteArray());
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return packets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet[] createChangePackets() {
        Packet[] packets = null;
        try {
            this.lock.lock();
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
                DataOutputStream outputStream = new DataOutputStream(bos);
                outputStream.writeByte(1);
                outputStream.writeShort((short)this.changes.size());
                for (Map.Entry change : this.changes.entrySet()) {
                    Short drawableId = (Short)change.getKey();
                    Short changeMask = (Short)change.getValue();
                    this.writeDrawableToStream(outputStream, drawableId, changeMask);
                }
                packets = PacketChunker.instance.createPackets(bos.toByteArray());
                this.changes.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return packets;
    }

    private void writeDrawableToStream(DataOutputStream outputStream, short drawableId, Short changeMask) throws IOException {
        outputStream.writeShort(changeMask.shortValue());
        outputStream.writeShort(drawableId);
        if (ByteUtils.get(changeMask, 0)) {
            IDrawable drawable = (IDrawable)this.drawables.get(drawableId);
            if (drawable instanceof DrawableText) {
                outputStream.writeByte(0);
            } else {
                outputStream.writeByte(1);
            }
            drawable.writeTo(outputStream, changeMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILuaObject addText(int x, int y, String text, int color) {
        ILuaObject obj = null;
        try {
            this.lock.lock();
            try {
                this.drawables.put(this.count, new DrawableText(this, x, y, text, color));
                this.changes.put(this.count, (short)Short.MAX_VALUE);
                short s = this.count;
                this.count = (short)(s + 1);
                obj = (ILuaObject)this.drawables.get(s);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public ILuaObject addBox(int x, int y, int width, int height, int color, double alpha) throws InterruptedException {
        return this.addGradientBox(x, y, width, height, color, alpha, color, alpha, (byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILuaObject addGradientBox(int x, int y, int width, int height, int color, double alpha, int color2, double alpha2, byte gradient) throws InterruptedException {
        ILuaObject obj = null;
        try {
            this.lock.lock();
            try {
                this.drawables.put(this.count, new DrawableBox(this, x, y, width, height, color, alpha, color2, alpha2, gradient));
                this.changes.put(this.count, (short)Short.MAX_VALUE);
                short s = this.count;
                this.count = (short)(s + 1);
                obj = (ILuaObject)this.drawables.get(s);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILuaObject getById(int id) {
        this.lock.lock();
        try {
            ILuaObject iLuaObject = (ILuaObject)this.drawables.get((short)id);
            this.lock.unlock();
            return iLuaObject;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStringWidth(String str) {
        this.lock.lock();
        try {
            int n = FontSizeChecker.getInstance().getStringWidth(str);
            this.lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return str.length() * 8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short[] getAllIds() {
        this.lock.lock();
        try {
            Short[] shortArray = this.drawables.keySet().toArray(new Short[this.drawables.size()]);
            this.lock.unlock();
            return shortArray;
        }
        catch (Throwable throwable) {
            try {
                this.lock.unlock();
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.lock.lock();
            try {
                for (Short key : this.drawables.keySet()) {
                    this.changes.put(key, (short)0);
                }
                this.drawables.clear();
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getGuid() {
        return this.guid;
    }

    public void resetGuid() {
        this.guid = StringUtils.randomString(8);
    }

    public String[] getUsers() {
        return this.players.toArray(new String[this.players.size()]);
    }

    public void func_70310_b(NBTTagCompound tag) {
        super.func_70310_b(tag);
        tag.func_74778_a("guid", this.guid);
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        this.guid = tag.func_74779_i("guid");
    }

    public void onChatCommand(String command, String username) {
        for (IComputerAccess computer : this.computers) {
            computer.queueEvent("chat_command", new Object[]{command, username, this.getGuid(), computer.getAttachmentName()});
        }
    }

    @Override
    public void addComputer(IComputerAccess computer) {
        if (!this.computers.contains(computer)) {
            this.computers.add(computer);
        }
    }

    @Override
    public void removeComputer(IComputerAccess computer) {
        this.computers.remove(computer);
    }

    public static TileEntityGlassesBridge getGlassesBridgeFromStack(World worldObj, ItemStack stack) {
        NBTTagCompound tag;
        if (stack.func_77942_o() && (tag = stack.func_77978_p()).func_74764_b("openp")) {
            TileEntity tile;
            NBTTagCompound openPTag = tag.func_74775_l("openp");
            String guid = openPTag.func_74779_i("guid");
            int x = openPTag.func_74762_e("x");
            int y = openPTag.func_74762_e("y");
            int z = openPTag.func_74762_e("z");
            int d = openPTag.func_74762_e("d");
            if (worldObj == null) {
                WorldProvider provider = WorldProvider.func_76570_a((int)d);
                worldObj = provider.field_76579_a;
            }
            if (worldObj != null && d == worldObj.field_73011_w.field_76574_g && worldObj.func_72899_e(x, y, z) && (tile = worldObj.func_72796_p(x, y, z)) instanceof TileEntityGlassesBridge) {
                if (!((TileEntityGlassesBridge)tile).getGuid().equals(guid)) {
                    return null;
                }
                return (TileEntityGlassesBridge)tile;
            }
        }
        return null;
    }

    public void writeDataToGlasses(ItemStack stack) {
        NBTTagCompound tag = null;
        tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound openPTag = null;
        openPTag = tag.func_74764_b("openp") ? tag.func_74775_l("openp") : new NBTTagCompound();
        openPTag.func_74778_a("guid", this.getGuid());
        openPTag.func_74768_a("x", this.field_70329_l);
        openPTag.func_74768_a("y", this.field_70330_m);
        openPTag.func_74768_a("z", this.field_70327_n);
        openPTag.func_74768_a("d", this.field_70331_k.field_73011_w.field_76574_g);
        tag.func_74782_a("openp", (NBTBase)openPTag);
        stack.func_77982_d(tag);
    }
}

