/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.integration.vanilla;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import openperipheral.api.IMethodDefinition;
import openperipheral.common.util.InventoryUtils;

public class InventoryMoveMethod
implements IMethodDefinition {
    private String name;
    private boolean pull;

    public InventoryMoveMethod(String name, boolean pull) {
        this.name = name;
        this.pull = pull;
    }

    @Override
    public HashMap getReplacements() {
        return null;
    }

    @Override
    public String getPostScript() {
        return null;
    }

    @Override
    public boolean getCauseTileUpdate() {
        return false;
    }

    @Override
    public Class[] getRequiredParameters() {
        return new Class[]{ForgeDirection.class, Integer.TYPE, Integer.TYPE};
    }

    @Override
    public boolean isInstant() {
        return false;
    }

    @Override
    public String getLuaName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean needsSanitize() {
        return true;
    }

    @Override
    public ArrayList getRestrictions(int index) {
        return null;
    }

    @Override
    public Object execute(TileEntity tile, Object[] args) throws Exception {
        int merged = 0;
        if (tile instanceof IInventory) {
            IInventory targetInventory;
            IInventory invent;
            ForgeDirection direction = (ForgeDirection)args[0];
            if (direction == ForgeDirection.UNKNOWN) {
                return 0;
            }
            int slot = (Integer)args[1];
            int maxAmount = (Integer)args[2];
            int targetX = tile.field_70329_l + direction.offsetX;
            int targetY = tile.field_70330_m + direction.offsetY;
            int targetZ = tile.field_70327_n + direction.offsetZ;
            TileEntity targetTile = tile.field_70331_k.func_72796_p(targetX, targetY, targetZ);
            if (!(targetTile instanceof IInventory)) {
                throw new Exception("Target direction is not a valid inventory");
            }
            if (this.pull) {
                invent = (IInventory)targetTile;
                targetInventory = (IInventory)tile;
            } else {
                targetInventory = (IInventory)targetTile;
                invent = (IInventory)tile;
            }
            ItemStack stack = invent.func_70301_a(slot);
            if (stack == null) {
                return 0;
            }
            ItemStack clonedStack = stack.func_77946_l();
            int amountToMerge = clonedStack.field_77994_a = Math.min(clonedStack.field_77994_a, maxAmount);
            InventoryUtils.insertItemIntoInventory(targetInventory, clonedStack);
            merged = amountToMerge - clonedStack.field_77994_a;
            invent.func_70298_a(slot, merged);
        }
        return merged;
    }
}

