/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.drawable;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.client.renderer.Tessellator;
import openperipheral.api.IDrawable;
import openperipheral.common.drawable.BaseDrawable;
import openperipheral.common.tileentity.TileEntityGlassesBridge;
import openperipheral.common.util.ByteUtils;
import org.lwjgl.opengl.GL11;

public class DrawableBox
extends BaseDrawable
implements IDrawable {
    private short x;
    private short y;
    private short width;
    private short height;
    private int color;
    private double opacity;
    private int color2;
    private double opacity2;
    private byte gradient = 0;
    public static final int X_CHANGED = 1;
    public static final int Y_CHANGED = 2;
    public static final int WIDTH_CHANGED = 3;
    public static final int HEIGHT_CHANGED = 4;
    public static final int COLOR_CHANGED = 5;
    public static final int OPACITY_CHANGED = 6;
    public static final int COLOR2_CHANGED = 7;
    public static final int OPACITY2_CHANGED = 8;
    public static final int Z_CHANGED = 9;
    public static final int GRADIENT_CHANGED = 10;

    public DrawableBox() {
    }

    public DrawableBox(TileEntityGlassesBridge parent, int x, int y, int width, int height, int color, double alpha, int color2, double alpha2, byte gradient) {
        super(parent);
        this.x = (short)x;
        this.y = (short)y;
        this.width = (short)width;
        this.height = (short)height;
        this.color = color;
        this.opacity = alpha;
        this.color2 = color2;
        this.opacity2 = alpha2;
        this.gradient = gradient;
        this.methodNames = new String[]{"getX", "setX", "getY", "setY", "getWidth", "setWidth", "getHeight", "setHeight", "getColor", "setColor", "getOpacity", "setOpacity", "getColor2", "setColor2", "getOpacity2", "setOpacity2", "setZIndex", "getZIndex", "setGradient", "getGradient", "delete"};
    }

    @Override
    public void draw(float partialTicks) {
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        float r2 = (float)(this.color2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(this.color2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(this.color2 & 0xFF) / 255.0f;
        if (this.gradient == 0) {
            r2 = r;
            g2 = g;
            b2 = b;
            this.opacity2 = this.opacity;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glShadeModel((int)7425);
        tessellator.func_78382_b();
        tessellator.func_78369_a(r, g, b, (float)this.opacity);
        if (this.gradient == 1) {
            tessellator.func_78377_a((double)this.x, (double)this.y + (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.x + (double)this.width, (double)this.y + (double)this.height, 0.0);
        } else {
            tessellator.func_78377_a((double)this.x + (double)this.width, (double)this.y + (double)this.height, 0.0);
            tessellator.func_78377_a((double)this.x + (double)this.width, (double)this.y, 0.0);
        }
        tessellator.func_78369_a(r2, g2, b2, (float)this.opacity2);
        if (this.gradient == 1) {
            tessellator.func_78377_a((double)this.x + (double)this.width, (double)this.y, 0.0);
            tessellator.func_78377_a((double)this.x, (double)this.y, 0.0);
        } else {
            tessellator.func_78377_a((double)this.x, (double)this.y, 0.0);
            tessellator.func_78377_a((double)this.x, (double)this.y + (double)this.height, 0.0);
        }
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
    }

    public double getOpacity() {
        return this.opacity;
    }

    public double getOpacity2() {
        return this.opacity2;
    }

    public int getColor() {
        return this.color;
    }

    public byte getGradient() {
        return this.gradient;
    }

    public int getColor2() {
        return this.color2;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZIndex() {
        return this.zIndex;
    }

    @Override
    public void readFrom(DataInputStream stream, Short changeMask) {
        try {
            if (ByteUtils.get(changeMask, 1)) {
                this.x = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 2)) {
                this.y = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 3)) {
                this.width = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 4)) {
                this.height = stream.readShort();
            }
            if (ByteUtils.get(changeMask, 5)) {
                this.color = stream.readInt();
            }
            if (ByteUtils.get(changeMask, 6)) {
                this.opacity = stream.readFloat();
            }
            if (ByteUtils.get(changeMask, 7)) {
                this.color2 = stream.readInt();
            }
            if (ByteUtils.get(changeMask, 8)) {
                this.opacity2 = stream.readFloat();
            }
            if (ByteUtils.get(changeMask, 9)) {
                this.zIndex = stream.readByte();
            }
            if (ByteUtils.get(changeMask, 10)) {
                this.gradient = stream.readByte();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int setOpacity(double a) {
        if (a == this.opacity) {
            return -1;
        }
        this.opacity = a;
        return 6;
    }

    public int setOpacity2(double a2) {
        if (this.opacity2 == a2) {
            return -1;
        }
        this.opacity2 = a2;
        return 8;
    }

    public int setColor(int c) {
        if (this.color == c) {
            return -1;
        }
        this.color = c;
        return 5;
    }

    public int setColor2(int c2) {
        if (c2 == this.color2) {
            return -1;
        }
        this.color2 = c2;
        return 7;
    }

    public int setHeight(short h) {
        if (this.height == h) {
            return -1;
        }
        this.height = h;
        return 4;
    }

    public int setWidth(short w) {
        if (this.width == w) {
            return -1;
        }
        this.width = w;
        return 3;
    }

    public int setGradient(byte g) {
        if (this.gradient == g) {
            return -1;
        }
        this.gradient = g;
        return 10;
    }

    public int setX(short x2) {
        if (this.x == x2) {
            return -1;
        }
        this.x = x2;
        return 1;
    }

    public int setY(short y2) {
        if (this.y == y2) {
            return -1;
        }
        this.y = y2;
        return 2;
    }

    @Override
    public int setZIndex(byte z) {
        if (z == this.zIndex) {
            return -1;
        }
        this.zIndex = z;
        return 9;
    }

    @Override
    public void writeTo(DataOutputStream stream, Short changeMask) {
        try {
            if (ByteUtils.get(changeMask, 1)) {
                stream.writeShort(this.x);
            }
            if (ByteUtils.get(changeMask, 2)) {
                stream.writeShort(this.y);
            }
            if (ByteUtils.get(changeMask, 3)) {
                stream.writeShort(this.width);
            }
            if (ByteUtils.get(changeMask, 4)) {
                stream.writeShort(this.height);
            }
            if (ByteUtils.get(changeMask, 5)) {
                stream.writeInt(this.color);
            }
            if (ByteUtils.get(changeMask, 6)) {
                stream.writeFloat((float)this.opacity);
            }
            if (ByteUtils.get(changeMask, 7)) {
                stream.writeInt(this.color2);
            }
            if (ByteUtils.get(changeMask, 8)) {
                stream.writeFloat((float)this.opacity2);
            }
            if (ByteUtils.get(changeMask, 9)) {
                stream.writeByte(this.zIndex);
            }
            if (ByteUtils.get(changeMask, 10)) {
                stream.writeByte(this.gradient);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

