/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.drawable;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import openperipheral.api.IDrawable;
import openperipheral.common.converter.TypeConversionRegistry;
import openperipheral.common.tileentity.TileEntityGlassesBridge;
import openperipheral.common.util.ReflectionHelper;

public abstract class BaseDrawable
implements IDrawable {
    protected String[] methodNames;
    private boolean deleted = false;
    protected byte zIndex = 0;
    private WeakReference bridge;

    public BaseDrawable() {
    }

    public BaseDrawable(TileEntityGlassesBridge _bridge) {
        this.bridge = new WeakReference<TileEntityGlassesBridge>(_bridge);
    }

    public String[] getMethodNames() {
        return this.methodNames;
    }

    public Object[] callMethod(int methodId, Object[] arguments) throws Exception {
        if (this.deleted) {
            return null;
        }
        Method method = ReflectionHelper.getMethod(this.getClass(), new String[]{this.methodNames[methodId]}, arguments.length);
        ArrayList<Object> args = new ArrayList<Object>(Arrays.asList(arguments));
        if (method == null) {
            throw new Exception("Invalid number of arguments");
        }
        Class<?>[] requiredParameters = method.getParameterTypes();
        for (int i = 0; i < requiredParameters.length; ++i) {
            Object converted = TypeConversionRegistry.fromLua(args.get(i), requiredParameters[i]);
            if (converted == null) {
                throw new Exception("Invalid parameter number " + (i + 1));
            }
            args.set(i, converted);
        }
        Object[] argsToUse = args.toArray(new Object[args.size()]);
        Object v = method.invoke((Object)this, argsToUse);
        if (this.methodNames[methodId].startsWith("set") && this.bridge.get() != null) {
            ((TileEntityGlassesBridge)this.bridge.get()).markChanged(this, (Integer)v);
            return new Object[0];
        }
        return new Object[]{TypeConversionRegistry.toLua(v)};
    }

    public void delete() {
        this.deleted = true;
        if (this.bridge.get() != null) {
            ((TileEntityGlassesBridge)this.bridge.get()).setDeleted(this);
            this.bridge.clear();
        }
    }
}

