/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.definition;

import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.minecraft.tileentity.TileEntity;
import openperipheral.api.IMethodDefinition;
import openperipheral.api.IRestriction;
import openperipheral.common.restriction.RestrictionFactory;
import openperipheral.common.util.ReflectionHelper;
import org.bouncycastle.util.encoders.Base64;

public class DefinitionJsonMethod
implements IMethodDefinition {
    private ScriptEngineManager factory = new ScriptEngineManager();
    protected ScriptEngine engine = this.factory.getEngineByName("JavaScript");
    private String name;
    private String obfuscated;
    private String propertyName;
    private String script = null;
    private String postscript = null;
    private CallType callType = CallType.METHOD;
    private boolean causeTileUpdate = false;
    private Field field = null;
    private Method method = null;
    private int argumentCount = -1;
    private boolean isInstant = false;
    private HashMap replacements;
    private HashMap restrictions = new HashMap();

    public DefinitionJsonMethod(Class klazz, JsonNode json) {
        this.replacements = new HashMap();
        this.name = json.getStringValue(new Object[]{"name"});
        if (json.isNode(new Object[]{"obfuscated"})) {
            this.obfuscated = json.getStringValue(new Object[]{"obfuscated"});
        }
        if (json.isNode(new Object[]{"script"})) {
            this.script = new String(json.getStringValue(new Object[]{"script"}));
        }
        if (json.isNode(new Object[]{"postscript"})) {
            this.postscript = new String(json.getStringValue(new Object[]{"postscript"}));
        }
        if (json.isNode(new Object[]{"propertyName"})) {
            this.propertyName = json.getStringValue(new Object[]{"propertyName"});
        }
        if (json.isNode(new Object[]{"argumentCount"})) {
            this.argumentCount = Integer.parseInt(json.getNumberValue(new Object[]{"argumentCount"}));
        }
        if (json.isNode(new Object[]{"replacements"})) {
            for (JsonField replacementField : json.getNode(new Object[]{"replacements"}).getFieldList()) {
                this.replacements.put(Integer.parseInt(replacementField.getName().getText()), replacementField.getValue().getText());
            }
        }
        if (json.isNode(new Object[]{"callType"})) {
            String _callType = json.getStringValue(new Object[]{"callType"});
            if (_callType.equals("method")) {
                this.callType = CallType.METHOD;
            } else if (_callType.equals("get")) {
                this.callType = CallType.GET_PROPERTY;
            } else if (_callType.equals("set")) {
                this.callType = CallType.SET_PROPERTY;
            } else if (_callType.equals("script")) {
                this.callType = CallType.SCRIPT;
            }
        }
        if (json.isNode(new Object[]{"causeUpdate"}) && json.getStringValue(new Object[]{"causeUpdate"}).equals("true")) {
            this.causeTileUpdate = true;
        }
        if (json.isNode(new Object[]{"instant"}) && json.getStringValue(new Object[]{"instant"}).equals("true")) {
            this.isInstant = true;
        }
        if (json.isNode(new Object[]{"restrictions"})) {
            for (JsonField restrictionField : json.getNode(new Object[]{"restrictions"}).getFieldList()) {
                String stringParamId = restrictionField.getName().getText();
                JsonNode fields = restrictionField.getValue();
                int paramId = -1;
                try {
                    paramId = Integer.parseInt(stringParamId);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (paramId == -1) continue;
                ArrayList<IRestriction> paramRestrictions = new ArrayList<IRestriction>();
                for (JsonField field : fields.getFieldList()) {
                    IRestriction restriction = RestrictionFactory.createFromJson(field);
                    if (restriction == null) continue;
                    paramRestrictions.add(restriction);
                }
                if (paramRestrictions.size() <= 0) continue;
                this.restrictions.put(paramId, paramRestrictions);
            }
        }
        if (this.callType == CallType.GET_PROPERTY || this.callType == CallType.SET_PROPERTY) {
            this.field = ReflectionHelper.getField(klazz, this.propertyName, this.obfuscated);
        } else if (this.callType == CallType.METHOD) {
            this.method = ReflectionHelper.getMethod(klazz, new String[]{this.name, this.obfuscated}, this.argumentCount);
        }
    }

    public CallType getCallType() {
        return this.callType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public HashMap getReplacements() {
        return this.replacements;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public String getPostScript() {
        return this.postscript;
    }

    @Override
    public boolean getCauseTileUpdate() {
        return this.causeTileUpdate;
    }

    @Override
    public Class[] getRequiredParameters() {
        if (this.callType == CallType.METHOD) {
            return this.method.getParameterTypes();
        }
        if (this.callType == CallType.SET_PROPERTY) {
            return new Class[]{this.field.getType()};
        }
        return new Class[0];
    }

    @Override
    public boolean isInstant() {
        return this.isInstant;
    }

    @Override
    public String getLuaName() {
        return this.name;
    }

    @Override
    public boolean isValid() {
        return this.field != null || this.method != null || this.callType == CallType.SCRIPT;
    }

    @Override
    public ArrayList getRestrictions(int index) {
        return (ArrayList)this.restrictions.get(index);
    }

    @Override
    public Object execute(TileEntity tile, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ScriptException {
        if (this.callType == CallType.SCRIPT) {
            return this.executeScript(tile, args);
        }
        if (this.callType == CallType.METHOD) {
            return this.method.invoke((Object)tile, args);
        }
        if (this.callType == CallType.GET_PROPERTY) {
            return this.field.get(tile);
        }
        if (this.callType == CallType.SET_PROPERTY) {
            this.field.set(tile, args[0]);
            return true;
        }
        return null;
    }

    private Object executeScript(TileEntity tile, Object[] args) throws ScriptException {
        String script = this.getScript();
        if (script != null) {
            script = new String(Base64.decode((String)script));
            this.engine.put("tile", tile);
            this.engine.put("xCoord", tile.field_70329_l);
            this.engine.put("yCoord", tile.field_70330_m);
            this.engine.put("zCoord", tile.field_70327_n);
            this.engine.put("values", args);
            this.engine.put("worldObj", tile.field_70331_k);
            this.engine.put("env", this);
            return this.engine.eval(script);
        }
        return null;
    }

    @Override
    public boolean needsSanitize() {
        return this.getCallType() != CallType.SCRIPT;
    }

    public static enum CallType {
        METHOD,
        GET_PROPERTY,
        SET_PROPERTY,
        SCRIPT;

    }
}

