/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.config;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.relauncher.FMLRelauncher;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.Property;
import openperipheral.OpenPeripheral;

public class ConfigSettings {
    public static final String NETWORK_CHANNEL = "OpenPeripheral";
    public static int CACHE_REFRESH_INTERVAL = 7;
    public static String RESOURCE_PATH = "/mods/openperipheral";
    public static String LANGUAGE_PATH = String.format("%s/languages", RESOURCE_PATH);
    public static String TEXTURES_PATH = String.format("%s/textures", RESOURCE_PATH);
    private static String externalBase = "https://raw.github.com/mikeemoo/OpenPeripheral/master/";
    public static String EXTERNAL_LUA_LISTING = String.format("%s%s", externalBase, "mods/openperipheral/scripts.txt");
    public static String EXTERNAL_LUA_FOLDER = String.format("%s%s", externalBase, "mods/openperipheral/lua/");
    public static String LOCAL_LUA_LISTING;
    public static String LOCAL_LUA_FOLDER;
    public static boolean FRESH_INSTALL;
    public static boolean analyticsEnabled;
    public static String CACHE_FILE;
    public static String CACHE_PATH;
    public static String DATA_URL;
    public static String previousVersion;
    public static int glassesId;
    public static int glassesBridgeId;
    public static int proxyBlockId;
    public static int playerInventoryId;
    public static int ticketMachineId;
    public static boolean enabledExtendedInventory;

    public static void loadAndSaveConfig(File suggestedConfigFile) {
        Configuration configFile = new Configuration(suggestedConfigFile);
        ModContainer container = FMLCommonHandler.instance().findContainerFor((Object)OpenPeripheral.instance);
        String version = container.getVersion();
        Property prop = configFile.get("general", "enableAnalytics", true);
        prop.comment = "Do you want analytics enabled?";
        analyticsEnabled = prop.getBoolean(true);
        prop = configFile.get("general", "currentVersion", 0);
        prop.comment = "Do not edit this file. OpenPeripheral adds no blocks or items! this value should not be changed";
        previousVersion = prop.getString();
        if (version != previousVersion) {
            FRESH_INSTALL = true;
        }
        prop.set(version);
        prop = configFile.get("general", "dataUrl", DATA_URL);
        prop.comment = "The URL of the data file";
        DATA_URL = prop.getString();
        prop = configFile.get("general", "cacheFile", CACHE_FILE);
        prop.comment = "The path to the cache file";
        CACHE_FILE = prop.getString();
        prop = configFile.get("general", "cacheInterval", CACHE_REFRESH_INTERVAL);
        prop.comment = "How often the cache file gets updated (in days)";
        CACHE_REFRESH_INTERVAL = prop.getInt();
        prop = configFile.get("general", "enabledExtendedInventory", enabledExtendedInventory);
        prop.comment = "Do you wish to enable the extended inventory methods? (pull, push, swap)";
        enabledExtendedInventory = prop.getBoolean(enabledExtendedInventory);
        prop = configFile.get("items", "glassesId", glassesId);
        prop.comment = "The id of the glasses";
        glassesId = prop.getInt();
        prop = configFile.get("blocks", "bridgeId", glassesBridgeId);
        prop.comment = "The id of the glasses bridge";
        glassesBridgeId = prop.getInt();
        prop = configFile.get("blocks", "playerInventoryId", playerInventoryId);
        prop.comment = "The id of the player inventory block";
        playerInventoryId = prop.getInt();
        prop = configFile.get("blocks", "ticketMachineId", ticketMachineId);
        prop.comment = "The id of the player ticket machine";
        ticketMachineId = prop.getInt();
        prop = configFile.get("blocks", "proxyBlockId", proxyBlockId);
        prop.comment = "The id of the proxy block";
        proxyBlockId = prop.getInt();
        if (FRESH_INSTALL && analyticsEnabled) {
            ConfigSettings.analytics(container);
        }
        File baseDirectory = null;
        baseDirectory = FMLRelauncher.side() == "CLIENT" ? Minecraft.func_71380_b() : new File(".");
        File configDirectory = new File(baseDirectory, "config/");
        File cacheFile = new File(configDirectory, CACHE_FILE);
        File openPeripheralFolder = new File(baseDirectory, "openperipheral/");
        File luaFolder = new File(openPeripheralFolder, "lua/");
        LOCAL_LUA_LISTING = openPeripheralFolder.getAbsolutePath() + "/scripts.txt";
        LOCAL_LUA_FOLDER = luaFolder.getAbsolutePath();
        configFile.save();
        CACHE_PATH = cacheFile.getAbsolutePath();
    }

    private static void analytics(ModContainer container) {
        String charset = "UTF-8";
        try {
            String url = String.format("http://www.openccsensors.info/op_analytics?version=%s&side=%s&forge=%s", URLEncoder.encode(container.getVersion(), charset), URLEncoder.encode(FMLRelauncher.side(), charset), URLEncoder.encode(ForgeVersion.getVersion(), charset));
            URLConnection connection = new URL(url).openConnection();
            connection.setConnectTimeout(4000);
            connection.setRequestProperty("Accept-Charset", charset);
            InputStream response = connection.getInputStream();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        FRESH_INSTALL = false;
        analyticsEnabled = true;
        CACHE_FILE = "OpenPeripheral_methods.json";
        CACHE_PATH = "";
        DATA_URL = String.format("%s%s", externalBase, "methods_new.json");
        glassesId = 1055;
        glassesBridgeId = 580;
        proxyBlockId = 581;
        playerInventoryId = 582;
        ticketMachineId = 583;
        enabledExtendedInventory = true;
    }
}

