/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openperipheral.OpenPeripheral;
import openperipheral.common.config.ConfigSettings;
import openperipheral.common.tileentity.TileEntityTicketMachine;
import openperipheral.common.util.BlockUtils;

public class BlockTicketMachine
extends BlockContainer {
    public HashMap orientations = new HashMap();

    public BlockTicketMachine() {
        super(ConfigSettings.ticketMachineId, Material.field_76248_c);
        this.func_71848_c(0.5f);
        this.func_71849_a(OpenPeripheral.tabOpenPeripheral);
        GameRegistry.registerBlock((Block)this, (String)"ticketmachine");
        GameRegistry.registerTileEntity(TileEntityTicketMachine.class, (String)"ticketmachine");
        this.func_71864_b("openperipheral.ticketmachine");
    }

    public void func_94332_a(IconRegister register) {
        Icons.front = register.func_94245_a("openperipheral:ticketmachine_front");
        Icons.front_ticket = register.func_94245_a("openperipheral:ticketmachine_front_ticket");
        Icons.back = register.func_94245_a("openperipheral:ticketmachine_back");
        Icons.side_left = register.func_94245_a("openperipheral:ticketmachine_side_left");
        Icons.side_right = register.func_94245_a("openperipheral:ticketmachine_side_right");
        Icons.top = register.func_94245_a("openperipheral:ticketmachine_top");
        Icons.bottom = register.func_94245_a("openperipheral:ticketmachine_bottom");
        this.orientations.put(ForgeDirection.WEST, new Icon[]{Icons.bottom, Icons.top, Icons.side_right, Icons.side_left, Icons.front, Icons.back});
        this.orientations.put(ForgeDirection.EAST, new Icon[]{Icons.bottom, Icons.top, Icons.side_left, Icons.side_right, Icons.back, Icons.front});
        this.orientations.put(ForgeDirection.NORTH, new Icon[]{Icons.bottom, Icons.top, Icons.front, Icons.back, Icons.side_left, Icons.side_right});
        this.orientations.put(ForgeDirection.SOUTH, new Icon[]{Icons.bottom, Icons.top, Icons.back, Icons.front, Icons.side_right, Icons.side_left});
    }

    public Icon func_71895_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te;
        Icon ret = this.func_71858_a(side, blockAccess.func_72805_g(x, y, z));
        if (ret == Icons.front && (te = blockAccess.func_72796_p(x, y, z)) instanceof TileEntityTicketMachine && ((TileEntityTicketMachine)te).hasTicket()) {
            ret = Icons.front_ticket;
        }
        return ret;
    }

    public Icon func_71858_a(int side, int metadata) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)metadata);
        if (this.orientations.containsKey(orientation)) {
            return ((Icon[])this.orientations.get(orientation))[side];
        }
        return ((Icon[])this.orientations.get(ForgeDirection.WEST))[side];
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityTicketMachine();
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (player.func_70093_af() || tileEntity == null) {
            return false;
        }
        player.openGui((Object)OpenPeripheral.instance, OpenPeripheral.Gui.ticketMachine.ordinal(), world, x, y, z);
        return true;
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemStack) {
        super.func_71860_a(world, z, y, z, entityliving, itemStack);
        ForgeDirection orientation = BlockUtils.get2dOrientation(entityliving);
        world.func_72921_c(x, y, z, orientation.getOpposite().ordinal(), 3);
        TileEntity te = world.func_72796_p(x, y, z);
        if (te != null && te instanceof TileEntityTicketMachine && entityliving instanceof EntityPlayer) {
            ((TileEntityTicketMachine)te).setOwner(((EntityPlayer)entityliving).field_71092_bJ);
        }
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        BlockUtils.dropInventoryItems(world.func_72796_p(x, y, z));
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean func_71883_b(World world, int x, int y, int z, int eventId, int eventParam) {
        TileEntity te = world.func_72796_p(x, y, z);
        if (te instanceof TileEntityTicketMachine) {
            ((TileEntityTicketMachine)te).onBlockEventReceived(eventId, eventParam);
        }
        return true;
    }

    public static class Icons {
        public static Icon top;
        public static Icon bottom;
        public static Icon side_left;
        public static Icon side_right;
        public static Icon front;
        public static Icon front_ticket;
        public static Icon back;
    }
}

