/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.common.block;

import cpw.mods.fml.common.registry.GameRegistry;
import dan200.computer.api.IHostedPeripheral;
import dan200.computer.api.IPeripheral;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import openperipheral.OpenPeripheral;
import openperipheral.common.config.ConfigSettings;
import openperipheral.common.tileentity.TileEntityProxy;
import openperipheral.common.util.BlockUtils;

public class BlockProxy
extends BlockContainer {
    public HashMap orientations = new HashMap();

    public BlockProxy() {
        super(ConfigSettings.proxyBlockId, Material.field_76248_c);
        this.func_71848_c(0.5f);
        this.func_71849_a(OpenPeripheral.tabOpenPeripheral);
        GameRegistry.registerBlock((Block)this, (String)"proxyblock");
        GameRegistry.registerTileEntity(TileEntityProxy.class, (String)"proxyblock");
        this.func_71864_b("openperipheral.proxyblock");
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLiving entityliving, ItemStack itemStack) {
        super.func_71860_a(world, z, y, z, entityliving, itemStack);
        ForgeDirection orientation = BlockUtils.get3dOrientation(entityliving);
        world.func_72921_c(x, y, z, orientation.getOpposite().ordinal(), 3);
        BlockProxy.refreshProxiedPeripheral(world, x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int l) {
        BlockProxy.refreshProxiedPeripheral(world, x, y, z);
    }

    public static void refreshProxiedPeripheral(World world, int x, int y, int z) {
        TileEntity te = world.func_72796_p(x, y, z);
        int metaData = world.func_72805_g(x, y, z);
        ForgeDirection orientation = ForgeDirection.getOrientation((int)metaData);
        ForgeDirection behind = orientation.getOpposite();
        if (te != null && te instanceof TileEntityProxy) {
            TileEntity targetTe = world.func_72796_p(x + behind.offsetX, y + behind.offsetY, z + behind.offsetZ);
            if (targetTe != null) {
                if (targetTe instanceof IPeripheral) {
                    ((TileEntityProxy)te).setPeripheral((IPeripheral)targetTe);
                } else {
                    IHostedPeripheral peripheral = OpenPeripheral.peripheralHandler.getPeripheral(targetTe);
                    ((TileEntityProxy)te).setPeripheral((IPeripheral)peripheral);
                }
            } else {
                ((TileEntityProxy)te).setPeripheral(null);
            }
        }
    }

    public TileEntity func_72274_a(World world) {
        return new TileEntityProxy();
    }

    public void func_94332_a(IconRegister registry) {
        Icons.side_left = registry.func_94245_a("openperipheral:proxy_side_left");
        Icons.side_right = registry.func_94245_a("openperipheral:proxy_side_right");
        Icons.side_up = registry.func_94245_a("openperipheral:proxy_side_up");
        Icons.side_down = registry.func_94245_a("openperipheral:proxy_side_down");
        Icons.top = registry.func_94245_a("openperipheral:proxy_top");
        Icons.bottom = registry.func_94245_a("openperipheral:proxy_bottom");
        this.orientations.put(ForgeDirection.DOWN, new Icon[]{Icons.bottom, Icons.top, Icons.side_up, Icons.side_up, Icons.side_up, Icons.side_up});
        this.orientations.put(ForgeDirection.UP, new Icon[]{Icons.top, Icons.bottom, Icons.side_down, Icons.side_down, Icons.side_down, Icons.side_down});
        this.orientations.put(ForgeDirection.WEST, new Icon[]{Icons.side_right, Icons.side_right, Icons.side_left, Icons.side_right, Icons.bottom, Icons.top});
        this.orientations.put(ForgeDirection.EAST, new Icon[]{Icons.side_left, Icons.side_left, Icons.side_right, Icons.side_left, Icons.top, Icons.bottom});
        this.orientations.put(ForgeDirection.SOUTH, new Icon[]{Icons.side_up, Icons.side_up, Icons.top, Icons.bottom, Icons.side_left, Icons.side_right});
        this.orientations.put(ForgeDirection.NORTH, new Icon[]{Icons.side_down, Icons.side_down, Icons.bottom, Icons.top, Icons.side_right, Icons.side_left});
    }

    public Icon func_71858_a(int side, int metadata) {
        ForgeDirection orientation = ForgeDirection.getOrientation((int)metadata);
        if (this.orientations.containsKey(orientation)) {
            return ((Icon[])this.orientations.get(orientation))[side];
        }
        return Icons.side_left;
    }

    public static class Icons {
        public static Icon top;
        public static Icon bottom;
        public static Icon side_left;
        public static Icon side_right;
        public static Icon side_up;
        public static Icon side_down;
    }
}

