/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.peripherals;

import de.kilobyte22.lib.ccvalueapi.IComputerAccess;
import de.kilobyte22.lib.ccvalueapi.Peripheral;
import de.kilobyte22.lib.ccvalueapi.reflection.PeripheralFunction;
import de.kilobyte22.lib.ccvalueapi.values.LuaTable;
import de.kilobyte22.lib.ccvalueapi.values.Varargs;
import de.kilobyte22.mod.kiloperiph.KilobytesPeripherals;
import de.kilobyte22.mod.kiloperiph.api.KiloRegistry;
import de.kilobyte22.mod.kiloperiph.misc.DamageSourceZapper;
import de.kilobyte22.mod.kiloperiph.tileentity.TileEntityZapper;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;

public class PeripheralZapper
extends Peripheral {
    public static int ENERGY_BASE = KilobytesPeripherals.config.get("zapper", "energyBase", 200).getInt();

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
    }

    @PeripheralFunction(value="zap")
    public Varargs p_zap(IComputerAccess computer, Varargs args) {
        EntityPlayer p = ((TileEntityZapper)this.tileEntity).field_70331_k.func_72924_a(args.checkstring(1));
        if (p == null) {
            return new Varargs(false, "Player out of range");
        }
        int range = Math.min(KilobytesPeripherals.maxZapperRange, KilobytesPeripherals.baseZapperRange + this.getBoost());
        if (p.func_70011_f((double)((TileEntityZapper)this.tileEntity).field_70329_l, (double)((TileEntityZapper)this.tileEntity).field_70330_m, (double)((TileEntityZapper)this.tileEntity).field_70327_n) > (double)range) {
            return new Varargs(false, "Player out of range");
        }
        int amount = args.optint(2, 10);
        boolean rel = args.optbool(3, false);
        String deathMsg = args.optstring(4, null);
        if (rel) {
            amount = p.func_70630_aN() - amount;
            int n = amount = amount < 0 ? 0 : amount;
        }
        if (KilobytesPeripherals.zapperUseEnergy) {
            int energy = ENERGY_BASE;
            energy = (int)((double)energy * p.func_70011_f((double)((TileEntityZapper)this.tileEntity).field_70329_l, (double)((TileEntityZapper)this.tileEntity).field_70330_m, (double)((TileEntityZapper)this.tileEntity).field_70327_n));
            energy *= deathMsg == null ? 1 : 3;
            energy *= amount;
            if (((TileEntityZapper)this.tileEntity).getPowerProvider().getEnergyStored() < (float)energy) {
                return new Varargs(false, "Not enough energy stored");
            }
            ((TileEntityZapper)this.tileEntity).getPowerProvider().useEnergy(energy, energy, true);
        }
        return new Varargs(true, this.zap(p, amount, deathMsg));
    }

    private int getBoost() {
        int bid;
        int boost = 0;
        for (int y = ((TileEntityZapper)this.tileEntity).field_70330_m + 1; y < ((TileEntityZapper)this.tileEntity).field_70331_k.func_72800_K() && (bid = ((TileEntityZapper)this.tileEntity).field_70331_k.func_72798_a(((TileEntityZapper)this.tileEntity).field_70329_l, y, ((TileEntityZapper)this.tileEntity).field_70327_n)) != 0; ++y) {
            try {
                Block b = Block.field_71973_m[bid];
                int bo = KiloRegistry.getBoostRange(b);
                if (bo == 0) break;
                boost += bo;
                continue;
            }
            catch (Exception ex) {
                KilobytesPeripherals.log(ex);
                break;
            }
        }
        return boost;
    }

    public int zap(EntityPlayer p, int amount, String deathMsg) {
        amount = amount > p.func_70630_aN() ? p.func_70630_aN() : amount;
        boolean finalHit = false;
        if (amount == p.func_70630_aN()) {
            --amount;
            finalHit = true;
        }
        p.func_70606_j(p.func_70630_aN() - amount);
        if (finalHit) {
            p.func_70097_a((DamageSource)new DamageSourceZapper(deathMsg), 1000000);
        }
        return 0;
    }

    @PeripheralFunction(value="getRange")
    public Varargs getRange(IComputerAccess computer, Varargs args) {
        return new Varargs(KilobytesPeripherals.baseZapperRange + this.getBoost());
    }

    @PeripheralFunction(value="getEnergyStats")
    public Varargs getEnergy(IComputerAccess computer, Varargs args) {
        return new Varargs(new LuaTable().set("stored", Float.valueOf(((TileEntityZapper)this.tileEntity).getPowerProvider().getEnergyStored())).set("max", ((TileEntityZapper)this.tileEntity).getPowerProvider().getMaxEnergyStored()));
    }

    static {
        KilobytesPeripherals.config.save();
    }
}

