/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.peripherals;

import de.kilobyte22.lib.ccvalueapi.IComputerAccess;
import de.kilobyte22.lib.ccvalueapi.LuaError;
import de.kilobyte22.lib.ccvalueapi.Peripheral;
import de.kilobyte22.lib.ccvalueapi.reflection.PeripheralFunction;
import de.kilobyte22.lib.ccvalueapi.values.LuaTable;
import de.kilobyte22.lib.ccvalueapi.values.Varargs;
import de.kilobyte22.mod.kiloperiph.network.ClientConnection;
import de.kilobyte22.mod.kiloperiph.network.ConnectionException;
import de.kilobyte22.mod.kiloperiph.network.IConnectionHandler;
import de.kilobyte22.mod.kiloperiph.utils.Match;
import de.kilobyte22.mod.kiloperiph.utils.Utils;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public class PeripheralWebinterface
extends Peripheral {
    Random r = new Random();
    HashMap connections = new HashMap();

    @PeripheralFunction(value="socket_create")
    public Varargs create(IComputerAccess computer, Varargs args) throws IOException {
        int id = this.r.nextInt();
        try {
            ClientConnection connection = new ClientConnection(args.checkstring(1), args.checkint(2));
            connection.setConnectionHandler(new ConnectionHandler(id));
            this.connections.put(id, connection);
            return new Varargs(id);
        }
        catch (UnknownHostException e) {
            throw new LuaError("Could not resolve host");
        }
    }

    @PeripheralFunction(value="socket_write")
    public Varargs write(IComputerAccess computer, Varargs args) throws IOException {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        try {
            con.write(args.checkstring(2));
        }
        catch (ConnectionException e) {
            switch (e.getType()) {
                case NOT_CONNECTED: {
                    throw new LuaError("Connection was already closed");
                }
            }
        }
        return new Varargs(true);
    }

    @PeripheralFunction(value="socket_flush")
    public Varargs flush(IComputerAccess computer, Varargs args) throws IOException {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        try {
            con.flush();
        }
        catch (ConnectionException e) {
            switch (e.getType()) {
                case NOT_CONNECTED: {
                    throw new LuaError("Connection was already closed");
                }
            }
        }
        return new Varargs(true);
    }

    @PeripheralFunction(value="socket_close")
    public Varargs close(IComputerAccess computer, Varargs args) throws IOException {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        try {
            con.close();
        }
        catch (ConnectionException e) {
            switch (e.getType()) {
                case NOT_CONNECTED: {
                    throw new LuaError("Connection was already closed");
                }
            }
        }
        return new Varargs(true);
    }

    @PeripheralFunction(value="socket_setAutoFlush")
    public Varargs setAutoFlush(IComputerAccess computer, Varargs args) throws IOException {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        con.setAutoFlush(args.checkboolean(2));
        return new Varargs(true);
    }

    @PeripheralFunction(value="socket_listen")
    public Varargs listen(IComputerAccess computer, Varargs args) {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        con.listen();
        return new Varargs(true);
    }

    @PeripheralFunction(value="socket_read")
    public Varargs read(IComputerAccess computer, Varargs args) {
        ClientConnection con = (ClientConnection)this.connections.get(args.checkint(1));
        if (con == null) {
            return new Varargs(false, "Invalid Handle");
        }
        return new Varargs(con.read(args.checkint(2)));
    }

    @PeripheralFunction(value="regex_match")
    public Varargs regexmatch(IComputerAccess computer, Varargs args) {
        LuaTable ret = new LuaTable();
        List matches = Utils.getAllMatches(args.checkstring(2), args.checkstring(1));
        int idx = 1;
        for (Match match : matches) {
            LuaTable m = new LuaTable();
            m.set(0, match.getMatch());
            String[] g = match.getGroups();
            for (int i = 0; i < g.length; ++i) {
                m.set(i + 1, g[i]);
            }
            ret.set(idx++, m);
        }
        return new Varargs(ret);
    }

    private class ConnectionHandler
    implements IConnectionHandler {
        private int id;

        public ConnectionHandler(int id) {
            this.id = id;
        }

        @Override
        public void onConnectionClosed(String reason) {
            PeripheralWebinterface.this.broadcastEvent("socket_connectionClosed", this.id, new Object[]{reason});
        }

        @Override
        public void onLine(String line) {
            PeripheralWebinterface.this.broadcastEvent("socket_line", this.id, new Object[]{line});
        }
    }
}

