/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.peripherals;

import de.kilobyte22.lib.ccvalueapi.IComputerAccess;
import de.kilobyte22.lib.ccvalueapi.LuaError;
import de.kilobyte22.lib.ccvalueapi.Peripheral;
import de.kilobyte22.lib.ccvalueapi.reflection.PeripheralFunction;
import de.kilobyte22.lib.ccvalueapi.values.LuaTable;
import de.kilobyte22.lib.ccvalueapi.values.LuaValue;
import de.kilobyte22.lib.ccvalueapi.values.Varargs;
import de.kilobyte22.mod.kiloperiph.misc.ColorMode;
import net.minecraftforge.common.ForgeDirection;

public class PeripheralRednetController
extends Peripheral {
    int[][] input = new int[6][16];
    int[][] output = new int[6][16];
    ColorMode colorMode = ColorMode.WOOL;

    @PeripheralFunction(value="setColorMode")
    public Varargs setColorMode(IComputerAccess computer, Varargs args) {
        switch (args.checkint(1)) {
            case 1: {
                this.colorMode = ColorMode.WOOL;
                break;
            }
            case 2: {
                this.colorMode = ColorMode.COLOR_API;
                break;
            }
            default: {
                throw new LuaError("Invalid mode, use 1 if you plan on using wool ids (0 = white, 1 = orange, 2 = magenta, 3 = light blue etc) or 2 when using color api (1 = white, 2 = orange, 4 = magenta etc). Default is 1");
            }
        }
        return new Varargs(new Object[0]);
    }

    public int[] getValues(ForgeDirection side) {
        return this.output[side.ordinal()];
    }

    @PeripheralFunction(value="setOutputSingle")
    public Varargs setOutputSingle(IComputerAccess computer, Varargs args) {
        Integer[] colors = ColorMode.resolveColor(this.colorMode, args.checkint(2));
        if (colors.length <= 0) {
            throw new LuaError("Invalid color");
        }
        int val = args.checkint(3);
        Integer[] arr$ = colors;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int color = arr$[i$];
            this.output[ForgeDirection.valueOf((String)args.checkstring((int)1).toUpperCase()).ordinal()][color] = val;
        }
        return new Varargs(new Object[0]);
    }

    @PeripheralFunction(value="getOutputSingle")
    public Varargs getOutputSingle(IComputerAccess computer, Varargs args) {
        return new Varargs(this.output[ForgeDirection.valueOf((String)args.checkstring(1).toUpperCase()).ordinal()][ColorMode.resolveColor(this.colorMode, args.checkint(2))[0]]);
    }

    @PeripheralFunction(value="getInputSingle")
    public Varargs getInputSingle(IComputerAccess computer, Varargs args) {
        return new Varargs(this.input[ForgeDirection.valueOf((String)args.checkstring(1).toUpperCase()).ordinal()][ColorMode.resolveColor(this.colorMode, args.checkint(2))[0]]);
    }

    @PeripheralFunction(value="setOutputAll")
    public Varargs setOutputAll(IComputerAccess computer, Varargs args) {
        int[] tar = this.output[ForgeDirection.valueOf((String)args.checkstring(1).toUpperCase()).ordinal()];
        LuaTable tab = args.checktable(2);
        for (LuaValue v : tab.keySet()) {
            Integer[] arr$ = ColorMode.resolveColor(this.colorMode, v.checkint());
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                tar[i] = tab.get(v).checkint();
            }
        }
        return new Varargs(new Object[0]);
    }

    @PeripheralFunction(value="getOutputAll")
    public Varargs getOutputAll(IComputerAccess computer, Varargs args) {
        int[] tar = this.output[ForgeDirection.valueOf((String)args.checkstring(1).toUpperCase()).ordinal()];
        LuaTable ret = new LuaTable();
        for (int i = 0; i < 16; ++i) {
            ret.set(LuaValue.valueOf(ColorMode.getID(this.colorMode, i)), LuaValue.valueOf(tar[i]));
        }
        return new Varargs(ret);
    }

    @PeripheralFunction(value="getInputAll")
    public Varargs getInputAll(IComputerAccess computer, Varargs args) {
        int[] tar = this.input[ForgeDirection.valueOf((String)args.checkstring(1).toUpperCase()).ordinal()];
        LuaTable ret = new LuaTable();
        for (int i = 0; i < 16; ++i) {
            ret.set(LuaValue.valueOf(ColorMode.getID(this.colorMode, i)), LuaValue.valueOf(tar[i]));
        }
        return new Varargs(ret);
    }

    public void setValues(ForgeDirection side, int[] inputValues) {
        this.input[side.ordinal()] = inputValues;
        this.broadcastEvent("rednet_update", side.toString().toLowerCase(), new Object[0]);
    }
}

