/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.peripherals;

import de.kilobyte22.lib.ccvalueapi.IComputerAccess;
import de.kilobyte22.lib.ccvalueapi.LuaError;
import de.kilobyte22.lib.ccvalueapi.Peripheral;
import de.kilobyte22.lib.ccvalueapi.reflection.PeripheralFunction;
import de.kilobyte22.lib.ccvalueapi.values.Varargs;
import de.kilobyte22.mod.kiloperiph.api.ICPUTask;
import de.kilobyte22.mod.kiloperiph.api.KiloRegistry;
import de.kilobyte22.mod.kiloperiph.cpu.CPUState;
import de.kilobyte22.mod.kiloperiph.cpu.CPUTask;
import de.kilobyte22.mod.kiloperiph.tileentity.TileEntityCPU;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.nbt.NBTTagCompound;

public class PeripheralCPU
extends Peripheral {
    public static final float FINALBREAKTEMP = 95.0f;
    public static final float LOWESTBREAKTEMP = 75.0f;
    Queue tasklist = new LinkedList();
    CPUTask current = null;
    CPUState state = CPUState.IDLE;
    float heat = 0.0f;
    boolean loaded = false;
    int progress = 0;
    int maxprogress = 0;

    @PeripheralFunction(value="doTask")
    public Varargs doTask(IComputerAccess access, Varargs args) {
        ICPUTask t = KiloRegistry.resolveTask(args.checkstring(1));
        if (t == null) {
            throw new LuaError("Unknown task");
        }
        if (this.current == null) {
            this.current = new CPUTask(t, args);
            this.maxprogress = this.current.getTask().getProcessingTime();
        } else {
            this.tasklist.offer(new CPUTask(t, args));
        }
        return new Varargs(new Object[0]);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.loaded = true;
        if (!nbtTagCompound.func_74764_b("heat")) {
            nbtTagCompound.func_74776_a("heat", ((TileEntityCPU)this.tileEntity).field_70331_k.func_72807_a(((TileEntityCPU)this.tileEntity).field_70329_l, ((TileEntityCPU)this.tileEntity).field_70327_n).func_76743_j() * 20.0f);
        }
        this.heat = nbtTagCompound.func_74760_g("heat");
        if (!nbtTagCompound.func_74764_b("dead")) {
            nbtTagCompound.func_74757_a("dead", false);
        }
        this.state = nbtTagCompound.func_74767_n("dead") ? CPUState.DEAD : CPUState.IDLE;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74776_a("heat", this.heat);
        nbtTagCompound.func_74757_a("dead", this.state == CPUState.DEAD);
    }

    @Override
    public void onTick() {
        if (this.current != null) {
            ++this.progress;
            if (this.progress >= this.maxprogress) {
                this.progress = 0;
                if (this.tasklist.isEmpty()) {
                    this.current = null;
                    this.maxprogress = 0;
                } else {
                    this.broadcastEvent("cpu_done", this.current.getTask().getName(), this.current.doTask());
                    this.current = (CPUTask)this.tasklist.poll();
                    this.maxprogress = this.current.getTask().getProcessingTime();
                }
            }
        }
    }
}

