/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.network;

import de.kilobyte22.mod.kiloperiph.KilobytesPeripherals;
import de.kilobyte22.mod.kiloperiph.network.ConnectionException;
import de.kilobyte22.mod.kiloperiph.network.IConnectionHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;

public class ClientConnection {
    private boolean autoFlush = false;
    private Socket socket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private IConnectionHandler handler;

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception ex) {
            KilobytesPeripherals.log(ex);
        }
    }

    public void setConnectionHandler(IConnectionHandler handler) {
        this.handler = handler;
    }

    public void close() throws ConnectionException, IOException {
        if (!this.socket.isConnected()) {
            throw new ConnectionException(ConnectionException.ExceptionType.NOT_CONNECTED);
        }
        this.socket.close();
        this.reader.close();
        this.writer.close();
    }

    public void write(String str) throws IOException, ConnectionException {
        if (!this.socket.isConnected()) {
            throw new ConnectionException(ConnectionException.ExceptionType.NOT_CONNECTED);
        }
        this.writer.write(str);
        if (this.autoFlush) {
            this.writer.flush();
        }
    }

    public void setAutoFlush(boolean value) {
        this.autoFlush = value;
    }

    public ClientConnection(String host, int port) throws IOException {
        this(new Socket(host, port));
    }

    public ClientConnection(Socket socket) throws IOException {
        this.socket = socket;
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.handler = new IConnectionHandler(){

            @Override
            public void onConnectionClosed(String reason) {
            }

            @Override
            public void onLine(String line) {
            }
        };
    }

    public void listen() {
        new Thread(new ReaderThread()).start();
    }

    public void flush() throws IOException, ConnectionException {
        if (!this.socket.isConnected()) {
            throw new ConnectionException(ConnectionException.ExceptionType.NOT_CONNECTED);
        }
        this.writer.flush();
    }

    public String read(Integer count) {
        return null;
    }

    private class ReaderThread
    implements Runnable {
        private ReaderThread() {
        }

        @Override
        public void run() {
            try {
                while (true) {
                    String line;
                    if ((line = ClientConnection.this.reader.readLine()) == null) {
                        throw new IOException("Connection closed.");
                    }
                    ClientConnection.this.handler.onLine(line);
                }
            }
            catch (IOException e) {
                KilobytesPeripherals.logDebug(e);
                ClientConnection.this.handler.onConnectionClosed(e.getMessage());
                return;
            }
        }
    }
}

