/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph.energy;

import de.kilobyte22.mod.kiloperiph.api.energy.IEnergSystem;
import de.kilobyte22.mod.kiloperiph.api.energy.IEnergyTile;
import de.kilobyte22.mod.kiloperiph.energy.EnergyTileContainer;
import java.util.HashMap;
import net.minecraft.world.World;

public class EnergySystem
implements IEnergSystem {
    private static HashMap sysLookup = new HashMap();
    private final World world;
    private HashMap tiles = new HashMap();

    private EnergySystem(World world) {
        this.world = world;
    }

    @Override
    public void addTile(IEnergyTile tile) {
        if (this.tiles.containsKey(tile)) {
            throw new RuntimeException("Energy tile already registered to EnergyNet");
        }
        EnergyTileContainer cont = new EnergyTileContainer(tile);
        this.tiles.put(tile, cont);
        new UpdateThread(cont).start();
    }

    @Override
    public void removeTile(IEnergyTile tile) {
        EnergyTileContainer cont = (EnergyTileContainer)this.tiles.get(tile);
        cont.clearConnections();
    }

    public static void tickStart() {
    }

    public static void tickEnd() {
    }

    public static EnergySystem getEnergySystem(World world) {
        EnergySystem sys = (EnergySystem)sysLookup.get(world);
        if (sys == null) {
            sys = new EnergySystem(world);
            sysLookup.put(world, sys);
        }
        return sys;
    }

    private class UpdateThread
    extends Thread {
        private final EnergyTileContainer cont;

        public UpdateThread(EnergyTileContainer cont) {
            this.cont = cont;
        }

        @Override
        public void run() {
            for (EnergyTileContainer c : EnergySystem.this.tiles.values()) {
                if (!(c.getDistanceTo(this.cont) < 20.0)) continue;
                c.addConnection(this.cont);
                this.cont.addConnection(c);
            }
        }
    }
}

