/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.mod.kiloperiph;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import de.kilobyte22.mod.kiloperiph.DefaultPPropbHandler;
import de.kilobyte22.mod.kiloperiph.api.KiloRegistry;
import de.kilobyte22.mod.kiloperiph.block.BlockContainer;
import de.kilobyte22.mod.kiloperiph.block.BlockInfiniteEnergySource;
import de.kilobyte22.mod.kiloperiph.block.BlockPlayerEditor;
import de.kilobyte22.mod.kiloperiph.block.BlockRednetController;
import de.kilobyte22.mod.kiloperiph.block.BlockWebinterface;
import de.kilobyte22.mod.kiloperiph.block.BlockZapper;
import de.kilobyte22.mod.kiloperiph.block.InvisibleBlock;
import de.kilobyte22.mod.kiloperiph.item.Item;
import de.kilobyte22.mod.kiloperiph.item.ItemDebug;
import de.kilobyte22.mod.kiloperiph.misc.TickHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraftforge.common.Configuration;

@Mod(modid="KilobytesPeripherals", name="Kilobytes Peripherals", version="4.0.25", dependencies="after:MineFactoryReloaded;after:ComputerCraft")
@NetworkMod(clientSideRequired=true, serverSideRequired=false)
public class KilobytesPeripherals {
    public static Configuration config;
    public static BlockWebinterface blockWebinterface;
    public static BlockZapper blockZapper;
    public static BlockInfiniteEnergySource blockInfiniteEnergySource;
    public static BlockRednetController blockRednetController;
    public static BlockPlayerEditor blockPlayerEditor;
    public static InvisibleBlock blockInvisible;
    public static ItemDebug itemDebug;
    @Mod.Instance(value="KilobytesPeripherals")
    public KilobytesPeripherals instance;
    private static Logger logger;
    public static boolean debug;
    public static boolean cablePlate;
    public static boolean zapperUseEnergy;
    public static int maxZapperRange;
    public static int baseZapperRange;
    public static String zapperMessageRegular;
    public static String zapperMessageSpecial;

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        logger = Logger.getLogger("KiloPeriph");
        logger.setParent(FMLLog.getLogger());
        config = new Configuration(event.getSuggestedConfigurationFile());
        logger.log(Level.INFO, "Loading Config...");
        config.load();
        itemDebug = new ItemDebug();
        debug = config.get("settings", "debug", false, "Should Kilobytes Peripherals log debug messages? (No need to turn this on unless you are told by one of the Authors)").getBoolean(false);
        cablePlate = config.get("settings", "rednetPlate", false, "Just Aestetics (client side): Should rednet cables (MFR ones) connect using a plate instead of wire?").getBoolean(false);
        maxZapperRange = config.get("zapper", "maxRange", 50, "How far can the zapper reach if boosted fully").getInt();
        baseZapperRange = config.get("zapper", "baseRrange", 10, "How far can the zapper reach").getInt();
        zapperMessageRegular = config.get("zapper", "deathmsg", "${PLAYER} was zapped", "How far can the zapper reach").getString();
        zapperMessageSpecial = config.get("zapper", "deathmsgwithcomment", "${PLAYER} was zapped (${COMMENT})", "How far can the zapper reach").getString();
        zapperUseEnergy = config.get("zapper", "useEnergy", true, "Allows you to disable energy usage. The zapper will still ACCEPT energy though").getBoolean(true);
        logger.log(Level.FINE, "Done, Saving config...");
        config.save();
        logger.log(Level.FINER, "Done");
        logger.log(Level.FINEST, "Done PreInitializing");
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        logger.log(Level.INFO, "Initializing...");
        blockWebinterface = new BlockWebinterface();
        blockZapper = new BlockZapper();
        blockInfiniteEnergySource = new BlockInfiniteEnergySource();
        blockRednetController = new BlockRednetController();
        blockPlayerEditor = new BlockPlayerEditor();
        blockInvisible = new InvisibleBlock();
        config.save();
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.SERVER);
        logger.log(Level.FINEST, "Done Initializing");
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        logger.log(Level.INFO, "PostInitializing...");
        logger.log(Level.INFO, "Registering Recipes...");
        BlockContainer.registerRecipes();
        Item.registerRecipes();
        KiloRegistry.addBoosterBlock(Block.field_72002_bp, 2);
        KiloRegistry.addBoosterBlock(Block.field_72083_ai, 5);
        KiloRegistry.addPlayerPropertyHandler(new DefaultPPropbHandler());
        logger.log(Level.FINEST, "Done PostInitializing");
    }

    public static void log(Throwable ex) {
        logger.log(Level.SEVERE, "", ex);
    }

    public static void logDebug(Exception ex) {
        if (debug) {
            KilobytesPeripherals.log(ex);
        }
    }

    public static void logDebug(String s) {
        if (debug) {
            KilobytesPeripherals.log(s);
        }
    }

    public static void logDebug(Level lvl, String s) {
        if (debug) {
            KilobytesPeripherals.log(lvl, s);
        }
    }

    public static void log(Level lvl, String s) {
        logger.log(lvl, s);
    }

    public static void log(String s) {
        logger.log(Level.INFO, s);
    }
}

