/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.lib.ccvalueapi.values;

import de.kilobyte22.lib.ccvalueapi.LuaError;
import de.kilobyte22.lib.ccvalueapi.Utils;
import de.kilobyte22.lib.ccvalueapi.values.LuaBoolean;
import de.kilobyte22.lib.ccvalueapi.values.LuaNil;
import de.kilobyte22.lib.ccvalueapi.values.LuaNumber;
import de.kilobyte22.lib.ccvalueapi.values.LuaString;
import de.kilobyte22.lib.ccvalueapi.values.LuaTable;
import de.kilobyte22.lib.ccvalueapi.values.LuaUserdata;
import java.util.HashMap;
import java.util.WeakHashMap;

public abstract class LuaValue {
    public static final LuaNil NIL = new LuaNil();
    public static final LuaBoolean FALSE = new LuaBoolean(false);
    public static final LuaBoolean TRUE = new LuaBoolean(true);
    private static WeakHashMap cache = new WeakHashMap();

    public abstract Object toObject();

    public abstract String getType();

    public static LuaValue valueOf(Object o) {
        LuaValue ret = null;
        if (o instanceof HashMap) {
            ret = new LuaTable((HashMap)o);
        } else if (o instanceof String) {
            ret = new LuaString((String)o);
        } else if (o instanceof Double) {
            ret = new LuaNumber((Double)o);
        } else if (o instanceof Integer) {
            ret = new LuaNumber((double)((Integer)o));
        } else if (o instanceof Boolean) {
            ret = (Boolean)o != false ? TRUE : FALSE;
        } else if (o == null) {
            ret = NIL;
        } else if (o instanceof Object[]) {
            LuaTable ret_ = new LuaTable();
            for (int i = 0; i < ((Object[])o).length; ++i) {
                ret_.set(new LuaNumber((double)i + 1.0), LuaValue.valueOf(((Object[])o)[i]));
            }
        } else {
            if (o instanceof LuaValue) {
                return (LuaValue)o;
            }
            ret = new LuaUserdata(o);
        }
        cache.put(o, ret);
        return ret;
    }

    public String toString() {
        return this.getType() + Utils.safeToString(this.toObject());
    }

    public int length() {
        throw new LuaError("Attempt to get length of " + this.getType());
    }

    public String checkstring() {
        if (this.getType().equals("string")) {
            return (String)this.toObject();
        }
        throw new LuaError("string expected, got " + this.getType());
    }

    public Double checknumber() {
        if (this.getType().equals("number")) {
            return (Double)this.toObject();
        }
        throw new LuaError("number expected, got " + this.getType());
    }

    public Boolean checkboolean() {
        if (this.getType().equals("boolean")) {
            return (Boolean)this.toObject();
        }
        throw new LuaError("boolean expected, got " + this.getType());
    }

    public Integer checkint() {
        if (this.getType().equals("number")) {
            return ((Double)this.toObject()).intValue();
        }
        throw new LuaError("number expected, got " + this.getType());
    }

    public LuaTable checktable() {
        if (this.getType().equals("table")) {
            return (LuaTable)this;
        }
        throw new LuaError("table expected, got " + this.getType());
    }

    public String optstring(String def) {
        if (this.getType().equals("string")) {
            return (String)this.toObject();
        }
        if (this.getType().equals("nil")) {
            return def;
        }
        throw new LuaError("string or nil expected, got " + this.getType());
    }

    public int optint(int def) {
        if (this.getType().equals("number")) {
            return ((Double)this.toObject()).intValue();
        }
        if (this.getType().equals("nil")) {
            return def;
        }
        throw new LuaError("number or nil expected, got " + this.getType());
    }

    public boolean optbool(boolean def) {
        if (this.getType().equals("boolean")) {
            return (Boolean)this.toObject();
        }
        if (this.getType().equals("nil")) {
            return def;
        }
        throw new LuaError("boolean or nil expected, got " + this.getType());
    }
}

