/*
 * Decompiled with CFR 0.152.
 */
package de.kilobyte22.lib.ccvalueapi.tileentity;

import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import de.kilobyte22.lib.ccvalueapi.ComputerAccess;
import de.kilobyte22.lib.ccvalueapi.LuaError;
import de.kilobyte22.lib.ccvalueapi.Peripheral;
import de.kilobyte22.lib.ccvalueapi.reflection.PeripheralFunction;
import de.kilobyte22.lib.ccvalueapi.values.LuaValue;
import de.kilobyte22.lib.ccvalueapi.values.Varargs;
import de.kilobyte22.mod.kiloperiph.KilobytesPeripherals;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.tileentity.TileEntity;

public abstract class PeripheralTileEntity
extends TileEntity
implements IPeripheral {
    public final LinkedList attachedComputers = new LinkedList();
    protected Peripheral peripheral = this.createPeripheral();

    public Peripheral getPeripheral() {
        return this.peripheral;
    }

    public PeripheralTileEntity() {
        this.peripheral.tileEntity = this;
    }

    @Override
    public final String[] getMethodNames() {
        ArrayList<String> ret = new ArrayList<String>();
        for (Method m : this.peripheral.getClass().getMethods()) {
            PeripheralFunction ann = m.getAnnotation(PeripheralFunction.class);
            if (ann == null) continue;
            ret.add(ann.value());
        }
        return ret.toArray(new String[0]);
    }

    @Override
    public final Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        try {
            try {
                for (Method m : this.peripheral.getClass().getMethods()) {
                    PeripheralFunction ann = m.getAnnotation(PeripheralFunction.class);
                    if (ann == null || !ann.value().equals(this.getMethodNames()[method])) continue;
                    Varargs ret = (Varargs)m.invoke((Object)this.peripheral, new ComputerAccess(computer, this), new Varargs(arguments));
                    if (ret != null) {
                        return ret.toArrayOfObject();
                    }
                    return new Object[0];
                }
                return new Object[0];
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
        catch (LuaError error) {
            if (KilobytesPeripherals.debug) {
                KilobytesPeripherals.logDebug(error);
                KilobytesPeripherals.logDebug("==More info==");
                KilobytesPeripherals.logDebug("Function: " + this.getMethodNames()[method]);
                KilobytesPeripherals.logDebug("Args: " + new Varargs(arguments).toString());
            }
            throw new Exception(error.getMessage());
        }
        catch (Throwable ex) {
            System.err.println("VM Error when calling " + this.getMethodNames()[method] + " on " + this.getType() + ":");
            ex.printStackTrace();
            Exception ex_ = new Exception("vm error: " + ex.getClass().getName() + ": " + ex.getMessage());
            ex_.initCause(ex);
            throw ex_;
        }
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
        this.attachedComputers.add(computer);
        this.peripheral.onAttach(new ComputerAccess(computer, this));
    }

    @Override
    public void detach(IComputerAccess computer) {
        this.attachedComputers.remove(computer);
        this.peripheral.onDetach(new ComputerAccess(computer, this));
    }

    public void broadcastEvent(String type, Object data1, Object ... data) {
        int i;
        Object[] params = new Object[data.length + 2];
        params[1] = data1;
        for (i = 0; i < data.length; ++i) {
            params[i + 2] = data[i];
        }
        for (i = 0; i < data.length; ++i) {
            Object p = params[i + 2];
            if (p instanceof LuaValue) {
                p = ((LuaValue)p).toObject();
            } else if (p instanceof Varargs) {
                p = ((Varargs)p).toTable().toObject();
            }
            params[i + 2] = p;
        }
        for (IComputerAccess computer : this.attachedComputers) {
            params[0] = computer.getAttachmentName();
            computer.queueEvent(type, params);
        }
    }

    public void broadcastEvent(String type, LuaValue data1, LuaValue ... data) {
        Object[] params = new Object[data.length + 2];
        params[1] = data1.toObject();
        for (int i = 0; i < data.length; ++i) {
            params[i + 2] = data[i].toObject();
        }
        for (IComputerAccess computer : this.attachedComputers) {
            params[0] = computer.getAttachmentName();
            computer.queueEvent(type, params);
        }
    }

    public void broadcastEvent(String type, Varargs args) {
        Object[] a = args.toArrayOfObject();
        Object[] params = new Object[a.length + 1];
        for (int i = 0; i < a.length; ++i) {
            params[i + 1] = a[i];
        }
        for (IComputerAccess computer : this.attachedComputers) {
            params[0] = computer.getAttachmentName();
            computer.queueEvent(type, params);
        }
    }

    public void broadcastEvent(String type) {
        for (IComputerAccess computer : this.attachedComputers) {
            computer.queueEvent(type, new Object[]{computer.getAttachmentName()});
        }
    }

    public void func_70316_g() {
        this.peripheral.onTick();
    }

    public abstract Peripheral createPeripheral();
}

