/*
 * Decompiled with CFR 0.152.
 */
package mods.mffs.common.localization;

import cpw.mods.fml.common.registry.LanguageRegistry;

public class LocalizationManager {
    private static final String LANG_RESOURCE_LOCATION = "/mods/mffs/lang/";
    private static String[] localeFiles = new String[]{"/mods/mffs/lang/en_US.xml", "/mods/mffs/lang/de_DE.xml", "/mods/mffs/lang/fi_FI.xml"};

    public static boolean isXMLLanguageFile(String fileName) {
        return fileName.endsWith(".xml");
    }

    public static String getLocaleFromFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(47) + 1, fileName.lastIndexOf(46));
    }

    public static String getLocalizedString(String key) {
        return LanguageRegistry.instance().getStringLocalization(key);
    }

    public static void loadLanguages() {
        for (String localizationFile : localeFiles) {
            LanguageRegistry.instance().loadLocalization(localizationFile, LocalizationManager.getLocaleFromFileName(localizationFile), LocalizationManager.isXMLLanguageFile(localizationFile));
        }
    }
}

